/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.benchmark;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class StaticEventLogger {
    private static final Logger log = LoggerFactory.getLogger(StaticEventLogger.class);
    private static final int EVENT_BEGIN = 49;
    private static final int EVENT_END = 48;
    private static final BufferedWriter out;

    public static void stop() {
        if (out != null) {
            try {
                String commit = StaticEventLogger.getAgentVersion();
                if (commit != null && !commit.isEmpty()) {
                    out.write("# commit=");
                    out.write(commit);
                    out.newLine();
                }
                out.write("# time=");
                out.write(String.valueOf(System.currentTimeMillis()));
                out.newLine();
                out.close();
            }
            catch (IOException e) {
                log.warn("Can't close Benchmark event recording file", e);
            }
        }
    }

    private static void writeEvent(String event, int state, long timestamp) {
        try {
            out.write(event);
            out.write(44);
            out.write(state);
            out.write(44);
            out.write(String.valueOf(timestamp));
            out.newLine();
        }
        catch (IOException e) {
            log.warn("Can't write Benchmark event recording", e);
            StaticEventLogger.stop();
        }
    }

    public static void begin(String event) {
        if (out == null) {
            return;
        }
        StaticEventLogger.writeEvent(event, 49, System.nanoTime());
    }

    public static void end(String event) {
        if (out == null) {
            return;
        }
        StaticEventLogger.writeEvent(event, 48, System.nanoTime());
    }

    private static String getAgentVersion() {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(StaticEventLogger.class.getResourceAsStream("/dd-java-agent.version")), StandardCharsets.UTF_8));){
            int c = reader.read();
            while (c != -1) {
                sb.append((char)c);
                c = reader.read();
            }
        }
        catch (IOException e) {
            return null;
        }
        return sb.toString().trim();
    }

    static {
        BufferedWriter writer = null;
        if ("true".equalsIgnoreCase(System.getProperty("dd.benchmark.enabled"))) {
            String dir = System.getProperty("dd.benchmark.output.dir");
            dir = dir != null ? dir + File.separator : "";
            String fileName = dir + "startup_" + System.currentTimeMillis() + ".csv";
            try {
                writer = new BufferedWriter(new FileWriter(fileName), 32768);
                writer.write("Event,State,Timestamp");
                writer.newLine();
            }
            catch (IOException e) {
                log.warn("Can't start Benchmark event recording", e);
            }
        }
        out = writer;
    }
}

