/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.debugger.spanorigin;

import datadog.trace.api.InstrumenterConfig;
import datadog.trace.bootstrap.debugger.DebuggerContext;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;

public class CodeOriginInfo {
    public static void entry(Method method) {
        if (InstrumenterConfig.get().isCodeOriginEnabled()) {
            String signature = Arrays.stream(method.getParameterTypes()).map(Class::getName).collect(Collectors.joining(",", "(", ")"));
            DebuggerContext.captureCodeOrigin(signature);
        }
    }

    public static void exit(AgentSpan span) {
        if (InstrumenterConfig.get().isCodeOriginEnabled()) {
            String probeId = DebuggerContext.captureCodeOrigin(null);
            if (span != null) {
                span.getLocalRootSpan().setTag(probeId, span);
            }
        }
    }
}

