/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api;

import datadog.trace.api.DDTraceId;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentSpanLink;
import datadog.trace.bootstrap.instrumentation.api.SpanAttributes;

public class SpanLink
implements AgentSpanLink {
    private final DDTraceId traceId;
    private final long spanId;
    private final byte traceFlags;
    private final String traceState;
    private final AgentSpan.Attributes attributes;

    protected SpanLink(DDTraceId traceId, long spanId, byte traceFlags, String traceState, AgentSpan.Attributes attributes) {
        this.traceId = traceId == null ? DDTraceId.ZERO : traceId;
        this.spanId = spanId;
        this.traceFlags = traceFlags;
        this.traceState = traceState == null ? "" : traceState;
        this.attributes = attributes == null ? SpanAttributes.EMPTY : attributes;
    }

    public static SpanLink from(AgentSpan.Context context) {
        return SpanLink.from(context, (byte)0, "", SpanAttributes.EMPTY);
    }

    public static SpanLink from(AgentSpan.Context context, byte traceFlags, String traceState, AgentSpan.Attributes attributes) {
        if (context.getSamplingPriority() > 0) {
            traceFlags = (byte)(traceFlags | 1);
        }
        return new SpanLink(context.getTraceId(), context.getSpanId(), traceFlags, traceState, attributes);
    }

    @Override
    public DDTraceId traceId() {
        return this.traceId;
    }

    @Override
    public long spanId() {
        return this.spanId;
    }

    @Override
    public byte traceFlags() {
        return this.traceFlags;
    }

    @Override
    public String traceState() {
        return this.traceState;
    }

    @Override
    public AgentSpan.Attributes attributes() {
        return this.attributes;
    }

    public String toString() {
        return "SpanLink{traceId=" + this.traceId + ", spanId=" + this.spanId + ", traceFlags=" + this.traceFlags + ", traceState='" + this.traceState + '\'' + ", attributes=" + this.attributes + '}';
    }
}

