/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.jfr.backpressure;

import datadog.trace.api.Config;
import datadog.trace.bootstrap.instrumentation.jfr.WindowSampler;
import datadog.trace.bootstrap.instrumentation.jfr.backpressure.BackpressureSampleEvent;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

final class BackpressureSampler
extends WindowSampler<BackpressureSampleEvent> {
    private static final Duration SAMPLING_WINDOW = Duration.of(500L, ChronoUnit.MILLIS);

    BackpressureSampler(Config config) {
        this(SAMPLING_WINDOW, BackpressureSampler.getSamplesPerWindow(config), BackpressureSampler.samplingWindowsPerRecording(config.getProfilingUploadPeriod(), SAMPLING_WINDOW));
    }

    BackpressureSampler(Duration windowDuration, int samplesPerWindow, int lookback) {
        super(windowDuration, samplesPerWindow, lookback, BackpressureSampleEvent.class);
    }

    protected static int getSamplesPerWindow(Config config) {
        return config.getProfilingBackPressureSampleLimit() / BackpressureSampler.samplingWindowsPerRecording(config.getProfilingUploadPeriod(), SAMPLING_WINDOW);
    }
}

