/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.trace.bootstrap.JsonBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;

public abstract class BootstrapInitializationTelemetry {
    public static final BootstrapInitializationTelemetry noOpInstance() {
        return NoOp.INSTANCE;
    }

    public static final BootstrapInitializationTelemetry createFromForwarderPath(String forwarderPath) {
        return new JsonBased(new ForwarderJsonSender(forwarderPath));
    }

    public abstract void initMetaInfo(String var1, String var2);

    public abstract void onAbort(String var1);

    public abstract void onError(Throwable var1);

    public abstract void onFatalError(Throwable var1);

    public abstract void onError(String var1);

    public abstract void markIncomplete();

    public abstract void finish();

    public static final class ForwarderJsonSender
    implements JsonSender {
        private final String forwarderPath;

        ForwarderJsonSender(String forwarderPath) {
            this.forwarderPath = forwarderPath;
        }

        @Override
        public void send(JsonBuffer buffer) throws IOException {
            ProcessBuilder builder = new ProcessBuilder(this.forwarderPath);
            Process process = builder.start();
            try (OutputStream out = process.getOutputStream();){
                out.write(buffer.toByteArray());
            }
            try {
                process.waitFor(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static interface JsonSender {
        public void send(JsonBuffer var1) throws IOException;
    }

    public static final class JsonBased
    extends BootstrapInitializationTelemetry {
        private final JsonSender sender;
        private JsonBuffer metaBuffer = new JsonBuffer();
        private JsonBuffer pointsBuffer = new JsonBuffer();
        private volatile boolean incomplete = false;

        JsonBased(JsonSender sender) {
            this.sender = sender;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void initMetaInfo(String attr, String value) {
            JsonBuffer jsonBuffer = this.metaBuffer;
            synchronized (jsonBuffer) {
                this.metaBuffer.name(attr).value(value);
            }
        }

        @Override
        public void onAbort(String reasonCode) {
            this.onPoint("library_entrypoint.abort", "reason:" + reasonCode);
            this.markIncomplete();
        }

        @Override
        public void onError(Throwable t) {
            this.onPoint("library_entrypoint.error", "error_type:" + t.getClass().getName());
        }

        @Override
        public void onFatalError(Throwable t) {
            this.onError(t);
            this.markIncomplete();
        }

        @Override
        public void onError(String reasonCode) {
            this.onPoint("library_entrypoint.error", "error_type:" + reasonCode);
        }

        @Override
        public void markIncomplete() {
            this.incomplete = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onPoint(String pointName) {
            JsonBuffer jsonBuffer = this.pointsBuffer;
            synchronized (jsonBuffer) {
                this.pointsBuffer.beginObject();
                this.pointsBuffer.name("name").value(pointName);
                this.pointsBuffer.endObject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onPoint(String pointName, String tag) {
            JsonBuffer jsonBuffer = this.pointsBuffer;
            synchronized (jsonBuffer) {
                this.pointsBuffer.beginObject();
                this.pointsBuffer.name("name").value(pointName);
                this.pointsBuffer.name("tags").array(tag);
                this.pointsBuffer.endObject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onPoint(String pointName, String[] tags) {
            JsonBuffer jsonBuffer = this.pointsBuffer;
            synchronized (jsonBuffer) {
                this.pointsBuffer.beginObject();
                this.pointsBuffer.name("name").value(pointName);
                this.pointsBuffer.name("tags").array(tags);
                this.pointsBuffer.endObject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish() {
            if (!this.incomplete) {
                this.onPoint("library_entrypoint.complete");
            }
            JsonBuffer buffer = new JsonBuffer();
            buffer.beginObject();
            buffer.name("metadata");
            JsonBuffer jsonBuffer = this.metaBuffer;
            synchronized (jsonBuffer) {
                buffer.object(this.metaBuffer);
            }
            buffer.name("points");
            jsonBuffer = this.pointsBuffer;
            synchronized (jsonBuffer) {
                buffer.array(this.pointsBuffer);
                this.pointsBuffer.reset();
            }
            buffer.endObject();
            try {
                this.sender.send(buffer);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static final class NoOp
    extends BootstrapInitializationTelemetry {
        static final NoOp INSTANCE = new NoOp();

        private NoOp() {
        }

        @Override
        public void initMetaInfo(String attr, String value) {
        }

        @Override
        public void onAbort(String reasonCode) {
        }

        @Override
        public void onError(String reasonCode) {
        }

        @Override
        public void onFatalError(Throwable t) {
        }

        @Override
        public void onError(Throwable t) {
        }

        @Override
        public void markIncomplete() {
        }

        @Override
        public void finish() {
        }
    }
}

