/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import java.io.ByteArrayOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class JsonBuffer
implements Flushable {
    private ByteArrayOutputStream bytesOut;
    private OutputStreamWriter writer;
    private byte[] cachedBytes = null;
    private boolean requireComma = false;

    public JsonBuffer() {
        this.reset();
    }

    public void reset() {
        this.bytesOut = new ByteArrayOutputStream();
        this.writer = new OutputStreamWriter((OutputStream)this.bytesOut, Charset.forName("utf-8"));
        this.cachedBytes = null;
        this.requireComma = false;
    }

    public JsonBuffer beginObject() {
        this.injectCommaIfNeeded();
        return this.write('{');
    }

    public JsonBuffer endObject() {
        this.endsValue();
        return this.write('}');
    }

    public JsonBuffer object(JsonBuffer objectContents) {
        this.beginObject();
        this.writeBytesRaw(objectContents.toByteArray());
        this.endObject();
        return this;
    }

    public JsonBuffer name(String name) {
        this.injectCommaIfNeeded();
        return this.writeStringLiteral(name).write(':');
    }

    public JsonBuffer nullValue() {
        this.injectCommaIfNeeded();
        this.endsValue();
        return this.writeStringRaw("null");
    }

    public JsonBuffer value(JsonBuffer buffer) {
        this.injectCommaIfNeeded();
        this.endsValue();
        return this.writeBytesRaw(buffer.toByteArray());
    }

    public JsonBuffer value(boolean value) {
        this.injectCommaIfNeeded();
        this.endsValue();
        return this.writeStringRaw(value ? "true" : "false");
    }

    public JsonBuffer value(String value) {
        this.injectCommaIfNeeded();
        this.endsValue();
        return this.writeStringLiteral(value);
    }

    public JsonBuffer value(int value) {
        this.injectCommaIfNeeded();
        this.endsValue();
        return this.writeStringRaw(Integer.toString(value));
    }

    public JsonBuffer beginArray() {
        this.injectCommaIfNeeded();
        return this.write('[');
    }

    public JsonBuffer endArray() {
        this.endsValue();
        return this.write(']');
    }

    public JsonBuffer array(String element) {
        this.beginArray();
        this.value(element);
        this.endArray();
        return this;
    }

    public JsonBuffer array(String[] elements) {
        this.beginArray();
        for (String e : elements) {
            this.value(e);
        }
        this.endArray();
        return this;
    }

    public JsonBuffer array(JsonBuffer arrayContents) {
        this.beginArray();
        this.writeBytesRaw(arrayContents.toByteArray());
        this.endArray();
        return this;
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte[] toByteArray() {
        byte[] cachedBytes = this.cachedBytes;
        if (cachedBytes != null) {
            return cachedBytes;
        }
        this.flush();
        this.cachedBytes = cachedBytes = this.bytesOut.toByteArray();
        return cachedBytes;
    }

    void injectCommaIfNeeded() {
        if (this.requireComma) {
            this.write(',');
        }
        this.requireComma = false;
    }

    void endsValue() {
        this.requireComma = true;
    }

    void clearBytesCache() {
        this.cachedBytes = null;
    }

    private JsonBuffer write(char ch) {
        this.clearBytesCache();
        try {
            this.writer.write(ch);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    private JsonBuffer writeStringLiteral(String str) {
        this.clearBytesCache();
        try {
            this.writer.write(34);
            block12: for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                switch (ch) {
                    case '\"': {
                        this.writer.write("\\\"");
                        continue block12;
                    }
                    case '\\': {
                        this.writer.write("\\\\");
                        continue block12;
                    }
                    case '/': {
                        this.writer.write("\\/");
                        continue block12;
                    }
                    case '\b': {
                        this.writer.write("\\b");
                        continue block12;
                    }
                    case '\f': {
                        this.writer.write("\\f");
                        continue block12;
                    }
                    case '\n': {
                        this.writer.write("\\n");
                        continue block12;
                    }
                    case '\r': {
                        this.writer.write("\\r");
                        continue block12;
                    }
                    case '\t': {
                        this.writer.write("\\t");
                        continue block12;
                    }
                    default: {
                        this.writer.write(ch);
                    }
                }
            }
            this.writer.write(34);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    private JsonBuffer writeStringRaw(String str) {
        this.clearBytesCache();
        try {
            this.writer.write(str);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    private JsonBuffer writeBytesRaw(byte[] bytes) {
        this.clearBytesCache();
        try {
            this.writer.flush();
            this.bytesOut.write(bytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public String toString() {
        return new String(this.toByteArray(), StandardCharsets.UTF_8);
    }
}

