/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api;

import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.Baggage;
import java.util.concurrent.atomic.AtomicInteger;

public final class ScopedContextKey<T> {
    private static final AtomicInteger INDEX_GENERATOR = new AtomicInteger(0);
    static final ScopedContextKey<AgentSpan> SPAN_KEY = ScopedContextKey.named("dd-span-key");
    static final ScopedContextKey<Baggage> BAGGAGE_KEY = ScopedContextKey.named("dd-baggage-key");
    private final String name;
    private final int index;

    private ScopedContextKey(String name) {
        this.name = name;
        this.index = INDEX_GENERATOR.getAndIncrement();
    }

    public static <T> ScopedContextKey<T> named(String name) {
        return new ScopedContextKey<T>(name);
    }

    public int index() {
        return this.index;
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.index == ((ScopedContextKey)o).index;
    }

    public String toString() {
        return this.name + '@' + this.index;
    }
}

