/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.civisibility.config;

import java.util.Objects;
import javax.annotation.Nullable;

public class TestIdentifier {
    private final String suite;
    private final String name;
    @Nullable
    private final String parameters;

    public TestIdentifier(String suite, String name, @Nullable String parameters) {
        this.suite = suite;
        this.name = name;
        this.parameters = parameters;
    }

    public String getSuite() {
        return this.suite;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getParameters() {
        return this.parameters;
    }

    public TestIdentifier withoutParameters() {
        return this.parameters == null ? this : new TestIdentifier(this.suite, this.name, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestIdentifier that = (TestIdentifier)o;
        return Objects.equals(this.suite, that.suite) && Objects.equals(this.name, that.name) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.suite, this.name, this.parameters);
    }

    public String toString() {
        return "TestIdentifier{suite='" + this.suite + '\'' + ", name='" + this.name + '\'' + ", parameters='" + this.parameters + '\'' + '}';
    }
}

