/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.git;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.git.PersonInfo;
import datadog.trace.api.git.RawParseUtils;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;

public class GitUtils {
    private static final Pattern ORIGIN_PATTERN = Pattern.compile("origin/", 16);
    private static final Pattern REFS_HEADS_PATTERN = Pattern.compile("refs/heads/", 16);
    private static final Pattern REFS_TAGS_PATTERN = Pattern.compile("refs/tags/", 16);
    private static final Pattern TAGS_PATTERN = Pattern.compile("tags/", 16);
    private static final Logger log = LoggerFactory.getLogger(GitUtils.class);
    private static final Pattern SSH_PROTOCOL_AND_USER_INFO = Pattern.compile("^(ssh://).*?@");

    public static String normalizeTag(String rawTagRef) {
        return GitUtils.normalizeRef(rawTagRef);
    }

    public static String normalizeBranch(String rawBranchRef) {
        if (GitUtils.isTagReference(rawBranchRef)) {
            return null;
        }
        return GitUtils.normalizeRef(rawBranchRef);
    }

    public static boolean isTagReference(String ref) {
        return ref != null && (ref.startsWith("tags/") || ref.contains("/tags/"));
    }

    private static String normalizeRef(String rawRef) {
        if (rawRef == null || rawRef.isEmpty()) {
            return null;
        }
        String ref = rawRef;
        if (ref.startsWith("origin")) {
            ref = ORIGIN_PATTERN.matcher(ref).replaceAll("");
        } else if (ref.startsWith("refs/heads")) {
            ref = REFS_HEADS_PATTERN.matcher(ref).replaceAll("");
        }
        if (ref.startsWith("refs/tags")) {
            return REFS_TAGS_PATTERN.matcher(ref).replaceAll("");
        }
        if (ref.startsWith("tags")) {
            return TAGS_PATTERN.matcher(ref).replaceAll("");
        }
        return ref;
    }

    public static String filterSensitiveInfo(String urlStr) {
        if (urlStr == null || urlStr.isEmpty()) {
            return null;
        }
        try {
            if (urlStr.startsWith("http")) {
                URI url = new URI(urlStr);
                String userInfo = url.getRawUserInfo();
                return Pattern.compile(userInfo + "@", 16).matcher(urlStr).replaceAll("");
            }
            return SSH_PROTOCOL_AND_USER_INFO.matcher(urlStr).replaceAll("$1");
        }
        catch (Exception ex) {
            return urlStr;
        }
    }

    public static PersonInfo splitAuthorAndEmail(String rawAuthor) {
        if (rawAuthor == null || rawAuthor.isEmpty()) {
            return PersonInfo.NOOP;
        }
        byte[] raw = rawAuthor.getBytes(StandardCharsets.UTF_8);
        boolean nameB = false;
        int emailB = RawParseUtils.nextLF(raw, 0, '<');
        int emailE = RawParseUtils.nextLF(raw, emailB, '>');
        if (emailB >= raw.length || raw[emailB] == 10 || emailE >= raw.length - 1 && raw[emailE - 1] != 62) {
            return PersonInfo.NOOP;
        }
        int nameEnd = emailB - 2 >= 0 && raw[emailB - 2] == 32 ? emailB - 2 : emailB - 1;
        String name = RawParseUtils.decode(raw, 0, nameEnd);
        String email = RawParseUtils.decode(raw, emailB, emailE - 1);
        return new PersonInfo(name, email);
    }

    /*
     * Exception decompiling
     */
    public static byte[] inflate(byte[] bytes) throws DataFormatException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 24[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void logErrorInflating(String reason) {
        log.warn("Could not decompressed git object: Reason {}", (Object)reason);
    }

    public static boolean isValidCommitSha(String commitSha) {
        if (commitSha == null || commitSha.length() < 40) {
            return false;
        }
        for (char c : commitSha.toCharArray()) {
            if (GitUtils.isHex(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }
}

