/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.telemetry;

import datadog.trace.api.telemetry.MetricCollector;
import datadog.trace.api.telemetry.RuleType;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class WafMetricCollector
implements MetricCollector<WafMetric> {
    public static WafMetricCollector INSTANCE = new WafMetricCollector();
    private static final String NAMESPACE = "appsec";
    private static final BlockingQueue<WafMetric> rawMetricsQueue = new ArrayBlockingQueue<WafMetric>(1024);
    private static final AtomicInteger wafInitCounter = new AtomicInteger();
    private static final AtomicInteger wafUpdatesCounter = new AtomicInteger();
    private static final AtomicRequestCounter wafRequestCounter = new AtomicRequestCounter();
    private static final AtomicRequestCounter wafTriggeredRequestCounter = new AtomicRequestCounter();
    private static final AtomicRequestCounter wafBlockedRequestCounter = new AtomicRequestCounter();
    private static final AtomicRequestCounter wafTimeoutRequestCounter = new AtomicRequestCounter();
    private static final AtomicLongArray raspRuleEvalCounter = new AtomicLongArray(RuleType.getNumValues());
    private static final AtomicLongArray raspRuleMatchCounter = new AtomicLongArray(RuleType.getNumValues());
    private static final AtomicLongArray raspTimeoutCounter = new AtomicLongArray(RuleType.getNumValues());
    private static final AtomicRequestCounter missingUserIdCounter = new AtomicRequestCounter();
    private static String wafVersion = "";
    private static String rulesVersion = "";

    public static WafMetricCollector get() {
        return INSTANCE;
    }

    private WafMetricCollector() {
    }

    public void wafInit(String wafVersion, String rulesVersion) {
        WafMetricCollector.wafVersion = wafVersion;
        WafMetricCollector.rulesVersion = rulesVersion;
        rawMetricsQueue.offer(new WafInitRawMetric(wafInitCounter.incrementAndGet(), wafVersion, rulesVersion));
    }

    public void wafUpdates(String rulesVersion) {
        rawMetricsQueue.offer(new WafUpdatesRawMetric(wafUpdatesCounter.incrementAndGet(), wafVersion, rulesVersion));
        if (rulesVersion != null && WafMetricCollector.rulesVersion != null && !rulesVersion.equals(WafMetricCollector.rulesVersion)) {
            WafMetricCollector.get().prepareMetrics();
        }
        WafMetricCollector.rulesVersion = rulesVersion;
    }

    public void wafRequest() {
        wafRequestCounter.increment();
    }

    public void wafRequestTriggered() {
        wafTriggeredRequestCounter.increment();
    }

    public void wafRequestBlocked() {
        wafBlockedRequestCounter.increment();
    }

    public void wafRequestTimeout() {
        wafTimeoutRequestCounter.increment();
    }

    public void raspRuleEval(RuleType ruleType) {
        raspRuleEvalCounter.incrementAndGet(ruleType.ordinal());
    }

    public void raspRuleMatch(RuleType ruleType) {
        raspRuleMatchCounter.incrementAndGet(ruleType.ordinal());
    }

    public void raspTimeout(RuleType ruleType) {
        raspTimeoutCounter.incrementAndGet(ruleType.ordinal());
    }

    public void missingUserId() {
        missingUserIdCounter.increment();
    }

    @Override
    public Collection<WafMetric> drain() {
        LinkedList<WafMetric> list;
        int drained;
        if (!rawMetricsQueue.isEmpty() && (drained = rawMetricsQueue.drainTo(list = new LinkedList<WafMetric>())) > 0) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public void prepareMetrics() {
        long counter;
        if (wafRequestCounter.get() > 0L && !rawMetricsQueue.offer(new WafRequestsRawMetric(wafRequestCounter.getAndReset(), wafVersion, rulesVersion, false, false, false))) {
            return;
        }
        if (wafTriggeredRequestCounter.get() > 0L && !rawMetricsQueue.offer(new WafRequestsRawMetric(wafTriggeredRequestCounter.getAndReset(), wafVersion, rulesVersion, true, false, false))) {
            return;
        }
        if (wafBlockedRequestCounter.get() > 0L && !rawMetricsQueue.offer(new WafRequestsRawMetric(wafBlockedRequestCounter.getAndReset(), wafVersion, rulesVersion, true, true, false))) {
            return;
        }
        if (wafTimeoutRequestCounter.get() > 0L && !rawMetricsQueue.offer(new WafRequestsRawMetric(wafTimeoutRequestCounter.getAndReset(), wafVersion, rulesVersion, false, false, true))) {
            return;
        }
        for (RuleType ruleType : RuleType.values()) {
            counter = raspRuleEvalCounter.getAndSet(ruleType.ordinal(), 0L);
            if (counter <= 0L || rawMetricsQueue.offer(new RaspRuleEval(counter, ruleType, wafVersion))) continue;
            return;
        }
        for (RuleType ruleType : RuleType.values()) {
            counter = raspRuleMatchCounter.getAndSet(ruleType.ordinal(), 0L);
            if (counter <= 0L || rawMetricsQueue.offer(new RaspRuleMatch(counter, ruleType, wafVersion))) continue;
            return;
        }
        for (RuleType ruleType : RuleType.values()) {
            counter = raspTimeoutCounter.getAndSet(ruleType.ordinal(), 0L);
            if (counter <= 0L || rawMetricsQueue.offer(new RaspTimeout(counter, ruleType, wafVersion))) continue;
            return;
        }
        long missingUserId = missingUserIdCounter.getAndReset();
        if (missingUserId > 0L && !rawMetricsQueue.offer(new MissingUserIdMetric(missingUserId))) {
            return;
        }
    }

    public static class AtomicRequestCounter {
        private final AtomicLong atomicLong = new AtomicLong();
        private volatile long timestamp;

        public final long get() {
            return this.atomicLong.get();
        }

        public final long getAndReset() {
            this.timestamp = 0L;
            return this.atomicLong.getAndSet(0L);
        }

        public final void increment() {
            if (this.timestamp == 0L) {
                this.timestamp = System.currentTimeMillis();
            }
            this.atomicLong.incrementAndGet();
        }
    }

    public static class RaspTimeout
    extends WafMetric {
        public RaspTimeout(long counter, RuleType ruleType, String wafVersion) {
            super("rasp.timeout", counter, "rule_type:" + (Object)((Object)ruleType), "waf_version:" + wafVersion);
        }
    }

    public static class RaspRuleMatch
    extends WafMetric {
        public RaspRuleMatch(long counter, RuleType ruleType, String wafVersion) {
            super("rasp.rule.match", counter, "rule_type:" + (Object)((Object)ruleType), "waf_version:" + wafVersion);
        }
    }

    public static class RaspRuleEval
    extends WafMetric {
        public RaspRuleEval(long counter, RuleType ruleType, String wafVersion) {
            super("rasp.rule.eval", counter, "rule_type:" + (Object)((Object)ruleType), "waf_version:" + wafVersion);
        }
    }

    public static class WafRequestsRawMetric
    extends WafMetric {
        public WafRequestsRawMetric(long counter, String wafVersion, String rulesVersion, boolean triggered, boolean blocked, boolean wafTimeout) {
            super("waf.requests", counter, "waf_version:" + wafVersion, "event_rules_version:" + rulesVersion, "rule_triggered:" + triggered, "request_blocked:" + blocked, "waf_timeout:" + wafTimeout);
        }
    }

    public static class MissingUserIdMetric
    extends WafMetric {
        public MissingUserIdMetric(long counter) {
            super("instrum.user_auth.missing_user_id", counter, new String[0]);
        }
    }

    public static class WafUpdatesRawMetric
    extends WafMetric {
        public WafUpdatesRawMetric(long counter, String wafVersion, String rulesVersion) {
            super("waf.updates", counter, "waf_version:" + wafVersion, "event_rules_version:" + rulesVersion);
        }
    }

    public static class WafInitRawMetric
    extends WafMetric {
        public WafInitRawMetric(long counter, String wafVersion, String rulesVersion) {
            super("waf.init", counter, "waf_version:" + wafVersion, "event_rules_version:" + rulesVersion);
        }
    }

    public static abstract class WafMetric
    extends MetricCollector.Metric {
        public WafMetric(String metricName, long counter, String ... tags) {
            super(WafMetricCollector.NAMESPACE, true, metricName, "count", (Number)counter, tags);
        }
    }
}

