/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.api.Platform;
import datadog.trace.api.StatsDClientManager;
import datadog.trace.api.WithGlobalTracer;
import datadog.trace.api.gateway.RequestContextSlot;
import datadog.trace.api.gateway.SubscriptionService;
import datadog.trace.api.profiling.ProfilingEnablement;
import datadog.trace.api.scopemanager.ScopeListener;
import datadog.trace.bootstrap.BootstrapProxy;
import datadog.trace.bootstrap.DatadogClassLoader;
import datadog.trace.bootstrap.InitializationTelemetry;
import datadog.trace.bootstrap.Library;
import datadog.trace.bootstrap.benchmark.StaticEventLogger;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.ProfilingContextIntegration;
import datadog.trace.bootstrap.instrumentation.jfr.InstrumentationBasedProfiling;
import datadog.trace.util.AgentTaskScheduler;
import datadog.trace.util.AgentThreadFactory;
import datadog.trace.util.Strings;
import datadog.trace.util.throwable.FatalAgentMisconfigurationError;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.PatternSyntaxException;

public class Agent {
    private static final String SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY = "datadog.slf4j.simpleLogger.showDateTime";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY = "datadog.slf4j.simpleLogger.dateTimeFormat";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT = "'[dd.trace 'yyyy-MM-dd HH:mm:ss:SSS Z']'";
    private static final String SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY = "datadog.slf4j.simpleLogger.defaultLogLevel";
    private static final String AGENT_INSTALLER_CLASS_NAME = "datadog.trace.agent.tooling.AgentInstaller";
    private static final int DEFAULT_JMX_START_DELAY = 15;
    private static final Logger log;
    private static final AtomicBoolean jmxStarting;
    private static ClassLoader AGENT_CLASSLOADER;
    private static volatile Runnable PROFILER_INIT_AFTER_JMX;
    private static boolean jmxFetchEnabled;
    private static boolean profilingEnabled;
    private static boolean appSecEnabled;
    private static boolean appSecFullyDisabled;
    private static boolean remoteConfigEnabled;
    private static boolean iastEnabled;
    private static boolean iastFullyDisabled;
    private static boolean cwsEnabled;
    private static boolean ciVisibilityEnabled;
    private static boolean usmEnabled;
    private static boolean telemetryEnabled;
    private static boolean debuggerEnabled;
    private static boolean exceptionDebuggingEnabled;
    private static boolean agentlessLogSubmissionEnabled;

    public static void start(Object bootstrapInitTelemetry, final Instrumentation inst, URL agentJarURL, String agentArgs) {
        boolean dataJobsEnabled;
        InitializationTelemetry initTelemetry = InitializationTelemetry.proxy(bootstrapInitTelemetry);
        StaticEventLogger.begin("Agent");
        StaticEventLogger.begin("Agent.start");
        Agent.createAgentClassloader(agentJarURL);
        if (Platform.isNativeImageBuilder()) {
            jmxFetchEnabled = false;
            remoteConfigEnabled = false;
            telemetryEnabled = false;
            Agent.startDatadogAgent(initTelemetry, inst);
            StaticEventLogger.end("Agent.start");
            return;
        }
        if (agentArgs != null && !agentArgs.isEmpty()) {
            Agent.injectAgentArgsConfig(agentArgs);
        }
        if ("true".equals(Agent.ddGetProperty("dd.integration.junit.enabled")) || "true".equals(Agent.ddGetProperty("dd.integration.testng.enabled"))) {
            Agent.setSystemPropertyDefault(AgentFeature.CIVISIBILITY.getSystemProp(), "true");
        }
        if (ciVisibilityEnabled = Agent.isFeatureEnabled(AgentFeature.CIVISIBILITY)) {
            Agent.setSystemPropertyDefault(AgentFeature.JMXFETCH.getSystemProp(), "false");
            Agent.setSystemPropertyDefault(AgentFeature.PROFILING.getSystemProp(), "false");
            Agent.setSystemPropertyDefault(AgentFeature.APPSEC.getSystemProp(), "false");
            Agent.setSystemPropertyDefault(AgentFeature.IAST.getSystemProp(), "false");
            Agent.setSystemPropertyDefault(AgentFeature.REMOTE_CONFIG.getSystemProp(), "false");
            Agent.setSystemPropertyDefault(AgentFeature.CWS.getSystemProp(), "false");
            Agent.setSystemPropertyDefault(Strings.propertyNameToSystemPropertyName("prioritization.type"), "ENSURE_TRACE");
            try {
                Agent.setSystemPropertyDefault(Strings.propertyNameToSystemPropertyName("civisibility.agent.jar.uri"), agentJarURL.toURI().toString());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Could not create URI from agent JAR URL: " + agentJarURL, e);
            }
        }
        if (dataJobsEnabled = Agent.isFeatureEnabled(AgentFeature.DATA_JOBS)) {
            log.info("Data Jobs Monitoring enabled, enabling spark integrations");
            Agent.setSystemPropertyDefault(Strings.propertyNameToSystemPropertyName("trace.experimental.long-running.enabled"), "true");
            Agent.setSystemPropertyDefault(Strings.propertyNameToSystemPropertyName("integration.spark.enabled"), "true");
            Agent.setSystemPropertyDefault(Strings.propertyNameToSystemPropertyName("integration.spark-executor.enabled"), "true");
            String javaCommand = System.getProperty("sun.java.command");
            String dataJobsCommandPattern = Config.get().getDataJobsCommandPattern();
            if (!Agent.isDataJobsSupported(javaCommand, dataJobsCommandPattern)) {
                log.warn("Data Jobs Monitoring is not compatible with non-spark command {} based on command pattern {}. dd-trace-java will not be installed", (Object)javaCommand, (Object)dataJobsCommandPattern);
                return;
            }
        }
        if (!Agent.isSupportedAppSecArch()) {
            log.debug("OS and architecture ({}/{}) not supported by AppSec, dd.appsec.enabled will default to false", (Object)System.getProperty("os.name"), (Object)System.getProperty("os.arch"));
            Agent.setSystemPropertyDefault(AgentFeature.APPSEC.getSystemProp(), "false");
        }
        jmxFetchEnabled = Agent.isFeatureEnabled(AgentFeature.JMXFETCH);
        profilingEnabled = Agent.isFeatureEnabled(AgentFeature.PROFILING);
        usmEnabled = Agent.isFeatureEnabled(AgentFeature.USM);
        appSecEnabled = Agent.isFeatureEnabled(AgentFeature.APPSEC);
        appSecFullyDisabled = Agent.isFullyDisabled(AgentFeature.APPSEC);
        iastEnabled = Agent.isFeatureEnabled(AgentFeature.IAST);
        iastFullyDisabled = Agent.isIastFullyDisabled(appSecEnabled);
        remoteConfigEnabled = Agent.isFeatureEnabled(AgentFeature.REMOTE_CONFIG) || Agent.isFeatureEnabled(AgentFeature.DEPRECATED_REMOTE_CONFIG);
        cwsEnabled = Agent.isFeatureEnabled(AgentFeature.CWS);
        telemetryEnabled = Agent.isFeatureEnabled(AgentFeature.TELEMETRY);
        debuggerEnabled = Agent.isFeatureEnabled(AgentFeature.DEBUGGER);
        exceptionDebuggingEnabled = Agent.isFeatureEnabled(AgentFeature.EXCEPTION_DEBUGGING);
        agentlessLogSubmissionEnabled = Agent.isFeatureEnabled(AgentFeature.AGENTLESS_LOG_SUBMISSION);
        if (profilingEnabled) {
            if (!Platform.isOracleJDK8()) {
                Agent.startProfilingAgent(true, inst);
            } else {
                log.debug("Oracle JDK 8 detected. Delaying profiler initialization.");
                PROFILER_INIT_AFTER_JMX = new Runnable(){

                    @Override
                    public void run() {
                        Agent.startProfilingAgent(false, inst);
                    }
                };
            }
        }
        if (cwsEnabled) {
            Agent.startCwsAgent();
        }
        AgentTaskScheduler.initialize();
        Agent.startDatadogAgent(initTelemetry, inst);
        EnumSet<Library> libraries = Library.detectLibraries(log);
        boolean appUsingCustomLogManager = Agent.isAppUsingCustomLogManager(libraries);
        boolean appUsingCustomJMXBuilder = Agent.isAppUsingCustomJMXBuilder(libraries);
        if (jmxFetchEnabled || profilingEnabled) {
            int jmxStartDelay = Agent.getJmxStartDelay();
            if (appUsingCustomJMXBuilder) {
                log.debug("Custom JMX builder detected. Delaying JMXFetch initialization.");
                Agent.registerMBeanServerBuilderCallback(new StartJmxCallback(jmxStartDelay));
                Agent.scheduleJmxStart(60 + jmxStartDelay);
            } else if (appUsingCustomLogManager) {
                log.debug("Custom logger detected. Delaying JMXFetch initialization.");
                Agent.registerLogManagerCallback(new StartJmxCallback(jmxStartDelay));
            } else {
                Agent.scheduleJmxStart(jmxStartDelay);
            }
        }
        boolean delayOkHttp = appUsingCustomLogManager && Agent.okHttpMayIndirectlyLoadJUL();
        InstallDatadogTracerCallback installDatadogTracerCallback = new InstallDatadogTracerCallback(initTelemetry, inst);
        if (delayOkHttp) {
            log.debug("Custom logger detected. Delaying Datadog Tracer initialization.");
            Agent.registerLogManagerCallback(installDatadogTracerCallback);
        } else {
            installDatadogTracerCallback.execute();
        }
        if (profilingEnabled && !Platform.isOracleJDK8()) {
            StaticEventLogger.begin("Profiling");
            if (delayOkHttp) {
                log.debug("Custom logger detected. Delaying Profiling initialization.");
                Agent.registerLogManagerCallback(new StartProfilingAgentCallback(inst));
            } else {
                Agent.startProfilingAgent(false, inst);
                InstrumentationBasedProfiling.enableInstrumentationBasedProfiling();
            }
            StaticEventLogger.end("Profiling");
        }
        StaticEventLogger.end("Agent.start");
    }

    private static void injectAgentArgsConfig(String agentArgs) {
        try {
            Class<?> agentArgsInjectorClass = AGENT_CLASSLOADER.loadClass("datadog.trace.bootstrap.config.provider.AgentArgsInjector");
            Method registerCallbackMethod = agentArgsInjectorClass.getMethod("injectAgentArgsConfig", String.class);
            registerCallbackMethod.invoke(null, agentArgs);
        }
        catch (Exception ex) {
            log.error("Error injecting agent args config {}", (Object)agentArgs, (Object)ex);
        }
    }

    public static void shutdown(boolean sync) {
        StaticEventLogger.end("Agent");
        StaticEventLogger.stop();
        if (profilingEnabled) {
            Agent.shutdownProfilingAgent(sync);
        }
        if (telemetryEnabled) {
            Agent.stopTelemetry();
        }
        if (agentlessLogSubmissionEnabled) {
            Agent.shutdownLogsIntake();
        }
    }

    public static synchronized Class<?> installAgentCLI() throws Exception {
        if (null == AGENT_CLASSLOADER) {
            CodeSource codeSource = Agent.class.getProtectionDomain().getCodeSource();
            if (codeSource == null || codeSource.getLocation() == null) {
                throw new MalformedURLException("Could not get jar location from code source");
            }
            Agent.createAgentClassloader(codeSource.getLocation());
        }
        return AGENT_CLASSLOADER.loadClass("datadog.trace.agent.tooling.AgentCLI");
    }

    public static void startDatadogTracer(InitializationTelemetry initTelemetry) throws Exception {
        Class<?> scoClass = AGENT_CLASSLOADER.loadClass("datadog.communication.ddagent.SharedCommunicationObjects");
        Agent.installDatadogTracer(initTelemetry, scoClass, scoClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        Agent.startJmx();
    }

    private static void registerLogManagerCallback(ClassLoadCallBack callback) {
        try {
            Class<?> agentInstallerClass = AGENT_CLASSLOADER.loadClass(AGENT_INSTALLER_CLASS_NAME);
            Method registerCallbackMethod = agentInstallerClass.getMethod("registerClassLoadCallback", String.class, Runnable.class);
            registerCallbackMethod.invoke(null, "java.util.logging.LogManager", callback);
        }
        catch (Exception ex) {
            log.error("Error registering callback for {}", (Object)callback.agentThread(), (Object)ex);
        }
    }

    private static void registerMBeanServerBuilderCallback(ClassLoadCallBack callback) {
        try {
            Class<?> agentInstallerClass = AGENT_CLASSLOADER.loadClass(AGENT_INSTALLER_CLASS_NAME);
            Method registerCallbackMethod = agentInstallerClass.getMethod("registerClassLoadCallback", String.class, Runnable.class);
            registerCallbackMethod.invoke(null, "javax.management.MBeanServerBuilder", callback);
        }
        catch (Exception ex) {
            log.error("Error registering callback for {}", (Object)callback.agentThread(), (Object)ex);
        }
    }

    private static synchronized void createAgentClassloader(URL agentJarURL) {
        if (AGENT_CLASSLOADER == null) {
            try {
                BootstrapProxy.addBootstrapResource(agentJarURL);
                ClassLoader parent = Agent.class.getClassLoader();
                if (parent == null && Platform.isJavaVersionAtLeast(9)) {
                    parent = Agent.getPlatformClassLoader();
                }
                AGENT_CLASSLOADER = new DatadogClassLoader(agentJarURL, parent);
            }
            catch (Throwable ex) {
                log.error("Throwable thrown creating agent classloader", ex);
            }
        }
    }

    private static void maybeStartRemoteConfig(Class<?> scoClass, Object sco) {
        if (!remoteConfigEnabled) {
            return;
        }
        StaticEventLogger.begin("Remote Config");
        try {
            Method pollerMethod = scoClass.getMethod("configurationPoller", Config.class);
            Object poller = pollerMethod.invoke(sco, Config.get());
            if (poller == null) {
                log.debug("Remote config is not enabled");
                StaticEventLogger.end("Remote Config");
                return;
            }
            Class<?> pollerCls = AGENT_CLASSLOADER.loadClass("datadog.remoteconfig.ConfigurationPoller");
            Method startMethod = pollerCls.getMethod("start", new Class[0]);
            log.debug("Starting remote config poller");
            startMethod.invoke(poller, new Object[0]);
        }
        catch (Exception e) {
            log.error("Error starting remote config", e);
        }
        StaticEventLogger.end("Remote Config");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void startDatadogAgent(InitializationTelemetry initTelemetry, Instrumentation inst) {
        if (null != inst) {
            StaticEventLogger.begin("BytebuddyAgent");
            try {
                Class<?> agentInstallerClass = AGENT_CLASSLOADER.loadClass(AGENT_INSTALLER_CLASS_NAME);
                Method agentInstallerMethod = agentInstallerClass.getMethod("installBytebuddyAgent", Instrumentation.class);
                agentInstallerMethod.invoke(null, inst);
            }
            catch (Throwable ex) {
                log.error("Throwable thrown while installing the Datadog Agent", ex);
                initTelemetry.onFatalError(ex);
            }
            finally {
                StaticEventLogger.end("BytebuddyAgent");
            }
        }
    }

    private static synchronized void installDatadogTracer(InitializationTelemetry initTelemetry, Class<?> scoClass, Object sco) {
        if (AGENT_CLASSLOADER == null) {
            throw new IllegalStateException("Datadog agent should have been started already");
        }
        StaticEventLogger.begin("GlobalTracer");
        try {
            Class<?> tracerInstallerClass = AGENT_CLASSLOADER.loadClass("datadog.trace.agent.tooling.TracerInstaller");
            Method tracerInstallerMethod = tracerInstallerClass.getMethod("installGlobalTracer", scoClass, ProfilingContextIntegration.class);
            tracerInstallerMethod.invoke(null, sco, Agent.createProfilingContextIntegration());
        }
        catch (FatalAgentMisconfigurationError ex) {
            throw ex;
        }
        catch (Throwable ex) {
            log.error("Throwable thrown while installing the Datadog Tracer", ex);
            initTelemetry.onFatalError(ex);
        }
        StaticEventLogger.end("GlobalTracer");
    }

    private static void scheduleJmxStart(int jmxStartDelay) {
        if (jmxStartDelay > 0) {
            AgentTaskScheduler.INSTANCE.scheduleWithJitter(new JmxStartTask(), jmxStartDelay, TimeUnit.SECONDS);
        } else {
            Agent.startJmx();
        }
    }

    private static synchronized void startJmx() {
        if (AGENT_CLASSLOADER == null) {
            throw new IllegalStateException("Datadog agent should have been started already");
        }
        if (jmxStarting.getAndSet(true)) {
            return;
        }
        Agent.initializeErrorTracking();
        if (jmxFetchEnabled) {
            Agent.startJmxFetch();
        }
        Agent.initializeJmxSystemAccessProvider(AGENT_CLASSLOADER);
        if (profilingEnabled) {
            Agent.registerDeadlockDetectionEvent();
            Agent.registerSmapEntryEvent();
            if (PROFILER_INIT_AFTER_JMX != null) {
                if (Agent.getJmxStartDelay() == 0) {
                    log.debug("Waiting for profiler initialization");
                    AgentTaskScheduler.INSTANCE.scheduleWithJitter(PROFILER_INIT_AFTER_JMX, 500L, TimeUnit.MILLISECONDS);
                } else {
                    log.debug("Initializing profiler");
                    PROFILER_INIT_AFTER_JMX.run();
                }
                PROFILER_INIT_AFTER_JMX = null;
            }
        }
    }

    private static synchronized void registerDeadlockDetectionEvent() {
        log.debug("Initializing JMX thread deadlock detector");
        try {
            Class<?> deadlockFactoryClass = AGENT_CLASSLOADER.loadClass("com.datadog.profiling.controller.openjdk.events.DeadlockEventFactory");
            Method registerMethod = deadlockFactoryClass.getMethod("registerEvents", new Class[0]);
            registerMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError ignored) {
            log.debug("JMX deadlock detection not supported");
        }
        catch (Throwable ex) {
            log.error("Unable to initialize JMX thread deadlock detector", ex);
        }
    }

    private static synchronized void registerSmapEntryEvent() {
        log.debug("Initializing smap entry scraping");
        try {
            Class<?> smapFactoryClass = AGENT_CLASSLOADER.loadClass("com.datadog.profiling.controller.openjdk.events.SmapEntryFactory");
            Method registerMethod = smapFactoryClass.getMethod("registerEvents", new Class[0]);
            registerMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError ignored) {
            log.debug("Smap entry scraping not supported");
        }
        catch (Throwable ex) {
            log.error("Unable to initialize smap entry scraping", ex);
        }
    }

    private static synchronized void initializeJmxSystemAccessProvider(ClassLoader classLoader) {
        if (log.isDebugEnabled()) {
            log.debug("Initializing JMX system access provider for {}", (Object)classLoader);
        }
        try {
            Class<?> tracerInstallerClass = classLoader.loadClass("datadog.trace.agent.core.util.SystemAccess");
            Method enableJmxMethod = tracerInstallerClass.getMethod("enableJmx", new Class[0]);
            enableJmxMethod.invoke(null, new Object[0]);
        }
        catch (Throwable ex) {
            log.error("Throwable thrown while initializing JMX system access provider", ex);
        }
    }

    private static synchronized void startJmxFetch() {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(AGENT_CLASSLOADER);
            Class<?> jmxFetchAgentClass = AGENT_CLASSLOADER.loadClass("datadog.trace.agent.jmxfetch.JMXFetch");
            Method jmxFetchInstallerMethod = jmxFetchAgentClass.getMethod("run", StatsDClientManager.class);
            jmxFetchInstallerMethod.invoke(null, Agent.statsDClientManager());
        }
        catch (Throwable ex) {
            log.error("Throwable thrown while starting JmxFetch", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextLoader);
        }
    }

    private static StatsDClientManager statsDClientManager() throws Exception {
        Class<?> statsdClientManagerClass = AGENT_CLASSLOADER.loadClass("datadog.communication.monitor.DDAgentStatsDClientManager");
        Method statsDClientManagerMethod = statsdClientManagerClass.getMethod("statsDClientManager", new Class[0]);
        return (StatsDClientManager)statsDClientManagerMethod.invoke(null, new Object[0]);
    }

    private static void maybeStartAppSec(Class<?> scoClass, Object o) {
        if (!(appSecEnabled || remoteConfigEnabled && !appSecFullyDisabled)) {
            return;
        }
        StaticEventLogger.begin("AppSec");
        try {
            SubscriptionService ss = AgentTracer.get().getSubscriptionService(RequestContextSlot.APPSEC);
            Agent.startAppSec(ss, scoClass, o);
        }
        catch (Exception e) {
            log.error("Error starting AppSec System", e);
        }
        StaticEventLogger.end("AppSec");
    }

    private static void startAppSec(SubscriptionService ss, Class<?> scoClass, Object sco) {
        try {
            Class<?> appSecSysClass = AGENT_CLASSLOADER.loadClass("com.datadog.appsec.AppSecSystem");
            Method appSecInstallerMethod = appSecSysClass.getMethod("start", SubscriptionService.class, scoClass);
            appSecInstallerMethod.invoke(null, ss, sco);
        }
        catch (Throwable ex) {
            log.warn("Not starting AppSec subsystem: {}", (Object)ex.getMessage());
        }
    }

    private static boolean isSupportedAppSecArch() {
        String arch = System.getProperty("os.arch");
        if (Platform.isWindows()) {
            return "amd64".equals(arch) || "x86_64".equals(arch);
        }
        if (Platform.isMac()) {
            return "amd64".equals(arch) || "x86_64".equals(arch) || "aarch64".equals(arch);
        }
        if (Platform.isLinux()) {
            return "amd64".equals(arch) || "x86_64".equals(arch) || "aarch64".equals(arch);
        }
        return true;
    }

    private static void maybeStartIast(Class<?> scoClass, Object o) {
        if (iastEnabled || !iastFullyDisabled) {
            StaticEventLogger.begin("IAST");
            try {
                SubscriptionService ss = AgentTracer.get().getSubscriptionService(RequestContextSlot.IAST);
                Agent.startIast(ss, scoClass, o);
            }
            catch (Exception e) {
                log.error("Error starting IAST subsystem", e);
            }
            StaticEventLogger.end("IAST");
        }
    }

    private static void startIast(SubscriptionService ss, Class<?> scoClass, Object sco) {
        try {
            Class<?> appSecSysClass = AGENT_CLASSLOADER.loadClass("com.datadog.iast.IastSystem");
            Method iastInstallerMethod = appSecSysClass.getMethod("start", SubscriptionService.class);
            iastInstallerMethod.invoke(null, ss);
        }
        catch (Throwable e) {
            log.warn("Not starting IAST subsystem", e);
        }
    }

    private static void maybeStartCiVisibility(Instrumentation inst, Class<?> scoClass, Object sco) {
        if (ciVisibilityEnabled) {
            StaticEventLogger.begin("CI Visibility");
            try {
                Class<?> ciVisibilitySysClass = AGENT_CLASSLOADER.loadClass("datadog.trace.civisibility.CiVisibilitySystem");
                Method ciVisibilityInstallerMethod = ciVisibilitySysClass.getMethod("start", Instrumentation.class, scoClass);
                ciVisibilityInstallerMethod.invoke(null, inst, sco);
            }
            catch (Throwable e) {
                log.warn("Not starting CI Visibility subsystem", e);
            }
            StaticEventLogger.end("CI Visibility");
        }
    }

    private static void maybeStartLogsIntake(Class<?> scoClass, Object sco) {
        if (agentlessLogSubmissionEnabled) {
            StaticEventLogger.begin("Logs Intake");
            try {
                Class<?> logsIntakeSystemClass = AGENT_CLASSLOADER.loadClass("datadog.trace.logging.intake.LogsIntakeSystem");
                Method logsIntakeInstallerMethod = logsIntakeSystemClass.getMethod("start", scoClass);
                logsIntakeInstallerMethod.invoke(null, sco);
            }
            catch (Throwable e) {
                log.warn("Not starting Logs Intake subsystem", e);
            }
            StaticEventLogger.end("Logs Intake");
        }
    }

    private static void shutdownLogsIntake() {
        if (AGENT_CLASSLOADER == null) {
            return;
        }
        try {
            Thread.currentThread().setContextClassLoader(AGENT_CLASSLOADER);
            Class<?> logsIntakeSystemClass = AGENT_CLASSLOADER.loadClass("datadog.trace.logging.intake.LogsIntakeSystem");
            Method shutdownMethod = logsIntakeSystemClass.getMethod("shutdown", new Class[0]);
            shutdownMethod.invoke(null, new Object[0]);
        }
        catch (Throwable ex) {
            log.error("Throwable thrown while shutting down logs intake", ex);
        }
    }

    private static void startTelemetry(Instrumentation inst, Class<?> scoClass, Object sco) {
        StaticEventLogger.begin("Telemetry");
        try {
            Class<?> telemetrySystem = AGENT_CLASSLOADER.loadClass("datadog.telemetry.TelemetrySystem");
            Method startTelemetry = telemetrySystem.getMethod("startTelemetry", Instrumentation.class, scoClass);
            startTelemetry.invoke(null, inst, sco);
        }
        catch (Throwable ex) {
            log.warn("Unable start telemetry", ex);
        }
        StaticEventLogger.end("Telemetry");
    }

    private static void stopTelemetry() {
        if (AGENT_CLASSLOADER == null) {
            return;
        }
        try {
            Class<?> telemetrySystem = AGENT_CLASSLOADER.loadClass("datadog.telemetry.TelemetrySystem");
            Method stopTelemetry = telemetrySystem.getMethod("stop", new Class[0]);
            stopTelemetry.invoke(null, new Object[0]);
        }
        catch (Throwable ex) {
            log.error("Error encountered while stopping telemetry", ex);
        }
    }

    private static void initializeErrorTracking() {
        if (Platform.isJ9()) {
            return;
        }
        try {
            Class<?> clz = AGENT_CLASSLOADER.loadClass("com.datadog.crashtracking.ScriptInitializer");
            clz.getMethod("initialize", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            log.debug("Unable to initialize crash uploader", t);
        }
    }

    private static void startCwsAgent() {
        if (AGENT_CLASSLOADER.getResource("cws-tls.version") == null) {
            log.warn("CWS support not included in this build of `dd-java-agent`");
            return;
        }
        log.debug("Scheduling scope event factory registration");
        WithGlobalTracer.registerOrExecute(new WithGlobalTracer.Callback(){

            @Override
            public void withTracer(AgentTracer.TracerAPI tracer) {
                log.debug("Registering CWS scope tracker");
                try {
                    ScopeListener scopeListener = (ScopeListener)AGENT_CLASSLOADER.loadClass("datadog.cws.tls.TlsScopeListener").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    tracer.addScopeListener(scopeListener);
                    log.debug("Scope event factory {} has been registered", (Object)scopeListener);
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        e = e.getCause();
                    }
                    log.debug("CWS is not available. {}", (Object)e.getMessage());
                }
            }
        });
    }

    private static ProfilingContextIntegration createProfilingContextIntegration() {
        if (Config.get().isProfilingEnabled()) {
            if (Config.get().isDatadogProfilerEnabled() && !Platform.isWindows()) {
                try {
                    return (ProfilingContextIntegration)AGENT_CLASSLOADER.loadClass("com.datadog.profiling.ddprof.DatadogProfilingIntegration").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    log.debug("ddprof-based profiling context labeling not available. {}", (Object)t.getMessage());
                }
            }
            if (Config.get().isProfilingTimelineEventsEnabled()) {
                try {
                    return (ProfilingContextIntegration)AGENT_CLASSLOADER.loadClass("com.datadog.profiling.controller.openjdk.JFREventContextIntegration").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    log.debug("JFR event-based profiling context labeling not available. {}", (Object)t.getMessage());
                }
            }
        }
        return ProfilingContextIntegration.NoOp.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startProfilingAgent(boolean isStartingFirst, Instrumentation inst) {
        StaticEventLogger.begin("ProfilingAgent");
        if (Agent.isAwsLambdaRuntime()) {
            log.info("Profiling not supported in AWS Lambda runtimes");
            return;
        }
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(AGENT_CLASSLOADER);
            Class<?> profilingAgentClass = AGENT_CLASSLOADER.loadClass("com.datadog.profiling.agent.ProfilingAgent");
            Method profilingInstallerMethod = profilingAgentClass.getMethod("run", Boolean.TYPE, ClassLoader.class, Instrumentation.class);
            profilingInstallerMethod.invoke(null, isStartingFirst, AGENT_CLASSLOADER, inst);
            if (!isStartingFirst) {
                log.debug("Scheduling scope event factory registration");
                WithGlobalTracer.registerOrExecute(new WithGlobalTracer.Callback(){

                    @Override
                    public void withTracer(AgentTracer.TracerAPI tracer) {
                        log.debug("Initializing profiler tracer integrations");
                        tracer.getProfilingContext().onStart();
                    }
                });
            }
        }
        catch (Throwable ex) {
            log.error("Throwable thrown while starting profiling agent", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextLoader);
        }
        StaticEventLogger.end("ProfilingAgent");
    }

    private static boolean isAwsLambdaRuntime() {
        String val = System.getenv("AWS_LAMBDA_FUNCTION_NAME");
        return val != null && !val.isEmpty();
    }

    private static ScopeListener createScopeListener(String className) throws Throwable {
        return (ScopeListener)AGENT_CLASSLOADER.loadClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdownProfilingAgent(boolean sync) {
        if (AGENT_CLASSLOADER == null) {
            return;
        }
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(AGENT_CLASSLOADER);
            Class<?> profilingAgentClass = AGENT_CLASSLOADER.loadClass("com.datadog.profiling.agent.ProfilingAgent");
            Method profilingInstallerMethod = profilingAgentClass.getMethod("shutdown", Boolean.TYPE);
            profilingInstallerMethod.invoke(null, sync);
        }
        catch (Throwable ex) {
            log.error("Throwable thrown while shutting down profiling agent", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextLoader);
        }
    }

    private static void maybeStartDebugger(Instrumentation inst, Class<?> scoClass, Object sco) {
        if (!debuggerEnabled && !exceptionDebuggingEnabled) {
            return;
        }
        if (!remoteConfigEnabled) {
            log.warn("Cannot enable Dynamic Instrumentation because Remote Configuration is not enabled");
            return;
        }
        Agent.startDebuggerAgent(inst, scoClass, sco);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void startDebuggerAgent(Instrumentation inst, Class<?> scoClass, Object sco) {
        StaticEventLogger.begin("Debugger");
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(AGENT_CLASSLOADER);
            Class<?> debuggerAgentClass = AGENT_CLASSLOADER.loadClass("com.datadog.debugger.agent.DebuggerAgent");
            Method debuggerInstallerMethod = debuggerAgentClass.getMethod("run", Instrumentation.class, scoClass);
            debuggerInstallerMethod.invoke(null, inst, sco);
        }
        catch (Throwable ex) {
            log.error("Throwable thrown while starting debugger agent", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextLoader);
        }
        StaticEventLogger.end("Debugger");
    }

    private static void configureLogger() {
        String logLevel;
        Agent.setSystemPropertyDefault(SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY, "true");
        Agent.setSystemPropertyDefault(SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY, SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT);
        if (Agent.isDebugMode()) {
            logLevel = "DEBUG";
        } else {
            logLevel = Agent.ddGetProperty("dd.log.level");
            if (null == logLevel) {
                logLevel = System.getenv("OTEL_LOG_LEVEL");
            }
        }
        if (null == logLevel && !Agent.isFeatureEnabled(AgentFeature.STARTUP_LOGS)) {
            logLevel = "WARN";
        }
        if (null != logLevel) {
            Agent.setSystemPropertyDefault(SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY, logLevel);
        }
    }

    private static void setSystemPropertyDefault(String property, String value) {
        if (System.getProperty(property) == null && Agent.ddGetEnv(property) == null) {
            System.setProperty(property, value);
        }
    }

    private static ClassLoader getPlatformClassLoader() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
        return (ClassLoader)method.invoke(null, new Object[0]);
    }

    private static boolean isDebugMode() {
        String tracerDebugLevelSysprop = "dd.trace.debug";
        String tracerDebugLevelProp = System.getProperty("dd.trace.debug");
        if (tracerDebugLevelProp != null) {
            return Boolean.parseBoolean(tracerDebugLevelProp);
        }
        String tracerDebugLevelEnv = Agent.ddGetEnv("dd.trace.debug");
        if (tracerDebugLevelEnv != null) {
            return Boolean.parseBoolean(tracerDebugLevelEnv);
        }
        return false;
    }

    private static boolean isFeatureEnabled(AgentFeature feature) {
        String featureEnabledSysprop = feature.getSystemProp();
        String featureEnabled = System.getProperty(featureEnabledSysprop);
        if (featureEnabled == null) {
            featureEnabled = Agent.ddGetEnv(featureEnabledSysprop);
        }
        if (feature.isEnabledByDefault()) {
            return !"false".equalsIgnoreCase(featureEnabled) && !"0".equals(featureEnabled);
        }
        if (feature == AgentFeature.PROFILING) {
            return ProfilingEnablement.of(featureEnabled).isActive();
        }
        return Boolean.parseBoolean(featureEnabled) || "1".equals(featureEnabled);
    }

    private static boolean isFullyDisabled(AgentFeature feature) {
        String featureEnabledSysprop = feature.systemProp;
        String settingValue = Agent.getNullIfEmpty(System.getProperty(featureEnabledSysprop));
        if (settingValue == null) {
            settingValue = Agent.getNullIfEmpty(Agent.ddGetEnv(featureEnabledSysprop));
            settingValue = settingValue != null && settingValue.isEmpty() ? null : settingValue;
        }
        return settingValue != null && !settingValue.equalsIgnoreCase("true") && !settingValue.equalsIgnoreCase("1") && !settingValue.equalsIgnoreCase("inactive");
    }

    private static boolean isIastFullyDisabled(boolean isAppSecEnabled) {
        if (Agent.isFullyDisabled(AgentFeature.IAST)) {
            return true;
        }
        return !isAppSecEnabled;
    }

    private static String getNullIfEmpty(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value;
    }

    private static int getJmxStartDelay() {
        String startDelay = Agent.ddGetProperty("dd.dogstatsd.start-delay");
        if (startDelay == null) {
            startDelay = Agent.ddGetProperty("dd.jmxfetch.start-delay");
        }
        if (startDelay != null) {
            try {
                return Integer.parseInt(startDelay);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 15;
    }

    private static boolean isAppUsingCustomLogManager(EnumSet<Library> libraries) {
        String tracerCustomLogManSysprop = "dd.app.customlogmanager";
        String customLogManagerProp = System.getProperty("dd.app.customlogmanager");
        String customLogManagerEnv = Agent.ddGetEnv("dd.app.customlogmanager");
        if (customLogManagerProp != null || customLogManagerEnv != null) {
            log.debug("Prop - customlogmanager: {}", (Object)customLogManagerProp);
            log.debug("Env - customlogmanager: {}", (Object)customLogManagerEnv);
            return Boolean.parseBoolean(customLogManagerProp) || Boolean.parseBoolean(customLogManagerEnv);
        }
        if (libraries.contains((Object)Library.WILDFLY)) {
            return true;
        }
        String logManagerProp = System.getProperty("java.util.logging.manager");
        if (logManagerProp != null) {
            boolean onSysClasspath = ClassLoader.getSystemResource(Strings.getResourceName(logManagerProp)) != null;
            log.debug("Prop - logging.manager: {}", (Object)logManagerProp);
            log.debug("logging.manager on system classpath: {}", (Object)onSysClasspath);
            return !onSysClasspath;
        }
        return false;
    }

    private static boolean isAppUsingCustomJMXBuilder(EnumSet<Library> libraries) {
        String tracerCustomJMXBuilderSysprop = "dd.app.customjmxbuilder";
        String customJMXBuilderProp = System.getProperty("dd.app.customjmxbuilder");
        String customJMXBuilderEnv = Agent.ddGetEnv("dd.app.customjmxbuilder");
        if (customJMXBuilderProp != null || customJMXBuilderEnv != null) {
            log.debug("Prop - customjmxbuilder: {}", (Object)customJMXBuilderProp);
            log.debug("Env - customjmxbuilder: {}", (Object)customJMXBuilderEnv);
            return Boolean.parseBoolean(customJMXBuilderProp) || Boolean.parseBoolean(customJMXBuilderEnv);
        }
        if (libraries.contains((Object)Library.WILDFLY)) {
            return true;
        }
        String jmxBuilderProp = System.getProperty("javax.management.builder.initial");
        if (jmxBuilderProp != null) {
            boolean onSysClasspath = ClassLoader.getSystemResource(Strings.getResourceName(jmxBuilderProp)) != null;
            log.debug("Prop - javax.management.builder.initial: {}", (Object)jmxBuilderProp);
            log.debug("javax.management.builder.initial on system classpath: {}", (Object)onSysClasspath);
            return !onSysClasspath;
        }
        return false;
    }

    private static String ddGetProperty(String sysProp) {
        String value = System.getProperty(sysProp);
        if (null == value) {
            value = Agent.ddGetEnv(sysProp);
        }
        return value;
    }

    private static String ddGetEnv(String sysProp) {
        return System.getenv(Strings.toEnvVar(sysProp));
    }

    private static boolean okHttpMayIndirectlyLoadJUL() {
        if ("IBM Corporation".equals(Platform.getRuntimeVendor())) {
            return true;
        }
        if (Platform.isJavaVersionAtLeast(9)) {
            return false;
        }
        return Agent.isJFRSupported();
    }

    private static boolean isJFRSupported() {
        return BootstrapProxy.INSTANCE.getResource("jdk/jfr/Recording.class") != null;
    }

    private static boolean isDataJobsSupported(String javaCommand, String dataJobsCommandPattern) {
        if (null == javaCommand || null == dataJobsCommandPattern) {
            return true;
        }
        try {
            return javaCommand.matches(dataJobsCommandPattern);
        }
        catch (PatternSyntaxException e) {
            log.warn("Invalid data jobs command pattern {}. The value must be a valid regex", (Object)dataJobsCommandPattern);
            return true;
        }
    }

    static {
        Agent.configureLogger();
        log = LoggerFactory.getLogger(Agent.class);
        jmxStarting = new AtomicBoolean();
        AGENT_CLASSLOADER = null;
        PROFILER_INIT_AFTER_JMX = null;
        jmxFetchEnabled = true;
        profilingEnabled = false;
        remoteConfigEnabled = true;
        iastEnabled = false;
        cwsEnabled = false;
        ciVisibilityEnabled = false;
        usmEnabled = false;
        telemetryEnabled = true;
        debuggerEnabled = false;
        exceptionDebuggingEnabled = false;
        agentlessLogSubmissionEnabled = false;
    }

    static final class JmxStartTask
    implements Runnable {
        JmxStartTask() {
        }

        @Override
        public void run() {
            Agent.startJmx();
        }
    }

    protected static class StartProfilingAgentCallback
    extends ClassLoadCallBack {
        private final Instrumentation inst;

        protected StartProfilingAgentCallback(Instrumentation inst) {
            this.inst = inst;
        }

        @Override
        public AgentThreadFactory.AgentThread agentThread() {
            return AgentThreadFactory.AgentThread.PROFILER_STARTUP;
        }

        @Override
        public void execute() {
            Agent.startProfilingAgent(false, this.inst);
            InstrumentationBasedProfiling.enableInstrumentationBasedProfiling();
        }
    }

    protected static class InstallDatadogTracerCallback
    extends ClassLoadCallBack {
        private final InitializationTelemetry initTelemetry;
        private final Instrumentation instrumentation;

        public InstallDatadogTracerCallback(InitializationTelemetry initTelemetry, Instrumentation instrumentation) {
            this.initTelemetry = initTelemetry;
            this.instrumentation = instrumentation;
        }

        @Override
        public AgentThreadFactory.AgentThread agentThread() {
            return AgentThreadFactory.AgentThread.TRACE_STARTUP;
        }

        @Override
        public void execute() {
            Object sco;
            Class<?> scoClass;
            try {
                scoClass = AGENT_CLASSLOADER.loadClass("datadog.communication.ddagent.SharedCommunicationObjects");
                sco = scoClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new UndeclaredThrowableException(e);
            }
            Agent.installDatadogTracer(this.initTelemetry, scoClass, sco);
            Agent.maybeStartAppSec(scoClass, sco);
            Agent.maybeStartIast(scoClass, sco);
            Agent.maybeStartCiVisibility(this.instrumentation, scoClass, sco);
            Agent.maybeStartLogsIntake(scoClass, sco);
            Agent.maybeStartDebugger(this.instrumentation, scoClass, sco);
            Agent.maybeStartRemoteConfig(scoClass, sco);
            if (telemetryEnabled) {
                Agent.startTelemetry(this.instrumentation, scoClass, sco);
            }
        }
    }

    protected static class StartJmxCallback
    extends ClassLoadCallBack {
        private final int jmxStartDelay;

        StartJmxCallback(int jmxStartDelay) {
            this.jmxStartDelay = jmxStartDelay;
        }

        @Override
        public AgentThreadFactory.AgentThread agentThread() {
            return AgentThreadFactory.AgentThread.JMX_STARTUP;
        }

        @Override
        public void execute() {
            Agent.scheduleJmxStart(this.jmxStartDelay);
        }
    }

    protected static abstract class ClassLoadCallBack
    implements Runnable {
        protected ClassLoadCallBack() {
        }

        @Override
        public void run() {
            Thread thread = AgentThreadFactory.newAgentThread(this.agentThread(), new Runnable(){

                @Override
                public void run() {
                    try {
                        this.execute();
                    }
                    catch (Exception e) {
                        log.error("Failed to run {}", (Object)this.agentThread(), (Object)e);
                    }
                }
            });
            thread.start();
        }

        public abstract AgentThreadFactory.AgentThread agentThread();

        public abstract void execute();
    }

    private static enum AgentFeature {
        TRACING(Strings.propertyNameToSystemPropertyName("trace.enabled"), true),
        JMXFETCH(Strings.propertyNameToSystemPropertyName("jmxfetch.enabled"), true),
        STARTUP_LOGS(Strings.propertyNameToSystemPropertyName("trace.startup.logs"), true),
        PROFILING(Strings.propertyNameToSystemPropertyName("profiling.enabled"), false),
        APPSEC(Strings.propertyNameToSystemPropertyName("appsec.enabled"), false),
        IAST(Strings.propertyNameToSystemPropertyName("iast.enabled"), false),
        REMOTE_CONFIG(Strings.propertyNameToSystemPropertyName("remote_configuration.enabled"), true),
        DEPRECATED_REMOTE_CONFIG(Strings.propertyNameToSystemPropertyName("remote_config.enabled"), true),
        CWS(Strings.propertyNameToSystemPropertyName("cws.enabled"), false),
        CIVISIBILITY(Strings.propertyNameToSystemPropertyName("civisibility.enabled"), false),
        CIVISIBILITY_AGENTLESS(Strings.propertyNameToSystemPropertyName("civisibility.agentless.enabled"), false),
        USM(Strings.propertyNameToSystemPropertyName("usm.enabled"), false),
        TELEMETRY(Strings.propertyNameToSystemPropertyName("instrumentation.telemetry.enabled"), true),
        DEBUGGER(Strings.propertyNameToSystemPropertyName("dynamic.instrumentation.enabled"), false),
        EXCEPTION_DEBUGGING(Strings.propertyNameToSystemPropertyName("exception.replay.enabled"), false),
        DATA_JOBS(Strings.propertyNameToSystemPropertyName("data.jobs.enabled"), false),
        AGENTLESS_LOG_SUBMISSION(Strings.propertyNameToSystemPropertyName("agentless.log.submission.enabled"), false);

        private final String systemProp;
        private final boolean enabledByDefault;

        private AgentFeature(String systemProp, boolean enabledByDefault) {
            this.systemProp = systemProp;
            this.enabledByDefault = enabledByDefault;
        }

        public String getSystemProp() {
            return this.systemProp;
        }

        public boolean isEnabledByDefault() {
            return this.enabledByDefault;
        }
    }
}

