/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.debugger;

import datadog.trace.bootstrap.debugger.CapturedStackFrame;
import datadog.trace.bootstrap.debugger.DebuggerContext;
import datadog.trace.bootstrap.debugger.EvaluationError;
import datadog.trace.bootstrap.debugger.Limits;
import datadog.trace.bootstrap.debugger.MethodLocation;
import datadog.trace.bootstrap.debugger.ProbeImplementation;
import datadog.trace.bootstrap.debugger.el.ReflectiveFieldValueResolver;
import datadog.trace.bootstrap.debugger.el.ValueReferenceResolver;
import datadog.trace.bootstrap.debugger.el.ValueReferences;
import datadog.trace.bootstrap.debugger.el.Values;
import datadog.trace.bootstrap.debugger.util.Redaction;
import datadog.trace.bootstrap.debugger.util.TimeoutChecker;
import datadog.trace.bootstrap.debugger.util.WellKnownClasses;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class CapturedContext
implements ValueReferenceResolver {
    public static final CapturedContext EMPTY_CONTEXT = new CapturedContext(null);
    public static final CapturedContext EMPTY_CAPTURING_CONTEXT = new CapturedContext(ProbeImplementation.UNKNOWN);
    private final transient Map<String, Object> extensions = new HashMap<String, Object>();
    private Map<String, CapturedValue> arguments;
    private Map<String, CapturedValue> locals;
    private CapturedThrowable throwable;
    private Map<String, CapturedValue> staticFields;
    private Limits limits = Limits.DEFAULT;
    private String thisClassName;
    private String traceId;
    private String spanId;
    private long duration;
    private final Map<String, Status> statusByProbeId = new LinkedHashMap<String, Status>();
    private Map<String, CapturedValue> watches;

    public CapturedContext() {
    }

    public CapturedContext(CapturedValue[] arguments, CapturedValue[] locals, CapturedValue returnValue, CapturedThrowable throwable) {
        this.addArguments(arguments);
        this.addLocals(locals);
        this.addReturn(returnValue);
        this.throwable = throwable;
    }

    private CapturedContext(CapturedContext other, Map<String, Object> extensions) {
        this.arguments = other.arguments;
        this.locals = other.getLocals();
        this.throwable = other.throwable;
        this.extensions.putAll(other.extensions);
        this.extensions.putAll(extensions);
    }

    private CapturedContext(ProbeImplementation probeImplementation) {
        if (probeImplementation != null) {
            this.statusByProbeId.put(probeImplementation.getProbeId().getEncodedId(), probeImplementation.createStatus());
        }
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean isCapturing() {
        boolean result = false;
        for (Status status : this.statusByProbeId.values()) {
            result |= status.isCapturing();
        }
        result = result && DebuggerContext.checkAndSetInProbe();
        return result;
    }

    @Override
    public Object lookup(String name) {
        Object target;
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("empty name for lookup operation");
        }
        if (name.startsWith(ValueReferences.SYNTHETIC_PREFIX)) {
            String rawName = name.substring(ValueReferences.SYNTHETIC_PREFIX.length());
            target = this.tryRetrieveSynthetic(rawName);
            this.checkUndefined(target, rawName, "Cannot find synthetic var: ");
        } else {
            target = this.tryRetrieve(name);
            this.checkUndefined(target, name, "Cannot find symbol: ");
        }
        return target instanceof CapturedValue ? ((CapturedValue)target).getValue() : target;
    }

    private void checkUndefined(Object target, String name, String msg) {
        if (target == Values.UNDEFINED_OBJECT) {
            String errorMsg = msg + name;
            throw new RuntimeException(errorMsg);
        }
    }

    @Override
    public Object getMember(Object target, String memberName) {
        if (target == Values.UNDEFINED_OBJECT) {
            return target;
        }
        if (Redaction.isRedactedKeyword(memberName)) {
            return Redaction.REDACTED_VALUE;
        }
        if (target instanceof CapturedValue) {
            CapturedValue capturedTarget;
            Map fields = ((CapturedValue)target).fields;
            target = fields.containsKey(memberName) ? fields.get(memberName) : ((target = (capturedTarget = (CapturedValue)target).getValue()) != null ? ReflectiveFieldValueResolver.resolve(target, target.getClass(), memberName) : Values.UNDEFINED_OBJECT);
        } else {
            CapturedValue specialField;
            Function<Object, CapturedValue> specialFieldAccess;
            Map<String, Function<Object, CapturedValue>> specialTypeAccess = WellKnownClasses.getSpecialTypeAccess(target);
            if (specialTypeAccess != null && (specialFieldAccess = specialTypeAccess.get(memberName)) != null && (specialField = specialFieldAccess.apply(target)) != null && specialField.getName().equals(memberName)) {
                return specialField.getValue();
            }
            target = ReflectiveFieldValueResolver.resolve(target, target.getClass(), memberName);
        }
        this.checkUndefined(target, memberName, "Cannot dereference field: ");
        return target;
    }

    private Object tryRetrieveSynthetic(String name) {
        if (this.extensions == null || this.extensions.isEmpty()) {
            return Values.UNDEFINED_OBJECT;
        }
        return this.extensions.getOrDefault(name, Values.UNDEFINED_OBJECT);
    }

    private Object tryRetrieve(String name) {
        CapturedValue thisValue;
        Object result = null;
        if (this.arguments != null && !this.arguments.isEmpty()) {
            result = this.arguments.get(name);
        }
        if (result != null) {
            return result;
        }
        if (this.locals != null && !this.locals.isEmpty()) {
            result = this.locals.get(name);
        }
        if (result != null) {
            return result;
        }
        if (this.staticFields != null && !this.staticFields.isEmpty()) {
            result = this.staticFields.get(name);
        }
        if (this.arguments != null && (thisValue = this.arguments.get("this")) != null && (result = this.getMember(thisValue.getValue(), name)) != Values.UNDEFINED_OBJECT) {
            return result;
        }
        return result != null ? result : Values.UNDEFINED_OBJECT;
    }

    @Override
    public ValueReferenceResolver withExtensions(Map<String, Object> extensions) {
        return new CapturedContext(this, extensions);
    }

    public void removeExtension(String name) {
        this.extensions.remove(name);
    }

    private void addExtension(String name, Object value) {
        this.extensions.put(name, value);
    }

    public void addArguments(CapturedValue[] values) {
        if (values == null) {
            return;
        }
        for (CapturedValue value : values) {
            this.putInArguments(value.name, value);
        }
    }

    public void addLocals(CapturedValue[] values) {
        if (values == null) {
            return;
        }
        for (CapturedValue value : values) {
            this.putInLocals(value.name, value);
        }
    }

    public void addReturn(CapturedValue retValue) {
        if (retValue == null) {
            return;
        }
        this.putInLocals(ValueReferences.RETURN_REF, retValue);
        this.extensions.put(ValueReferences.RETURN_EXTENSION_NAME, retValue);
    }

    public void addThrowable(Throwable t) {
        this.addThrowable(new CapturedThrowable(t));
        this.putInLocals(ValueReferences.EXCEPTION_REF, CapturedValue.of(t.getClass().getTypeName(), t));
        this.extensions.put(ValueReferences.EXCEPTION_EXTENSION_NAME, t);
    }

    public void addThrowable(CapturedThrowable capturedThrowable) {
        this.throwable = capturedThrowable;
    }

    public void addStaticFields(CapturedValue[] values) {
        if (values == null) {
            return;
        }
        for (CapturedValue value : values) {
            this.putInStaticFields(value.name, value);
        }
    }

    public void addTraceId(CapturedValue capturedValue) {
        this.traceId = this.extractStringId(capturedValue);
    }

    public void addSpanId(CapturedValue capturedValue) {
        this.spanId = this.extractStringId(capturedValue);
    }

    private String extractStringId(CapturedValue capturedValue) {
        Object value = capturedValue.getValue();
        return value instanceof String ? (String)value : null;
    }

    public void setLimits(int maxReferenceDepth, int maxCollectionSize, int maxLength, int maxFieldCount) {
        this.limits = new Limits(maxReferenceDepth, maxCollectionSize, maxLength, maxFieldCount);
    }

    public Map<String, CapturedValue> getArguments() {
        return this.arguments;
    }

    public Map<String, CapturedValue> getLocals() {
        return this.locals;
    }

    public CapturedThrowable getCapturedThrowable() {
        return this.throwable;
    }

    public Map<String, CapturedValue> getStaticFields() {
        return this.staticFields;
    }

    public Map<String, CapturedValue> getWatches() {
        return this.watches;
    }

    public Limits getLimits() {
        return this.limits;
    }

    public String getThisClassName() {
        return this.thisClassName;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public void freeze(TimeoutChecker timeoutChecker) {
        if (this.watches != null) {
            this.watches.values().forEach(capturedValue -> capturedValue.freeze(timeoutChecker));
            return;
        }
        if (this.arguments != null) {
            this.arguments.values().forEach(capturedValue -> capturedValue.freeze(timeoutChecker));
        }
        if (this.locals != null) {
            this.locals.values().forEach(capturedValue -> capturedValue.freeze(timeoutChecker));
        }
        if (this.staticFields != null) {
            this.staticFields.values().forEach(capturedValue -> capturedValue.freeze(timeoutChecker));
        }
    }

    public Status evaluate(String encodedProbeId, ProbeImplementation probeImplementation, String thisClassName, long startTimestamp, MethodLocation methodLocation) {
        Status status = this.statusByProbeId.computeIfAbsent(encodedProbeId, key -> probeImplementation.createStatus());
        if (methodLocation == MethodLocation.EXIT) {
            this.duration = System.nanoTime() - startTimestamp;
            this.addExtension(ValueReferences.DURATION_EXTENSION_NAME, (double)this.duration / 1000000.0);
        }
        this.thisClassName = thisClassName;
        boolean shouldEvaluate = MethodLocation.isSame(methodLocation, probeImplementation.getEvaluateAt());
        if (shouldEvaluate) {
            probeImplementation.evaluate(this, status, methodLocation);
        }
        return status;
    }

    public Status getStatus(String encodedProbeId) {
        Status result = this.statusByProbeId.get(encodedProbeId);
        if (result == null && (result = this.statusByProbeId.get(ProbeImplementation.UNKNOWN.getProbeId().getEncodedId())) == null) {
            return Status.EMPTY_STATUS;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapturedContext context = (CapturedContext)o;
        return Objects.equals(this.arguments, context.arguments) && Objects.equals(this.locals, context.locals) && Objects.equals(this.staticFields, context.staticFields) && Objects.equals(this.throwable, context.throwable);
    }

    public int hashCode() {
        return Objects.hash(this.arguments, this.locals, this.throwable, this.staticFields);
    }

    public String toString() {
        return "CapturedContext{arguments=" + this.arguments + ", locals=" + this.locals + ", throwable=" + this.throwable + ", staticFields=" + this.staticFields + '}';
    }

    private void putInLocals(String name, CapturedValue value) {
        if (this.locals == null) {
            this.locals = new HashMap<String, CapturedValue>();
        }
        this.locals.put(name, value);
    }

    private void putInArguments(String name, CapturedValue value) {
        if (this.arguments == null) {
            this.arguments = new HashMap<String, CapturedValue>();
        }
        this.arguments.put(name, value);
    }

    private void putInStaticFields(String name, CapturedValue value) {
        if (this.staticFields == null) {
            this.staticFields = new HashMap<String, CapturedValue>();
        }
        this.staticFields.put(name, value);
    }

    public void addWatch(CapturedValue value) {
        if (this.watches == null) {
            this.watches = new HashMap<String, CapturedValue>();
        }
        this.watches.put(value.name, value);
    }

    public static class CapturedThrowable {
        private final String type;
        private final String message;
        private final transient WeakReference<Throwable> throwable;
        private final List<CapturedStackFrame> stacktrace;

        public CapturedThrowable(Throwable throwable) {
            this(throwable.getClass().getTypeName(), throwable.getLocalizedMessage(), CapturedThrowable.captureFrames(throwable.getStackTrace()), throwable);
        }

        public CapturedThrowable(String type, String message, List<CapturedStackFrame> stacktrace, Throwable t) {
            this.type = type;
            this.message = message;
            this.stacktrace = new ArrayList<CapturedStackFrame>(stacktrace);
            this.throwable = new WeakReference<Throwable>(t);
        }

        public String getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }

        public List<CapturedStackFrame> getStacktrace() {
            return this.stacktrace;
        }

        public Throwable getThrowable() {
            return (Throwable)this.throwable.get();
        }

        private static List<CapturedStackFrame> captureFrames(StackTraceElement[] stackTrace) {
            if (stackTrace == null) {
                return Collections.emptyList();
            }
            ArrayList<CapturedStackFrame> capturedFrames = new ArrayList<CapturedStackFrame>(stackTrace.length);
            for (StackTraceElement element : stackTrace) {
                capturedFrames.add(CapturedStackFrame.from(element));
            }
            return capturedFrames;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CapturedThrowable that = (CapturedThrowable)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.message, that.message) && Objects.equals(this.stacktrace, that.stacktrace);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.message, this.stacktrace);
        }

        public String toString() {
            return "CapturedThrowable{type='" + this.type + '\'' + ", message='" + this.message + '\'' + ", stacktrace=" + this.stacktrace + '}';
        }
    }

    public static class CapturedValue {
        public static final CapturedValue UNDEFINED = CapturedValue.of(null, Values.UNDEFINED_OBJECT);
        private String name;
        private final String declaredType;
        private final String type;
        private Object value;
        private String strValue;
        private final Map<String, CapturedValue> fields;
        private final Limits limits;
        private TimeoutChecker timeoutChecker;
        private final String notCapturedReason;

        private CapturedValue(String name, String declaredType, Object value, Limits limits, Map<String, CapturedValue> fields, String notCapturedReason) {
            this.name = name;
            this.declaredType = declaredType;
            this.type = value != null && !CapturedValue.isPrimitive(declaredType) ? value.getClass().getTypeName() : declaredType;
            this.value = value;
            this.fields = fields == null ? Collections.emptyMap() : fields;
            this.limits = limits;
            this.notCapturedReason = notCapturedReason;
        }

        public boolean isResolved() {
            return true;
        }

        public String getName() {
            return this.name;
        }

        public String getDeclaredType() {
            return this.declaredType;
        }

        public String getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public String getStrValue() {
            return this.strValue;
        }

        public Map<String, CapturedValue> getFields() {
            return this.fields;
        }

        public Limits getLimits() {
            return this.limits;
        }

        public String getNotCapturedReason() {
            return this.notCapturedReason;
        }

        public void setName(String name) {
            this.name = name;
        }

        public static CapturedValue of(String declaredType, Object value) {
            return CapturedValue.build(null, declaredType, value, Limits.DEFAULT, null);
        }

        public static CapturedValue of(String name, String declaredType, Object value) {
            return CapturedValue.build(name, declaredType, value, Limits.DEFAULT, null);
        }

        public CapturedValue derive(String name, String type, Object value) {
            return CapturedValue.build(name, type, value, this.limits, null);
        }

        public static CapturedValue of(String name, String declaredType, Object value, int maxReferenceDepth, int maxCollectionSize, int maxLength, int maxFieldCount) {
            return CapturedValue.build(name, declaredType, value, new Limits(maxReferenceDepth, maxCollectionSize, maxLength, maxFieldCount), null);
        }

        public static CapturedValue redacted(String name, String type) {
            return CapturedValue.build(name, type, Redaction.REDACTED_VALUE, Limits.DEFAULT, null);
        }

        public static CapturedValue notCapturedReason(String name, String type, String reason) {
            return CapturedValue.build(name, type, null, Limits.DEFAULT, reason);
        }

        public static CapturedValue raw(String type, Object value, String notCapturedReason) {
            return new CapturedValue(null, type, value, Limits.DEFAULT, Collections.emptyMap(), notCapturedReason);
        }

        public static CapturedValue raw(String name, String type, Object value, Limits limits, Map<String, CapturedValue> fields, String notCapturedReason) {
            return new CapturedValue(name, type, value, limits, fields, notCapturedReason);
        }

        private static CapturedValue build(String name, String declaredType, Object value, Limits limits, String notCapturedReason) {
            CapturedValue val = new CapturedValue(name, declaredType, value, limits, Collections.emptyMap(), notCapturedReason);
            return val;
        }

        public void freeze(TimeoutChecker timeoutChecker) {
            if (this.strValue != null) {
                return;
            }
            this.timeoutChecker = timeoutChecker;
            this.strValue = DebuggerContext.serializeValue(this);
            if (this.strValue != null) {
                this.value = null;
            }
        }

        private static boolean isPrimitive(String type) {
            if (type == null) {
                return false;
            }
            switch (type) {
                case "byte": 
                case "short": 
                case "char": 
                case "int": 
                case "long": 
                case "boolean": 
                case "float": 
                case "double": {
                    return true;
                }
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CapturedValue that = (CapturedValue)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.declaredType, that.declaredType) && Objects.equals(this.value, that.value) && Objects.equals(this.fields, that.fields) && Objects.equals(this.notCapturedReason, that.notCapturedReason);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.declaredType, this.value, this.fields, this.notCapturedReason);
        }

        public String toString() {
            return "CapturedValue{name='" + this.name + '\'' + ", type='" + this.declaredType + '\'' + ", value='" + this.value + '\'' + ", fields=" + this.fields + ", notCapturedReason='" + this.notCapturedReason + '\'' + '}';
        }

        public TimeoutChecker getTimeoutChecker() {
            return this.timeoutChecker;
        }
    }

    public static class Status {
        public static final Status EMPTY_STATUS = new Status(ProbeImplementation.UNKNOWN);
        public static final Status EMPTY_CAPTURING_STATUS = new Status(ProbeImplementation.UNKNOWN){

            @Override
            public boolean isCapturing() {
                return true;
            }
        };
        private final List<EvaluationError> errors = new ArrayList<EvaluationError>();
        protected final ProbeImplementation probeImplementation;

        public Status(ProbeImplementation probeImplementation) {
            this.probeImplementation = probeImplementation;
        }

        public List<EvaluationError> getErrors() {
            return this.errors;
        }

        public void addError(EvaluationError evaluationError) {
            this.errors.add(evaluationError);
        }

        public boolean shouldFreezeContext() {
            return false;
        }

        public boolean isCapturing() {
            return false;
        }
    }
}

