/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.java.concurrent;

import datadog.trace.api.Platform;
import datadog.trace.api.profiling.QueueTiming;
import datadog.trace.api.profiling.Timer;
import datadog.trace.api.profiling.Timing;
import datadog.trace.api.sampling.PerRecordingRateLimiter;
import datadog.trace.bootstrap.ContextStore;
import datadog.trace.bootstrap.config.provider.ConfigProvider;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.java.concurrent.State;
import datadog.trace.bootstrap.instrumentation.jfr.InstrumentationBasedProfiling;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

public class QueueTimerHelper {
    public static <T> void startQueuingTimer(ContextStore<T, State> taskContextStore, Class<?> schedulerClass, T task) {
        State state = taskContextStore.get(task);
        QueueTimerHelper.startQueuingTimer(state, schedulerClass, task);
    }

    public static void startQueuingTimer(State state, Class<?> schedulerClass, Object task) {
        if (Platform.isNativeImage()) {
            return;
        }
        if (task != null && state != null && InstrumentationBasedProfiling.isJFRReady()) {
            QueueTiming timing = (QueueTiming)AgentTracer.get().getProfilingContext().start(Timer.TimerType.QUEUEING);
            timing.setTask(task);
            timing.setScheduler(schedulerClass);
            state.setTiming(timing);
        }
    }

    public static void stopQueuingTimer(Timing timing) {
        if (Platform.isNativeImage()) {
            return;
        }
        if (timing != null && timing.sample() && RateLimiterHolder.RATE_LIMITER.permit()) {
            timing.report();
        }
    }

    private static final class RateLimiterHolder {
        private static final PerRecordingRateLimiter RATE_LIMITER = new PerRecordingRateLimiter(Duration.of(500L, ChronoUnit.MILLIS), 10000, Duration.ofSeconds(ConfigProvider.getInstance().getInteger("profiling.upload.period", 60, new String[0])));

        private RateLimiterHolder() {
        }
    }
}

