/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.rpc;

import com.google.auto.value.AutoValue;
import datadog.trace.bootstrap.PatchLogger;
import datadog.trace.bootstrap.otel.api.common.Attributes;
import datadog.trace.bootstrap.otel.api.metrics.DoubleHistogram;
import datadog.trace.bootstrap.otel.api.metrics.DoubleHistogramBuilder;
import datadog.trace.bootstrap.otel.api.metrics.Meter;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.context.ContextKey;
import datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.rpc.AutoValue_RpcServerMetrics_State;
import datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.rpc.RpcMetricsAdvice;
import datadog.trace.bootstrap.otel.instrumentation.api.instrumenter.OperationListener;
import datadog.trace.bootstrap.otel.instrumentation.api.instrumenter.OperationMetrics;
import datadog.trace.bootstrap.otel.instrumentation.api.internal.OperationMetricsUtil;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class RpcServerMetrics
implements OperationListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<State> RPC_SERVER_REQUEST_METRICS_STATE = ContextKey.named("rpc-server-request-metrics-state");
    private static final PatchLogger logger = PatchLogger.getLogger(RpcServerMetrics.class.getName());
    private final DoubleHistogram serverDurationHistogram;

    private RpcServerMetrics(Meter meter) {
        DoubleHistogramBuilder durationBuilder = meter.histogramBuilder("rpc.server.duration").setDescription("The duration of an inbound RPC invocation").setUnit("ms");
        RpcMetricsAdvice.applyServerDurationAdvice(durationBuilder);
        this.serverDurationHistogram = durationBuilder.build();
    }

    public static OperationMetrics get() {
        return OperationMetricsUtil.create("rpc server", RpcServerMetrics::new);
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(RPC_SERVER_REQUEST_METRICS_STATE, new AutoValue_RpcServerMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        State state = context.get(RPC_SERVER_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record RPC request metrics.", context);
            return;
        }
        this.serverDurationHistogram.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_MS, state.startAttributes().toBuilder().putAll(endAttributes).build(), context);
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

