/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.context.propagation;

import datadog.trace.api.TracePropagationStyle;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.TagContext;
import datadog.trace.bootstrap.otel.api.trace.Span;
import datadog.trace.bootstrap.otel.api.trace.SpanContext;
import datadog.trace.bootstrap.otel.api.trace.TraceState;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.context.propagation.TextMapGetter;
import datadog.trace.bootstrap.otel.context.propagation.TextMapPropagator;
import datadog.trace.bootstrap.otel.context.propagation.TextMapSetter;
import datadog.trace.bootstrap.otel.shim.context.OtelContext;
import datadog.trace.bootstrap.otel.shim.context.propagation.TraceStateHelper;
import datadog.trace.bootstrap.otel.shim.trace.OtelExtractedContext;
import datadog.trace.bootstrap.otel.shim.trace.OtelSpan;
import datadog.trace.bootstrap.otel.shim.trace.OtelSpanContext;
import datadog.trace.util.PropagationUtils;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AgentTextMapPropagator
implements TextMapPropagator {
    @Override
    public Collection<String> fields() {
        return PropagationUtils.KNOWN_PROPAGATION_HEADERS;
    }

    @Override
    public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
        if (carrier == null) {
            return;
        }
        Span span = Span.fromContext(context);
        if (span.getSpanContext().isValid()) {
            AgentSpan.Context agentSpanContext = OtelExtractedContext.extract(context);
            AgentTracer.propagate().inject(agentSpanContext, carrier, setter::set);
        }
    }

    @Override
    public <C> Context extract(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
        if (carrier == null) {
            return context;
        }
        AgentSpan.Context.Extracted extracted = AgentTracer.propagate().extract(carrier, (carrier1, classifier) -> {
            for (String key : getter.keys(carrier1)) {
                classifier.accept(key, getter.get(carrier1, key));
            }
        });
        if (extracted == null) {
            return context;
        }
        TraceState traceState = AgentTextMapPropagator.extractTraceState(extracted, carrier, getter);
        SpanContext spanContext = OtelSpanContext.fromRemote(extracted, traceState);
        return new OtelContext(Span.wrap(spanContext), OtelSpan.invalid());
    }

    private static <C> TraceState extractTraceState(AgentSpan.Context.Extracted extracted, C carrier, TextMapGetter<C> getter) {
        String header;
        return extracted instanceof TagContext && TracePropagationStyle.TRACECONTEXT.equals((Object)((TagContext)extracted).getPropagationStyle()) && (header = getter.get(carrier, "tracestate")) != null ? TraceStateHelper.decodeHeader(header) : TraceState.getDefault();
    }
}

