/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.trace;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.SpanAttributes;
import datadog.trace.bootstrap.otel.api.common.AttributeKey;
import datadog.trace.bootstrap.otel.api.common.Attributes;
import datadog.trace.bootstrap.otel.api.trace.SpanKind;
import datadog.trace.bootstrap.otel.shim.trace.OtelSpanEvent;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

public final class OtelConventions {
    static final String SPAN_KIND_INTERNAL = "internal";
    static final String OPERATION_NAME_SPECIFIC_ATTRIBUTE = "operation.name";
    static final String ANALYTICS_EVENT_SPECIFIC_ATTRIBUTES = "analytics.event";
    static final String HTTP_RESPONSE_STATUS_CODE_ATTRIBUTE = "http.response.status_code";
    private static final Logger LOGGER = LoggerFactory.getLogger(OtelConventions.class);

    private OtelConventions() {
    }

    public static String toSpanKindTagValue(SpanKind spanKind) {
        switch (spanKind) {
            case CLIENT: {
                return "client";
            }
            case SERVER: {
                return "server";
            }
            case PRODUCER: {
                return "producer";
            }
            case CONSUMER: {
                return "consumer";
            }
            case INTERNAL: {
                return SPAN_KIND_INTERNAL;
            }
        }
        return spanKind.toString().toLowerCase(Locale.ROOT);
    }

    public static SpanKind toOtelSpanKind(String spanKind) {
        if (spanKind == null) {
            return SpanKind.INTERNAL;
        }
        switch (spanKind) {
            case "client": {
                return SpanKind.CLIENT;
            }
            case "server": {
                return SpanKind.SERVER;
            }
            case "producer": {
                return SpanKind.PRODUCER;
            }
            case "consumer": {
                return SpanKind.CONSUMER;
            }
        }
        return SpanKind.INTERNAL;
    }

    public static <T> boolean applyReservedAttribute(AgentSpan span, AttributeKey<T> key, T value) {
        String name = key.getKey();
        switch (key.getType()) {
            case STRING: {
                if (OPERATION_NAME_SPECIFIC_ATTRIBUTE.equals(name) && value instanceof String) {
                    span.setOperationName(((String)value).toLowerCase(Locale.ROOT));
                    return true;
                }
                if (ANALYTICS_EVENT_SPECIFIC_ATTRIBUTES.equals(name) && value instanceof String) {
                    span.setMetric((CharSequence)"_dd1.sr.eausr", Boolean.parseBoolean((String)value) ? 1 : 0);
                    return true;
                }
            }
            case BOOLEAN: {
                if (ANALYTICS_EVENT_SPECIFIC_ATTRIBUTES.equals(name) && value instanceof Boolean) {
                    span.setMetric((CharSequence)"_dd1.sr.eausr", (Boolean)value != false ? 1 : 0);
                    return true;
                }
            }
            case LONG: {
                if (!HTTP_RESPONSE_STATUS_CODE_ATTRIBUTE.equals(name) || !(value instanceof Number)) break;
                span.setHttpStatusCode(((Number)value).intValue());
                return true;
            }
        }
        return false;
    }

    public static void applyNamingConvention(AgentSpan span) {
        if (span.getOperationName() == SPAN_KIND_INTERNAL) {
            span.setOperationName(OtelConventions.computeOperationName(span).toLowerCase(Locale.ROOT));
        }
    }

    public static void setEventsAsTag(AgentSpan span, List<OtelSpanEvent> events) {
        if (events == null || events.isEmpty()) {
            return;
        }
        span.setTag("events", OtelSpanEvent.toTag(events));
    }

    public static void applySpanEventExceptionAttributesAsTags(AgentSpan span, Attributes exceptionAttributes) {
        span.setTag("error.message", exceptionAttributes.get(OtelSpanEvent.EXCEPTION_MESSAGE_ATTRIBUTE_KEY));
        span.setTag("error.type", exceptionAttributes.get(OtelSpanEvent.EXCEPTION_TYPE_ATTRIBUTE_KEY));
        span.setTag("error.stack", exceptionAttributes.get(OtelSpanEvent.EXCEPTION_STACK_TRACE_ATTRIBUTE_KEY));
    }

    private static String computeOperationName(AgentSpan span) {
        Object spanKingTag = span.getTag("span.kind");
        SpanKind spanKind = spanKingTag instanceof String ? OtelConventions.toOtelSpanKind((String)spanKingTag) : SpanKind.INTERNAL;
        String httpRequestMethod = OtelConventions.getStringAttribute(span, "http.request.method");
        if (spanKind == SpanKind.SERVER && httpRequestMethod != null) {
            return "http.server.request";
        }
        if (spanKind == SpanKind.CLIENT && httpRequestMethod != null) {
            return "http.client.request";
        }
        String dbSystem = OtelConventions.getStringAttribute(span, "db.system");
        if (spanKind == SpanKind.CLIENT && dbSystem != null) {
            return dbSystem + ".query";
        }
        String messagingSystem = OtelConventions.getStringAttribute(span, "messaging.system");
        String messagingOperation = OtelConventions.getStringAttribute(span, "messaging.operation");
        if ((spanKind == SpanKind.CONSUMER || spanKind == SpanKind.PRODUCER || spanKind == SpanKind.CLIENT || spanKind == SpanKind.SERVER) && messagingSystem != null && messagingOperation != null) {
            return messagingSystem + "." + messagingOperation;
        }
        String rpcSystem = OtelConventions.getStringAttribute(span, "rpc.system");
        if (spanKind == SpanKind.CLIENT && "aws-api".equals(rpcSystem)) {
            String service = OtelConventions.getStringAttribute(span, "rpc.service");
            if (service == null) {
                return "aws.client.request";
            }
            return "aws." + service + ".request";
        }
        if (spanKind == SpanKind.CLIENT && rpcSystem != null) {
            return rpcSystem + ".client.request";
        }
        if (spanKind == SpanKind.SERVER && rpcSystem != null) {
            return rpcSystem + ".server.request";
        }
        String faasInvokedProvider = OtelConventions.getStringAttribute(span, "faas.invoked_provider");
        String faasInvokedName = OtelConventions.getStringAttribute(span, "faas.invoked_name");
        if (spanKind == SpanKind.CLIENT && faasInvokedProvider != null && faasInvokedName != null) {
            return faasInvokedProvider + "." + faasInvokedName + ".invoke";
        }
        String faasTrigger = OtelConventions.getStringAttribute(span, "faas.trigger");
        if (spanKind == SpanKind.SERVER && faasTrigger != null) {
            return faasTrigger + ".invoke";
        }
        String graphqlOperationType = OtelConventions.getStringAttribute(span, "graphql.operation.type");
        if (graphqlOperationType != null) {
            return "graphql.server.request";
        }
        String networkProtocolName = OtelConventions.getStringAttribute(span, "network.protocol.name");
        if (spanKind == SpanKind.SERVER) {
            return networkProtocolName == null ? "server.request" : networkProtocolName + ".server.request";
        }
        if (spanKind == SpanKind.CLIENT) {
            return networkProtocolName == null ? "client.request" : networkProtocolName + ".client.request";
        }
        return spanKind.name();
    }

    @Nullable
    private static String getStringAttribute(AgentSpan span, String key) {
        Object tag = span.getTag(key);
        if (tag == null) {
            return null;
        }
        if (!(tag instanceof String)) {
            LOGGER.debug("Span attributes {} is not a string", (Object)key);
            return key;
        }
        return (String)tag;
    }

    public static AgentSpan.Attributes convertAttributes(Attributes attributes) {
        if (attributes.isEmpty()) {
            return SpanAttributes.EMPTY;
        }
        SpanAttributes.Builder builder = SpanAttributes.builder();
        attributes.forEach((attributeKey, value) -> {
            String key = attributeKey.getKey();
            switch (attributeKey.getType()) {
                case STRING: {
                    builder.put(key, (String)value);
                    break;
                }
                case BOOLEAN: {
                    builder.put(key, (Boolean)value);
                    break;
                }
                case LONG: {
                    builder.put(key, (Long)value);
                    break;
                }
                case DOUBLE: {
                    builder.put(key, (Double)value);
                    break;
                }
                case STRING_ARRAY: {
                    builder.putStringArray(key, (List)value);
                    break;
                }
                case BOOLEAN_ARRAY: {
                    builder.putBooleanArray(key, (List)value);
                    break;
                }
                case LONG_ARRAY: {
                    builder.putLongArray(key, (List)value);
                    break;
                }
                case DOUBLE_ARRAY: {
                    builder.putDoubleArray(key, (List)value);
                }
            }
        });
        return builder.build();
    }
}

