/*
 * Decompiled with CFR 0.152.
 */
package datadog.context;

import datadog.context.Context;
import datadog.context.ContextManager;
import datadog.context.ContextScope;
import datadog.context.EmptyContext;

final class ThreadLocalContextManager
implements ContextManager {
    private static final ThreadLocal<Context[]> CURRENT_HOLDER = ThreadLocal.withInitial(() -> new Context[]{EmptyContext.INSTANCE});

    ThreadLocalContextManager() {
    }

    @Override
    public Context root() {
        return EmptyContext.INSTANCE;
    }

    @Override
    public Context current() {
        return CURRENT_HOLDER.get()[0];
    }

    @Override
    public ContextScope attach(final Context context) {
        final Context[] holder = CURRENT_HOLDER.get();
        final Context previous = holder[0];
        holder[0] = context;
        return new ContextScope(){
            private boolean closed;

            @Override
            public Context context() {
                return context;
            }

            @Override
            public void close() {
                if (!this.closed && context == holder[0]) {
                    holder[0] = previous;
                    this.closed = true;
                }
            }
        };
    }

    @Override
    public Context swap(Context context) {
        Context[] holder = CURRENT_HOLDER.get();
        Context previous = holder[0];
        holder[0] = context;
        return previous;
    }
}

