/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.appsec;

import datadog.appsec.api.blocking.BlockingException;
import datadog.trace.api.EventTracker;
import datadog.trace.api.GlobalTracer;
import datadog.trace.api.UserIdCollectionMode;
import datadog.trace.api.gateway.BlockResponseFunction;
import datadog.trace.api.gateway.CallbackProvider;
import datadog.trace.api.gateway.EventType;
import datadog.trace.api.gateway.Events;
import datadog.trace.api.gateway.Flow;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.api.gateway.RequestContextSlot;
import datadog.trace.bootstrap.ActiveSubsystems;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import java.util.Map;
import java.util.function.BiFunction;

public class AppSecEventTracker
extends EventTracker {
    private static AppSecEventTracker INSTANCE;

    public static AppSecEventTracker getEventTracker() {
        return INSTANCE;
    }

    public static void setEventTracker(AppSecEventTracker tracker) {
        INSTANCE = tracker;
        GlobalTracer.setEventTracker(tracker == null ? EventTracker.NO_EVENT_TRACKER : tracker);
    }

    @Override
    public final void trackLoginSuccessEvent(String userId, Map<String, String> metadata) {
        if (userId == null || userId.isEmpty()) {
            throw new IllegalArgumentException("UserId is null or empty");
        }
        this.onLoginSuccessEvent(UserIdCollectionMode.SDK, userId, metadata);
    }

    @Override
    public final void trackLoginFailureEvent(String userId, boolean exists, Map<String, String> metadata) {
        if (userId == null || userId.isEmpty()) {
            throw new IllegalArgumentException("UserId is null or empty");
        }
        this.onLoginFailureEvent(UserIdCollectionMode.SDK, userId, exists, metadata);
    }

    @Override
    public final void trackCustomEvent(String eventName, Map<String, String> metadata) {
        if (eventName == null || eventName.isEmpty()) {
            throw new IllegalArgumentException("EventName is null or empty");
        }
        this.onCustomEvent(UserIdCollectionMode.SDK, eventName, metadata);
    }

    public void onUserNotFound(UserIdCollectionMode mode) {
        if (!this.isEnabled(mode)) {
            return;
        }
        this.dispatch(Events.EVENTS.loginEvent(), (ctx, callback) -> callback.apply((RequestContext)ctx, mode, "users.login.failure", false, null, null));
    }

    public void onUserEvent(UserIdCollectionMode mode, String userId) {
        if (!this.isEnabled(mode)) {
            return;
        }
        this.dispatch(Events.EVENTS.user(), (ctx, cb) -> (Flow)cb.apply(ctx, mode, userId));
    }

    public void onSignupEvent(UserIdCollectionMode mode, String userId, Map<String, String> metadata) {
        if (!this.isEnabled(mode)) {
            return;
        }
        this.dispatch(Events.EVENTS.loginEvent(), (ctx, callback) -> callback.apply((RequestContext)ctx, mode, "users.signup", null, userId, metadata));
    }

    public void onLoginSuccessEvent(UserIdCollectionMode mode, String userId, Map<String, String> metadata) {
        if (!this.isEnabled(mode)) {
            return;
        }
        this.dispatch(Events.EVENTS.loginEvent(), (ctx, cb) -> cb.apply((RequestContext)ctx, mode, "users.login.success", null, userId, metadata));
    }

    public void onLoginFailureEvent(UserIdCollectionMode mode, String userId, Boolean exists, Map<String, String> metadata) {
        if (!this.isEnabled(mode)) {
            return;
        }
        this.dispatch(Events.EVENTS.loginEvent(), (ctx, cb) -> cb.apply((RequestContext)ctx, mode, "users.login.failure", exists, userId, metadata));
    }

    public void onCustomEvent(UserIdCollectionMode mode, String eventName, Map<String, String> metadata) {
        if (!this.isEnabled(mode)) {
            return;
        }
        this.dispatch(Events.EVENTS.loginEvent(), (ctx, cb) -> cb.apply((RequestContext)ctx, mode, eventName, null, null, metadata));
    }

    private <T> void dispatch(EventType<T> event, BiFunction<RequestContext, T, Flow<Void>> consumer) {
        AgentTracer.TracerAPI tracer = this.tracer();
        if (tracer == null) {
            return;
        }
        CallbackProvider cbp = tracer.getCallbackProvider(RequestContextSlot.APPSEC);
        if (cbp == null) {
            return;
        }
        AgentSpan span = tracer.activeSpan();
        if (span == null) {
            return;
        }
        RequestContext ctx = span.getRequestContext();
        if (ctx == null) {
            return;
        }
        T callback = cbp.getCallback(event);
        if (callback == null) {
            return;
        }
        Flow<Void> flow = consumer.apply(ctx, (RequestContext)callback);
        if (flow == null) {
            return;
        }
        Flow.Action action = flow.getAction();
        if (action instanceof Flow.Action.RequestBlockingAction) {
            BlockResponseFunction brf = ctx.getBlockResponseFunction();
            if (brf != null) {
                Flow.Action.RequestBlockingAction rba = (Flow.Action.RequestBlockingAction)action;
                brf.tryCommitBlockingResponse(ctx.getTraceSegment(), rba.getStatusCode(), rba.getBlockingContentType(), rba.getExtraHeaders());
            }
            throw new BlockingException("Blocked request (for user)");
        }
    }

    protected boolean isEnabled(UserIdCollectionMode mode) {
        return ActiveSubsystems.APPSEC_ACTIVE && mode != UserIdCollectionMode.DISABLED;
    }

    protected AgentTracer.TracerAPI tracer() {
        return AgentTracer.get();
    }
}

