/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.git;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.api.ConfigCollector;
import datadog.trace.api.ConfigOrigin;
import datadog.trace.api.git.CommitInfo;
import datadog.trace.api.git.GitInfo;
import datadog.trace.api.git.GitInfoBuilder;
import datadog.trace.api.git.GitUtils;
import datadog.trace.api.git.PersonInfo;
import javax.annotation.Nullable;

public class UserSuppliedGitInfoBuilder
implements GitInfoBuilder {
    private static final Logger log = LoggerFactory.getLogger(UserSuppliedGitInfoBuilder.class);

    @Override
    public GitInfo build(@Nullable String repositoryPath) {
        String gitCommitSha;
        String gitRepositoryUrl = System.getenv("DD_GIT_REPOSITORY_URL");
        if (gitRepositoryUrl == null) {
            gitRepositoryUrl = Config.get().getGlobalTags().get("git.repository_url");
        }
        String gitTag = System.getenv("DD_GIT_TAG");
        String gitBranch = null;
        String gitBranchOrTag = System.getenv("DD_GIT_BRANCH");
        if (gitBranchOrTag != null) {
            if (!GitUtils.isTagReference(gitBranchOrTag)) {
                gitBranch = GitUtils.normalizeBranch(gitBranchOrTag);
            } else if (gitTag == null) {
                gitTag = GitUtils.normalizeTag(gitBranchOrTag);
            }
        }
        if ((gitCommitSha = System.getenv("DD_GIT_COMMIT_SHA")) == null) {
            gitCommitSha = Config.get().getGlobalTags().get("git.commit.sha");
        }
        ConfigCollector.get().put("DD_GIT_REPOSITORY_URL", gitRepositoryUrl, ConfigOrigin.ENV);
        ConfigCollector.get().put("DD_GIT_COMMIT_SHA", gitCommitSha, ConfigOrigin.ENV);
        String gitCommitMessage = System.getenv("DD_GIT_COMMIT_MESSAGE");
        String gitCommitAuthorName = System.getenv("DD_GIT_COMMIT_AUTHOR_NAME");
        String gitCommitAuthorEmail = System.getenv("DD_GIT_COMMIT_AUTHOR_EMAIL");
        String gitCommitAuthorDate = System.getenv("DD_GIT_COMMIT_AUTHOR_DATE");
        String gitCommitCommitterName = System.getenv("DD_GIT_COMMIT_COMMITTER_NAME");
        String gitCommitCommitterEmail = System.getenv("DD_GIT_COMMIT_COMMITTER_EMAIL");
        String gitCommitCommitterDate = System.getenv("DD_GIT_COMMIT_COMMITTER_DATE");
        GitInfo gitInfo = new GitInfo(gitRepositoryUrl, gitBranch, gitTag, new CommitInfo(gitCommitSha, new PersonInfo(gitCommitAuthorName, gitCommitAuthorEmail, gitCommitAuthorDate), new PersonInfo(gitCommitCommitterName, gitCommitCommitterEmail, gitCommitCommitterDate), gitCommitMessage));
        if (!gitInfo.isEmpty()) {
            String commitSha;
            String repoUrl = gitInfo.getRepositoryURL();
            if (repoUrl == null || repoUrl.isEmpty()) {
                log.error("Could not resolve git repository URL (can be provided via DD_GIT_REPOSITORY_URL env var, tags config property or by embedding git metadata at build time)");
            }
            if (!GitUtils.isValidCommitSha(commitSha = gitInfo.getCommit().getSha())) {
                log.error("Git commit SHA could not be resolved or is invalid: " + commitSha + " (can be provided via " + "DD_GIT_COMMIT_SHA" + " env var, " + "tags" + " config property or by embedding git metadata at build time; must be a full-length SHA_");
            }
        }
        return gitInfo;
    }

    @Override
    public int order() {
        return 0;
    }
}

