/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.telemetry;

import datadog.trace.api.telemetry.LoginEvent;
import datadog.trace.api.telemetry.LoginFramework;
import datadog.trace.api.telemetry.MetricCollector;
import datadog.trace.api.telemetry.RuleType;
import datadog.trace.api.telemetry.WafTruncatedType;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class WafMetricCollector
implements MetricCollector<WafMetric> {
    public static WafMetricCollector INSTANCE = new WafMetricCollector();
    private static final int ABSTRACT_POWERWAF_EXCEPTION_NUMBER = 3;
    private static final String NAMESPACE = "appsec";
    private static final BlockingQueue<WafMetric> rawMetricsQueue = new ArrayBlockingQueue<WafMetric>(1024);
    private static final AtomicInteger wafInitCounter = new AtomicInteger();
    private static final AtomicInteger wafUpdatesCounter = new AtomicInteger();
    private static final AtomicRequestCounter wafRequestCounter = new AtomicRequestCounter();
    private static final AtomicRequestCounter wafTriggeredRequestCounter = new AtomicRequestCounter();
    private static final AtomicRequestCounter wafBlockedRequestCounter = new AtomicRequestCounter();
    private static final AtomicRequestCounter wafTimeoutRequestCounter = new AtomicRequestCounter();
    private static final AtomicRequestCounter wafErrorRequestCounter = new AtomicRequestCounter();
    private static final AtomicRequestCounter wafRateLimitedRequestCounter = new AtomicRequestCounter();
    private static final AtomicRequestCounter wafBlockFailureRequestCounter = new AtomicRequestCounter();
    private static final AtomicLongArray wafInputTruncatedCounter = new AtomicLongArray(WafTruncatedType.values().length);
    private static final AtomicLongArray raspRuleEvalCounter = new AtomicLongArray(RuleType.getNumValues());
    private static final AtomicLongArray raspRuleMatchCounter = new AtomicLongArray(RuleType.getNumValues());
    private static final AtomicLongArray raspTimeoutCounter = new AtomicLongArray(RuleType.getNumValues());
    private static final ConcurrentMap<Integer, AtomicLongArray> raspErrorCodeCounter = new ConcurrentSkipListMap<Integer, AtomicLongArray>();
    private static final ConcurrentMap<Integer, AtomicLongArray> wafErrorCodeCounter = new ConcurrentSkipListMap<Integer, AtomicLongArray>();
    private static final AtomicLongArray missingUserLoginQueue;
    private static final AtomicLongArray missingUserIdQueue;
    private static String wafVersion;
    private static String rulesVersion;

    public static WafMetricCollector get() {
        return INSTANCE;
    }

    private WafMetricCollector() {
    }

    public void wafInit(String wafVersion, String rulesVersion, boolean success) {
        WafMetricCollector.wafVersion = wafVersion;
        WafMetricCollector.rulesVersion = rulesVersion;
        rawMetricsQueue.offer(new WafInitRawMetric(wafInitCounter.incrementAndGet(), wafVersion, rulesVersion, success));
    }

    public void wafUpdates(String rulesVersion, boolean success) {
        rawMetricsQueue.offer(new WafUpdatesRawMetric(wafUpdatesCounter.incrementAndGet(), wafVersion, rulesVersion, success));
        if (rulesVersion != null && WafMetricCollector.rulesVersion != null && !rulesVersion.equals(WafMetricCollector.rulesVersion)) {
            WafMetricCollector.get().prepareMetrics();
        }
        WafMetricCollector.rulesVersion = rulesVersion;
    }

    public void wafRequest() {
        wafRequestCounter.increment();
    }

    public void wafRequestTriggered() {
        wafTriggeredRequestCounter.increment();
    }

    public void wafRequestBlocked() {
        wafBlockedRequestCounter.increment();
    }

    public void wafRequestTimeout() {
        wafTimeoutRequestCounter.increment();
    }

    public void wafRequestError() {
        wafErrorRequestCounter.increment();
    }

    public void wafRequestRateLimited() {
        wafRateLimitedRequestCounter.increment();
    }

    public void wafRequestBlockFailure() {
        wafBlockFailureRequestCounter.increment();
    }

    public void wafInputTruncated(WafTruncatedType wafTruncatedType, long increment) {
        wafInputTruncatedCounter.addAndGet(wafTruncatedType.ordinal(), increment);
    }

    public void raspRuleEval(RuleType ruleType) {
        raspRuleEvalCounter.incrementAndGet(ruleType.ordinal());
    }

    public void raspRuleMatch(RuleType ruleType) {
        raspRuleMatchCounter.incrementAndGet(ruleType.ordinal());
    }

    public void raspTimeout(RuleType ruleType) {
        raspTimeoutCounter.incrementAndGet(ruleType.ordinal());
    }

    public void raspErrorCode(RuleType ruleType, int ddwafRunErrorCode) {
        ((AtomicLongArray)raspErrorCodeCounter.get(ddwafRunErrorCode)).incrementAndGet(ruleType.ordinal());
    }

    public void wafErrorCode(RuleType ruleType, int ddwafRunErrorCode) {
        ((AtomicLongArray)wafErrorCodeCounter.get(ddwafRunErrorCode)).incrementAndGet(ruleType.ordinal());
    }

    public void missingUserLogin(LoginFramework framework, LoginEvent eventType) {
        missingUserLoginQueue.incrementAndGet(framework.ordinal() * LoginEvent.getNumValues() + eventType.ordinal());
    }

    public void missingUserId(LoginFramework framework) {
        missingUserIdQueue.incrementAndGet(framework.ordinal());
    }

    @Override
    public Collection<WafMetric> drain() {
        LinkedList<WafMetric> list;
        int drained;
        if (!rawMetricsQueue.isEmpty() && (drained = rawMetricsQueue.drainTo(list = new LinkedList<WafMetric>())) > 0) {
            return list;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void prepareMetrics() {
        long counter;
        boolean isRateLimited = wafRateLimitedRequestCounter.getAndReset() > 0L;
        boolean isBlockFailure = wafBlockFailureRequestCounter.getAndReset() > 0L;
        boolean isWafInputTruncated = false;
        for (WafTruncatedType wafTruncatedType : WafTruncatedType.values()) {
            boolean bl = isWafInputTruncated = wafInputTruncatedCounter.getAndSet(wafTruncatedType.ordinal(), 0L) > 0L;
            if (isWafInputTruncated) break;
        }
        if (wafRequestCounter.get() > 0L && !rawMetricsQueue.offer(new WafRequestsRawMetric(wafRequestCounter.getAndReset(), wafVersion, rulesVersion, false, false, false, false, isBlockFailure, isRateLimited, isWafInputTruncated))) {
            return;
        }
        if (wafTriggeredRequestCounter.get() > 0L && !rawMetricsQueue.offer(new WafRequestsRawMetric(wafTriggeredRequestCounter.getAndReset(), wafVersion, rulesVersion, true, false, false, false, isBlockFailure, isRateLimited, isWafInputTruncated))) {
            return;
        }
        if (wafBlockedRequestCounter.get() > 0L && !rawMetricsQueue.offer(new WafRequestsRawMetric(wafBlockedRequestCounter.getAndReset(), wafVersion, rulesVersion, true, true, false, false, isBlockFailure, isRateLimited, isWafInputTruncated))) {
            return;
        }
        if (wafTimeoutRequestCounter.get() > 0L && !rawMetricsQueue.offer(new WafRequestsRawMetric(wafTimeoutRequestCounter.getAndReset(), wafVersion, rulesVersion, false, false, false, true, isBlockFailure, isRateLimited, isWafInputTruncated))) {
            return;
        }
        if (wafErrorRequestCounter.get() > 0L && !rawMetricsQueue.offer(new WafRequestsRawMetric(wafErrorRequestCounter.getAndReset(), wafVersion, rulesVersion, false, false, true, false, isBlockFailure, isRateLimited, isWafInputTruncated))) {
            return;
        }
        for (Enum enum_ : RuleType.values()) {
            counter = raspRuleEvalCounter.getAndSet(enum_.ordinal(), 0L);
            if (counter <= 0L || rawMetricsQueue.offer(new RaspRuleEval(counter, (RuleType)enum_, wafVersion))) continue;
            return;
        }
        for (Enum enum_ : RuleType.values()) {
            counter = raspRuleMatchCounter.getAndSet(enum_.ordinal(), 0L);
            if (counter <= 0L || rawMetricsQueue.offer(new RaspRuleMatch(counter, (RuleType)enum_, wafVersion))) continue;
            return;
        }
        for (Enum enum_ : RuleType.values()) {
            counter = raspTimeoutCounter.getAndSet(enum_.ordinal(), 0L);
            if (counter <= 0L || rawMetricsQueue.offer(new RaspTimeout(counter, (RuleType)enum_, wafVersion))) continue;
            return;
        }
        for (int i = -3; i < 0; ++i) {
            void var7_18;
            RuleType[] ruleTypeArray = RuleType.values();
            int n = ruleTypeArray.length;
            boolean bl = false;
            while (var7_18 < n) {
                RuleType ruleType2 = ruleTypeArray[var7_18];
                long counter2 = ((AtomicLongArray)raspErrorCodeCounter.get(i)).getAndSet(ruleType2.ordinal(), 0L);
                if (counter2 > 0L) {
                    if (!rawMetricsQueue.offer(new RaspError(counter2, ruleType2, wafVersion, i))) {
                        return;
                    }
                    if (!rawMetricsQueue.offer(new WafError(counter2, ruleType2, wafVersion, i))) {
                        return;
                    }
                }
                ++var7_18;
            }
        }
        for (LoginFramework loginFramework : LoginFramework.values()) {
            for (LoginEvent event : LoginEvent.values()) {
                int ordinal = loginFramework.ordinal() * LoginEvent.getNumValues() + event.ordinal();
                long counter3 = missingUserLoginQueue.getAndSet(ordinal, 0L);
                if (counter3 <= 0L || rawMetricsQueue.offer(new MissingUserLoginMetric(counter3, loginFramework.getTag(), event.getTag()))) continue;
                return;
            }
        }
        for (LoginFramework loginFramework : LoginFramework.values()) {
            long counter4 = missingUserIdQueue.getAndSet(loginFramework.ordinal(), 0L);
            if (counter4 <= 0L || rawMetricsQueue.offer(new MissingUserIdMetric(counter4, loginFramework.getTag()))) continue;
            return;
        }
    }

    static {
        for (int i = -3; i < 0; ++i) {
            raspErrorCodeCounter.put(i, new AtomicLongArray(RuleType.getNumValues()));
            wafErrorCodeCounter.put(i, new AtomicLongArray(RuleType.getNumValues()));
        }
        missingUserLoginQueue = new AtomicLongArray(LoginFramework.getNumValues() * LoginEvent.getNumValues());
        missingUserIdQueue = new AtomicLongArray(LoginFramework.getNumValues());
        wafVersion = "";
        rulesVersion = "";
    }

    public static class AtomicRequestCounter {
        private final AtomicLong atomicLong = new AtomicLong();
        private volatile long timestamp;

        public final long get() {
            return this.atomicLong.get();
        }

        public final long getAndReset() {
            this.timestamp = 0L;
            return this.atomicLong.getAndSet(0L);
        }

        public final void increment() {
            if (this.timestamp == 0L) {
                this.timestamp = System.currentTimeMillis();
            }
            this.atomicLong.incrementAndGet();
        }
    }

    public static class WafError
    extends WafMetric {
        public WafError(long counter, RuleType ruleType, String wafVersion, Integer ddwafRunError) {
            String[] stringArray;
            if (ruleType.variant != null) {
                String[] stringArray2 = new String[5];
                stringArray2[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray2[1] = "rule_variant:" + (Object)((Object)ruleType.variant);
                stringArray2[2] = "waf_version:" + wafVersion;
                stringArray2[3] = "event_rules_version:" + rulesVersion;
                stringArray = stringArray2;
                stringArray2[4] = "waf_error:" + ddwafRunError;
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray3[1] = "waf_version:" + wafVersion;
                stringArray = stringArray3;
                stringArray3[2] = "waf_error:" + ddwafRunError;
            }
            super("waf.error", counter, stringArray);
        }
    }

    public static class RaspError
    extends WafMetric {
        public RaspError(long counter, RuleType ruleType, String wafVersion, Integer ddwafRunError) {
            String[] stringArray;
            if (ruleType.variant != null) {
                String[] stringArray2 = new String[5];
                stringArray2[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray2[1] = "rule_variant:" + (Object)((Object)ruleType.variant);
                stringArray2[2] = "waf_version:" + wafVersion;
                stringArray2[3] = "event_rules_version:" + rulesVersion;
                stringArray = stringArray2;
                stringArray2[4] = "waf_error:" + ddwafRunError;
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray3[1] = "waf_version:" + wafVersion;
                stringArray = stringArray3;
                stringArray3[2] = "waf_error:" + ddwafRunError;
            }
            super("rasp.error", counter, stringArray);
        }
    }

    public static class RaspTimeout
    extends WafMetric {
        public RaspTimeout(long counter, RuleType ruleType, String wafVersion) {
            String[] stringArray;
            if (ruleType.variant != null) {
                String[] stringArray2 = new String[4];
                stringArray2[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray2[1] = "rule_variant:" + (Object)((Object)ruleType.variant);
                stringArray2[2] = "waf_version:" + wafVersion;
                stringArray = stringArray2;
                stringArray2[3] = "event_rules_version:" + rulesVersion;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray = stringArray3;
                stringArray3[1] = "waf_version:" + wafVersion;
            }
            super("rasp.timeout", counter, stringArray);
        }
    }

    public static class RaspRuleMatch
    extends WafMetric {
        public RaspRuleMatch(long counter, RuleType ruleType, String wafVersion) {
            String[] stringArray;
            if (ruleType.variant != null) {
                String[] stringArray2 = new String[4];
                stringArray2[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray2[1] = "rule_variant:" + (Object)((Object)ruleType.variant);
                stringArray2[2] = "waf_version:" + wafVersion;
                stringArray = stringArray2;
                stringArray2[3] = "event_rules_version:" + rulesVersion;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray = stringArray3;
                stringArray3[1] = "waf_version:" + wafVersion;
            }
            super("rasp.rule.match", counter, stringArray);
        }
    }

    public static class RaspRuleEval
    extends WafMetric {
        public RaspRuleEval(long counter, RuleType ruleType, String wafVersion) {
            String[] stringArray;
            if (ruleType.variant != null) {
                String[] stringArray2 = new String[4];
                stringArray2[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray2[1] = "rule_variant:" + (Object)((Object)ruleType.variant);
                stringArray2[2] = "waf_version:" + wafVersion;
                stringArray = stringArray2;
                stringArray2[3] = "event_rules_version:" + rulesVersion;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray = stringArray3;
                stringArray3[1] = "waf_version:" + wafVersion;
            }
            super("rasp.rule.eval", counter, stringArray);
        }
    }

    public static class WafRequestsRawMetric
    extends WafMetric {
        public WafRequestsRawMetric(long counter, String wafVersion, String rulesVersion, boolean triggered, boolean blocked, boolean wafError, boolean wafTimeout, boolean blockFailure, boolean rateLimited, boolean inputTruncated) {
            super("waf.requests", counter, "waf_version:" + wafVersion, "event_rules_version:" + rulesVersion, "rule_triggered:" + triggered, "request_blocked:" + blocked, "waf_error:" + wafError, "waf_timeout:" + wafTimeout, "block_failure:" + blockFailure, "rate_limited:" + rateLimited, "input_truncated:" + inputTruncated);
        }
    }

    public static class MissingUserIdMetric
    extends WafMetric {
        public MissingUserIdMetric(long counter, String framework) {
            super("instrum.user_auth.missing_user_id", counter, "framework:" + framework, "event_type:authenticated_request");
        }
    }

    public static class MissingUserLoginMetric
    extends WafMetric {
        public MissingUserLoginMetric(long counter, String framework, String type) {
            super("instrum.user_auth.missing_user_login", counter, "framework:" + framework, "event_type:" + type);
        }
    }

    public static class WafUpdatesRawMetric
    extends WafMetric {
        public WafUpdatesRawMetric(long counter, String wafVersion, String rulesVersion, boolean success) {
            super("waf.updates", counter, "waf_version:" + wafVersion, "event_rules_version:" + rulesVersion, "success:" + success);
        }
    }

    public static class WafInitRawMetric
    extends WafMetric {
        public WafInitRawMetric(long counter, String wafVersion, String rulesVersion, boolean success) {
            super("waf.init", counter, "waf_version:" + wafVersion, "event_rules_version:" + rulesVersion, "success:" + success);
        }
    }

    public static abstract class WafMetric
    extends MetricCollector.Metric {
        public WafMetric(String metricName, long counter, String ... tags) {
            super(WafMetricCollector.NAMESPACE, true, metricName, "count", (Number)counter, tags);
        }
    }
}

