/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.java.concurrent;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.ContextStore;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.java.concurrent.ExcludeFilter;
import datadog.trace.bootstrap.instrumentation.java.concurrent.State;
import java.util.concurrent.Executor;

public final class ExecutorInstrumentationUtils {
    private static final Logger log = LoggerFactory.getLogger(ExecutorInstrumentationUtils.class);

    public static boolean shouldAttachStateToTask(Object task, Executor executor) {
        if (task == null) {
            return false;
        }
        if (ExcludeFilter.exclude(ExcludeFilter.ExcludeType.EXECUTOR, task)) {
            return false;
        }
        return AgentTracer.activeSpan() != null && AgentTracer.isAsyncPropagationEnabled();
    }

    public static <T> State setupState(ContextStore<T, State> contextStore, T task, AgentSpan span) {
        State state = contextStore.putIfAbsent(task, State.FACTORY);
        if (!state.captureAndSetContinuation(span)) {
            log.debug("continuation was already set for {} in span {}, no continuation captured.", (Object)task, (Object)span);
        }
        return state;
    }

    public static void cleanUpOnMethodExit(Executor executor, State state, Throwable throwable) {
        if (null != state && null != throwable) {
            state.closeContinuation();
        }
    }

    private ExecutorInstrumentationUtils() {
    }
}

