/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.trace;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.DDSpanId;
import datadog.trace.api.DDTraceId;
import datadog.trace.api.datastreams.PathwayContext;
import datadog.trace.bootstrap.instrumentation.api.AgentSpanContext;
import datadog.trace.bootstrap.instrumentation.api.AgentTraceCollector;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.otel.api.trace.Span;
import datadog.trace.bootstrap.otel.api.trace.SpanContext;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.shim.trace.OtelSpan;
import datadog.trace.bootstrap.otel.shim.trace.OtelSpanContext;
import java.util.Map;

public class OtelExtractedContext
implements AgentSpanContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(OtelExtractedContext.class);
    private final DDTraceId traceId;
    private final long spanId;
    private final int prioritySampling;

    private OtelExtractedContext(SpanContext context) {
        this.traceId = DDTraceId.fromHex(context.getTraceId());
        this.spanId = DDSpanId.fromHex(context.getSpanId());
        this.prioritySampling = context.isSampled() ? 1 : -128;
    }

    public static AgentSpanContext extract(Context context) {
        Span span = Span.fromContext(context);
        if (span instanceof OtelSpan) {
            return ((OtelSpan)span).getAgentSpanContext();
        }
        SpanContext spanContext = span.getSpanContext();
        if (spanContext instanceof OtelSpanContext) {
            return ((OtelSpanContext)spanContext).delegate;
        }
        if (spanContext.isValid()) {
            try {
                return new OtelExtractedContext(spanContext);
            }
            catch (NumberFormatException e) {
                LOGGER.debug("Failed to convert span context with trace id = {} and span id = {}", (Object)spanContext.getTraceId(), (Object)spanContext.getSpanId());
            }
        }
        return null;
    }

    @Override
    public DDTraceId getTraceId() {
        return this.traceId;
    }

    @Override
    public long getSpanId() {
        return this.spanId;
    }

    @Override
    public AgentTraceCollector getTraceCollector() {
        return AgentTracer.NoopAgentTraceCollector.INSTANCE;
    }

    @Override
    public int getSamplingPriority() {
        return this.prioritySampling;
    }

    @Override
    public Iterable<Map.Entry<String, String>> baggageItems() {
        return null;
    }

    @Override
    public PathwayContext getPathwayContext() {
        return null;
    }
}

