/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.trace;

import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentSpanContext;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.otel.api.common.AttributeKey;
import datadog.trace.bootstrap.otel.api.common.Attributes;
import datadog.trace.bootstrap.otel.api.trace.Span;
import datadog.trace.bootstrap.otel.api.trace.SpanBuilder;
import datadog.trace.bootstrap.otel.api.trace.SpanContext;
import datadog.trace.bootstrap.otel.api.trace.SpanKind;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.shim.context.OtelContext;
import datadog.trace.bootstrap.otel.shim.trace.OtelConventions;
import datadog.trace.bootstrap.otel.shim.trace.OtelExtractedContext;
import datadog.trace.bootstrap.otel.shim.trace.OtelSpan;
import datadog.trace.bootstrap.otel.shim.trace.OtelSpanLink;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class OtelSpanBuilder
implements SpanBuilder {
    private final AgentTracer.SpanBuilder delegate;
    private boolean spanKindSet;
    private boolean ignoreActiveSpan;
    private String overriddenOperationName;
    private int overriddenAnalyticsSampleRate;
    private int overriddenHttpStatusCode;

    public OtelSpanBuilder(AgentTracer.SpanBuilder delegate) {
        this.delegate = delegate;
        this.spanKindSet = false;
        this.overriddenOperationName = null;
        this.overriddenAnalyticsSampleRate = -1;
        this.overriddenHttpStatusCode = -1;
    }

    @Override
    public SpanBuilder setParent(Context context) {
        AgentSpanContext extractedContext = OtelExtractedContext.extract(context);
        if (extractedContext != null) {
            this.delegate.asChildOf(extractedContext);
            this.ignoreActiveSpan = true;
        }
        return this;
    }

    @Override
    public SpanBuilder setNoParent() {
        this.delegate.ignoreActiveSpan().asChildOf(null);
        this.ignoreActiveSpan = true;
        return this;
    }

    @Override
    public SpanBuilder addLink(SpanContext spanContext) {
        if (spanContext.isValid()) {
            this.delegate.withLink(new OtelSpanLink(spanContext));
        }
        return this;
    }

    @Override
    public SpanBuilder addLink(SpanContext spanContext, Attributes attributes) {
        if (spanContext.isValid()) {
            this.delegate.withLink(new OtelSpanLink(spanContext, attributes));
        }
        return this;
    }

    @Override
    public SpanBuilder setAttribute(String key, String value) {
        if ("operation.name".equals(key) && value != null) {
            this.overriddenOperationName = value.toLowerCase(Locale.ROOT);
            return this;
        }
        if ("analytics.event".equals(key) && value != null) {
            this.overriddenAnalyticsSampleRate = Boolean.parseBoolean(value) ? 1 : 0;
            return this;
        }
        this.delegate.withTag(key, (Object)value);
        return this;
    }

    @Override
    public SpanBuilder setAttribute(String key, long value) {
        if ("http.response.status_code".equals(key)) {
            this.overriddenHttpStatusCode = (int)value;
            return this;
        }
        this.delegate.withTag(key, value);
        return this;
    }

    @Override
    public SpanBuilder setAttribute(String key, double value) {
        this.delegate.withTag(key, value);
        return this;
    }

    @Override
    public SpanBuilder setAttribute(String key, boolean value) {
        if ("analytics.event".equals(key)) {
            this.overriddenAnalyticsSampleRate = value ? 1 : 0;
            return this;
        }
        this.delegate.withTag(key, value);
        return this;
    }

    @Override
    public <T> SpanBuilder setAttribute(AttributeKey<T> key, T value) {
        String name = key.getKey();
        switch (key.getType()) {
            case STRING: {
                if (value instanceof String) {
                    this.setAttribute(name, (String)value);
                    break;
                }
            }
            case BOOLEAN: {
                if (value instanceof Boolean) {
                    this.setAttribute(name, (Boolean)value);
                    break;
                }
            }
            case LONG: {
                if (value instanceof Number) {
                    this.setAttribute(name, ((Number)value).longValue());
                    break;
                }
            }
            case DOUBLE: {
                if (value instanceof Number) {
                    this.setAttribute(name, ((Number)value).doubleValue());
                    break;
                }
            }
            case STRING_ARRAY: 
            case BOOLEAN_ARRAY: 
            case LONG_ARRAY: 
            case DOUBLE_ARRAY: {
                if (!(value instanceof List)) break;
                List valueList = (List)value;
                if (valueList.isEmpty()) {
                    this.delegate.withTag(name, (Object)"");
                    break;
                }
                for (int index = 0; index < valueList.size(); ++index) {
                    this.delegate.withTag(name + "." + index, valueList.get(index));
                }
                break;
            }
            default: {
                this.delegate.withTag(name, value);
            }
        }
        return this;
    }

    @Override
    public SpanBuilder setSpanKind(SpanKind spanKind) {
        if (spanKind != null) {
            this.delegate.withTag("span.kind", OtelConventions.toSpanKindTagValue(spanKind));
            this.spanKindSet = true;
        }
        return this;
    }

    @Override
    public SpanBuilder setStartTimestamp(long startTimestamp, TimeUnit unit) {
        this.delegate.withStartTimestamp(unit.toMicros(startTimestamp));
        return this;
    }

    @Override
    public Span startSpan() {
        Context context;
        if (!this.spanKindSet) {
            this.setSpanKind(SpanKind.INTERNAL);
        }
        if (!this.ignoreActiveSpan && null != (context = OtelContext.lastPropagated())) {
            this.setParent(context);
        }
        AgentSpan delegate = this.delegate.start();
        if (this.overriddenOperationName != null) {
            delegate.setOperationName(this.overriddenOperationName);
        }
        if (this.overriddenAnalyticsSampleRate != -1) {
            delegate.setMetric((CharSequence)"_dd1.sr.eausr", this.overriddenAnalyticsSampleRate);
        }
        if (this.overriddenHttpStatusCode != -1) {
            delegate.setHttpStatusCode(this.overriddenHttpStatusCode);
        }
        return new OtelSpan(delegate);
    }
}

