/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.jfr.exceptions;

import datadog.trace.bootstrap.instrumentation.jfr.ContextualEvent;
import datadog.trace.bootstrap.instrumentation.jfr.exceptions.ExceptionProfiling;
import jdk.jfr.Category;
import jdk.jfr.Description;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.Name;

@Name(value="datadog.ExceptionSample")
@Label(value="ExceptionSample")
@Description(value="Datadog exception sample event.")
@Category(value={"Datadog"})
public class ExceptionSampleEvent
extends Event
implements ContextualEvent {
    @Label(value="Exception Type")
    private final String type;
    @Label(value="Exception message")
    private final String message;
    @Label(value="Sampled")
    private final boolean sampled;
    @Label(value="First occurrence")
    private final boolean firstOccurrence;
    @Label(value="Local Root Span Id")
    private long localRootSpanId;
    @Label(value="Span Id")
    private long spanId;

    public ExceptionSampleEvent(Throwable e, boolean sampled, boolean firstOccurrence) {
        this.type = e.getClass().getName();
        this.message = ExceptionSampleEvent.getMessage(e);
        this.sampled = sampled;
        this.firstOccurrence = firstOccurrence;
        this.captureContext();
    }

    private static String getMessage(Throwable t) {
        if (ExceptionProfiling.getInstance().recordExceptionMessage()) {
            try {
                return t.getMessage();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void setContext(long localRootSpanId, long spanId) {
        this.localRootSpanId = localRootSpanId;
        this.spanId = spanId;
    }
}

