/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.appsec.api.blocking.BlockingException;
import datadog.context.Context;
import datadog.context.propagation.Propagators;
import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.api.datastreams.DataStreamsContext;
import datadog.trace.api.function.TriConsumer;
import datadog.trace.api.function.TriFunction;
import datadog.trace.api.gateway.BlockResponseFunction;
import datadog.trace.api.gateway.CallbackProvider;
import datadog.trace.api.gateway.Events;
import datadog.trace.api.gateway.Flow;
import datadog.trace.api.gateway.IGSpanInfo;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.api.gateway.RequestContextSlot;
import datadog.trace.api.naming.SpanNaming;
import datadog.trace.bootstrap.ActiveSubsystems;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentSpanContext;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.InternalSpanTypes;
import datadog.trace.bootstrap.instrumentation.api.TagContext;
import datadog.trace.bootstrap.instrumentation.api.URIDataAdapter;
import datadog.trace.bootstrap.instrumentation.api.URIUtils;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.bootstrap.instrumentation.decorator.ServerDecorator;
import datadog.trace.bootstrap.instrumentation.decorator.http.ClientIpAddressResolver;
import datadog.trace.bootstrap.instrumentation.decorator.http.HttpResourceDecorator;
import java.net.InetAddress;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public abstract class HttpServerDecorator<REQUEST, CONNECTION, RESPONSE, REQUEST_CARRIER>
extends ServerDecorator {
    private static final Logger log = LoggerFactory.getLogger(HttpServerDecorator.class);
    private static final int UNSET_PORT = 0;
    public static final String DD_SPAN_ATTRIBUTE = "datadog.span";
    public static final String DD_DISPATCH_SPAN_ATTRIBUTE = "datadog.span.dispatch";
    public static final String DD_FIN_DISP_LIST_SPAN_ATTRIBUTE = "datadog.span.finish_dispatch_listener";
    public static final String DD_RESPONSE_ATTRIBUTE = "datadog.response";
    public static final String DD_IGNORE_COMMIT_ATTRIBUTE = "datadog.commit.ignore";
    public static final LinkedHashMap<String, String> SERVER_PATHWAY_EDGE_TAGS = new LinkedHashMap(2);
    private static final UTF8BytesString DEFAULT_RESOURCE_NAME;
    protected static final UTF8BytesString NOT_FOUND_RESOURCE_NAME;
    protected static final boolean SHOULD_SET_404_RESOURCE_NAME;
    private static final boolean SHOULD_SET_URL_RESOURCE_NAME;
    private static final BitSet SERVER_ERROR_STATUSES;
    private final boolean traceClientIpResolverEnabled = Config.get().isTraceClientIpResolverEnabled();

    protected abstract AgentPropagation.ContextVisitor<REQUEST_CARRIER> getter();

    protected abstract AgentPropagation.ContextVisitor<RESPONSE> responseGetter();

    public abstract CharSequence spanName();

    protected abstract String method(REQUEST var1);

    protected abstract URIDataAdapter url(REQUEST var1);

    protected abstract String peerHostIP(CONNECTION var1);

    protected abstract int peerPort(CONNECTION var1);

    protected abstract int status(RESPONSE var1);

    protected String requestedSessionId(REQUEST request) {
        return null;
    }

    public CharSequence operationName() {
        return SpanNaming.instance().namingSchema().server().operationForComponent(this.component().toString());
    }

    @Override
    protected CharSequence spanType() {
        return InternalSpanTypes.HTTP_SERVER;
    }

    @Override
    protected boolean traceAnalyticsDefault() {
        return Config.get().isTraceAnalyticsEnabled();
    }

    protected AgentTracer.TracerAPI tracer() {
        return AgentTracer.get();
    }

    public AgentSpanContext.Extracted extract(REQUEST_CARRIER carrier) {
        AgentPropagation.ContextVisitor<REQUEST_CARRIER> getter = this.getter();
        if (null == carrier || null == getter) {
            return null;
        }
        return AgentPropagation.extractContextAndGetSpanContext(carrier, getter);
    }

    public Context extractContext(REQUEST_CARRIER carrier) {
        AgentPropagation.ContextVisitor<REQUEST_CARRIER> getter = this.getter();
        if (null == carrier || null == getter) {
            return Context.root();
        }
        return Propagators.defaultPropagator().extract(Context.root(), carrier, getter);
    }

    @Deprecated
    public AgentSpan startSpan(REQUEST_CARRIER carrier, AgentSpanContext.Extracted context) {
        return this.startSpan("http-server", carrier, context);
    }

    public AgentSpan startSpan(String instrumentationName, REQUEST_CARRIER carrier, AgentSpanContext.Extracted context) {
        AgentSpan span = this.tracer().startSpan(instrumentationName, this.spanName(), this.callIGCallbackStart(context)).setMeasured(true);
        Flow<Void> flow = this.callIGCallbackRequestHeaders(span, carrier);
        if (flow.getAction() instanceof Flow.Action.RequestBlockingAction) {
            span.setRequestBlockingAction((Flow.Action.RequestBlockingAction)flow.getAction());
        }
        AgentPropagation.ContextVisitor<REQUEST_CARRIER> getter = this.getter();
        if (null != carrier && null != getter) {
            this.tracer().getDataStreamsMonitoring().setCheckpoint(span, DataStreamsContext.fromTags(SERVER_PATHWAY_EDGE_TAGS));
        }
        return span;
    }

    public AgentSpan startSpan(REQUEST_CARRIER carrier, Context context) {
        return this.startSpan("http-server", carrier, this.getExtractedSpanContext(context));
    }

    public AgentSpanContext.Extracted getExtractedSpanContext(Context context) {
        AgentSpan extractedSpan = AgentSpan.fromContext(context);
        return extractedSpan == null ? null : (AgentSpanContext.Extracted)extractedSpan.context();
    }

    public AgentSpan onRequest(AgentSpan span, CONNECTION connection, REQUEST request, Context context) {
        return this.onRequest(span, connection, request, this.getExtractedSpanContext(context));
    }

    public AgentSpan onRequest(AgentSpan span, CONNECTION connection, REQUEST request, AgentSpanContext.Extracted context) {
        AgentSpan localRootSpan;
        Object clientIp;
        boolean clientIpResolverEnabled;
        Config config = Config.get();
        boolean bl = clientIpResolverEnabled = config.isClientIpEnabled() || this.traceClientIpResolverEnabled && ActiveSubsystems.APPSEC_ACTIVE;
        if (ActiveSubsystems.APPSEC_ACTIVE) {
            Flow<Void> flow;
            Flow.Action action;
            BlockResponseFunction brf;
            RequestContext requestContext = span.getRequestContext();
            if (requestContext != null && (brf = this.createBlockResponseFunction(request, connection)) != null) {
                requestContext.setBlockResponseFunction(brf);
            }
            if ((action = (flow = this.callIGCallbackRequestSessionId(span, request)).getAction()) instanceof Flow.Action.RequestBlockingAction) {
                span.setRequestBlockingAction((Flow.Action.RequestBlockingAction)flow.getAction());
            }
        }
        if (context != null) {
            String userAgent;
            if (clientIpResolverEnabled) {
                String forwardedPort;
                String forwardedIp;
                String forwardedHost;
                String forwardedProto;
                String forwarded = context.getForwarded();
                if (forwarded != null) {
                    span.setTag("http.forwarded", forwarded);
                }
                if ((forwardedProto = context.getXForwardedProto()) != null) {
                    span.setTag("http.forwarded.proto", forwardedProto);
                }
                if ((forwardedHost = context.getXForwardedHost()) != null) {
                    span.setTag("http.forwarded.host", forwardedHost);
                }
                if ((forwardedIp = context.getXForwardedFor()) != null) {
                    span.setTag("http.forwarded.ip", forwardedIp);
                }
                if ((forwardedPort = context.getXForwardedPort()) != null) {
                    span.setTag("http.forwarded.port", forwardedPort);
                }
            }
            if ((userAgent = context.getUserAgent()) != null) {
                span.setTag("http.useragent", userAgent);
            }
        }
        if (request != null) {
            String method = this.method(request);
            span.setTag("http.method", method);
            try {
                URIDataAdapter url = this.url(request);
                if (url != null) {
                    Flow<Void> flow;
                    String path;
                    boolean supportsRaw = url.supportsRaw();
                    boolean encoded = supportsRaw && config.isHttpServerRawResource();
                    boolean valid = url.isValid();
                    String string = path = encoded ? url.rawPath() : url.path();
                    if (valid) {
                        span.setTag("http.url", URIUtils.lazyValidURL(url.scheme(), url.host(), url.port(), path));
                    } else if (supportsRaw) {
                        span.setTag("http.url", URIUtils.lazyInvalidUrl(url.raw()));
                    }
                    if (context != null && context.getXForwardedHost() != null) {
                        span.setTag("http.hostname", context.getXForwardedHost());
                    } else if (url.host() != null) {
                        span.setTag("http.hostname", url.host());
                    }
                    if (valid && config.isHttpServerTagQueryString()) {
                        String query = supportsRaw && config.isHttpServerRawQueryString() ? url.rawQuery() : url.query();
                        span.setTag("http.query.string", query);
                        span.setTag("http.fragment.string", url.fragment());
                    }
                    if ((flow = this.callIGCallbackURI(span, url, method)).getAction() instanceof Flow.Action.RequestBlockingAction) {
                        span.setRequestBlockingAction((Flow.Action.RequestBlockingAction)flow.getAction());
                    }
                    if (valid && SHOULD_SET_URL_RESOURCE_NAME) {
                        HttpResourceDecorator.HTTP_RESOURCE_DECORATOR.withServerPath(span, method, path, encoded);
                    }
                } else if (SHOULD_SET_URL_RESOURCE_NAME) {
                    span.setResourceName(DEFAULT_RESOURCE_NAME);
                }
            }
            catch (Exception e) {
                log.debug("Error tagging url", e);
            }
        }
        String peerIp = null;
        int peerPort = 0;
        if (connection != null) {
            peerIp = this.peerHostIP(connection);
            peerPort = this.peerPort(connection);
        }
        String inferredAddressStr = null;
        if (clientIpResolverEnabled && context != null) {
            InetAddress inferredAddress = ClientIpAddressResolver.resolve(context, span);
            if (peerIp != null) {
                InetAddress peerAddress;
                if (inferredAddress == null) {
                    inferredAddress = ClientIpAddressResolver.parseIpAddress(peerIp);
                } else if (ClientIpAddressResolver.isIpAddrPrivate(inferredAddress) && !ClientIpAddressResolver.isIpAddrPrivate(peerAddress = ClientIpAddressResolver.parseIpAddress(peerIp))) {
                    inferredAddress = peerAddress;
                }
            }
            if (inferredAddress != null) {
                inferredAddressStr = inferredAddress.getHostAddress();
                span.setTag("http.client_ip", inferredAddressStr);
            }
        } else if (clientIpResolverEnabled && span.getLocalRootSpan() != span && (clientIp = (localRootSpan = span.getLocalRootSpan()).getTag("http.client_ip")) != null) {
            span.setTag("http.client_ip", clientIp);
        }
        if (peerIp != null) {
            if (peerIp.indexOf(58) > 0) {
                span.setTag("peer.ipv6", peerIp);
            } else {
                span.setTag("peer.ipv4", peerIp);
            }
        }
        this.setPeerPort(span, peerPort);
        Flow<Void> flow = this.callIGCallbackAddressAndPort(span, peerIp, peerPort, inferredAddressStr);
        if (flow.getAction() instanceof Flow.Action.RequestBlockingAction) {
            span.setRequestBlockingAction((Flow.Action.RequestBlockingAction)flow.getAction());
        }
        return span;
    }

    protected BlockResponseFunction createBlockResponseFunction(REQUEST request, CONNECTION connection) {
        return null;
    }

    public AgentSpan onResponseStatus(AgentSpan span, int status) {
        if (status > 0) {
            span.setHttpStatusCode(status);
            if (!BlockingException.class.getName().equals(span.getTag("error.type"))) {
                span.setError(SERVER_ERROR_STATUSES.get(status), (byte)-1);
            }
        }
        if (SHOULD_SET_404_RESOURCE_NAME && status == 404) {
            span.setResourceName(NOT_FOUND_RESOURCE_NAME, (byte)2);
        }
        return span;
    }

    protected boolean isAppSecOnResponseSeparate() {
        return false;
    }

    public AgentSpan onResponse(AgentSpan span, RESPONSE response) {
        if (response != null) {
            ResponseHeaderTagClassifier tagger;
            int status = this.status(response);
            this.onResponseStatus(span, status);
            AgentPropagation.ContextVisitor<RESPONSE> getter = this.responseGetter();
            if (getter != null && (tagger = ResponseHeaderTagClassifier.create(span, AgentTracer.traceConfig(span).getResponseHeaderTags())) != null) {
                getter.forEachKey(response, tagger);
            }
            if (!this.isAppSecOnResponseSeparate()) {
                this.callIGCallbackResponseAndHeaders(span, response, status);
            }
        }
        return span;
    }

    private AgentSpanContext.Extracted callIGCallbackStart(AgentSpanContext.Extracted context) {
        AgentTracer.TracerAPI tracer = this.tracer();
        Supplier<Flow<Object>> startedCbAppSec = tracer.getCallbackProvider(RequestContextSlot.APPSEC).getCallback(Events.EVENTS.requestStarted());
        Supplier<Flow<Object>> startedCbIast = tracer.getCallbackProvider(RequestContextSlot.IAST).getCallback(Events.EVENTS.requestStarted());
        if (startedCbAppSec == null && startedCbIast == null) {
            return context;
        }
        TagContext tagContext = null;
        if (context == null) {
            tagContext = new TagContext();
        } else if (context instanceof TagContext) {
            tagContext = (TagContext)context;
        }
        if (tagContext != null) {
            if (startedCbAppSec != null) {
                tagContext.withRequestContextDataAppSec(startedCbAppSec.get().getResult());
            }
            if (startedCbIast != null) {
                tagContext.withRequestContextDataIast(startedCbIast.get().getResult());
            }
            return tagContext;
        }
        return context;
    }

    @Override
    public AgentSpan onError(AgentSpan span, Throwable throwable) {
        if (throwable != null) {
            span.addThrowable(throwable instanceof ExecutionException ? throwable.getCause() : throwable, (byte)-1);
        }
        return span;
    }

    private Flow<Void> callIGCallbackRequestHeaders(AgentSpan span, REQUEST_CARRIER carrier) {
        IGKeyClassifier igKeyClassifier;
        CallbackProvider cbp = this.tracer().getUniversalCallbackProvider();
        RequestContext requestContext = span.getRequestContext();
        AgentPropagation.ContextVisitor<REQUEST_CARRIER> getter = this.getter();
        if (requestContext == null || getter == null) {
            return Flow.ResultFlow.empty();
        }
        if (cbp != null && null != (igKeyClassifier = IGKeyClassifier.create(requestContext, cbp.getCallback(Events.EVENTS.requestHeader()), cbp.getCallback(Events.EVENTS.requestHeaderDone())))) {
            getter.forEachKey(carrier, igKeyClassifier);
            return igKeyClassifier.done();
        }
        return Flow.ResultFlow.empty();
    }

    private Flow<Void> callIGCallbackRequestSessionId(AgentSpan span, REQUEST request) {
        String sessionId = this.requestedSessionId(request);
        if (sessionId == null) {
            return Flow.ResultFlow.empty();
        }
        CallbackProvider cbp = this.tracer().getCallbackProvider(RequestContextSlot.APPSEC);
        RequestContext requestContext = span.getRequestContext();
        if (cbp == null || requestContext == null) {
            return Flow.ResultFlow.empty();
        }
        BiFunction<RequestContext, String, Flow<Void>> addrCallback = cbp.getCallback(Events.EVENTS.requestSession());
        if (addrCallback == null) {
            return Flow.ResultFlow.empty();
        }
        return addrCallback.apply(requestContext, sessionId);
    }

    private Flow<Void> callIGCallbackResponseAndHeaders(AgentSpan span, RESPONSE carrier, int status) {
        return this.callIGCallbackResponseAndHeaders(span, carrier, status, this.responseGetter());
    }

    public <RESP> Flow<Void> callIGCallbackResponseAndHeaders(AgentSpan span, RESP carrier, int status, AgentPropagation.ContextVisitor<RESP> contextVisitor) {
        CallbackProvider cbp = this.tracer().getCallbackProvider(RequestContextSlot.APPSEC);
        RequestContext requestContext = span.getRequestContext();
        if (cbp == null || requestContext == null) {
            return Flow.ResultFlow.empty();
        }
        BiFunction<RequestContext, Integer, Flow<Void>> addrCallback = cbp.getCallback(Events.EVENTS.responseStarted());
        if (null != addrCallback) {
            addrCallback.apply(requestContext, status);
        }
        if (contextVisitor == null) {
            return Flow.ResultFlow.empty();
        }
        IGKeyClassifier igKeyClassifier = IGKeyClassifier.create(requestContext, cbp.getCallback(Events.EVENTS.responseHeader()), cbp.getCallback(Events.EVENTS.responseHeaderDone()));
        if (null != igKeyClassifier) {
            contextVisitor.forEachKey(carrier, igKeyClassifier);
            return igKeyClassifier.done();
        }
        return Flow.ResultFlow.empty();
    }

    private Flow<Void> callIGCallbackURI(@Nonnull AgentSpan span, @Nonnull URIDataAdapter url, String method) {
        CallbackProvider cbp = this.tracer().getCallbackProvider(RequestContextSlot.APPSEC);
        RequestContext requestContext = span.getRequestContext();
        if (requestContext == null || cbp == null) {
            return Flow.ResultFlow.empty();
        }
        TriFunction<RequestContext, String, URIDataAdapter, Flow<Void>> callback = cbp.getCallback(Events.EVENTS.requestMethodUriRaw());
        if (callback != null) {
            return callback.apply(requestContext, method, url);
        }
        return Flow.ResultFlow.empty();
    }

    @Override
    public AgentSpan beforeFinish(AgentSpan span) {
        this.onRequestEndForInstrumentationGateway(span);
        return super.beforeFinish(span);
    }

    private void onRequestEndForInstrumentationGateway(@Nonnull AgentSpan span) {
        BiFunction<RequestContext, IGSpanInfo, Flow<Void>> callback;
        if (span.getLocalRootSpan() != span) {
            return;
        }
        CallbackProvider cbp = this.tracer().getUniversalCallbackProvider();
        RequestContext requestContext = span.getRequestContext();
        if (cbp != null && requestContext != null && (callback = cbp.getCallback(Events.EVENTS.requestEnded())) != null) {
            callback.apply(requestContext, span);
        }
    }

    private Flow<Void> callIGCallbackAddressAndPort(@Nonnull AgentSpan span, String ip, int port, String inferredClientIp) {
        TriFunction<RequestContext, String, Integer, Flow<Void>> addrCallback;
        BiFunction<RequestContext, String, Flow<Void>> inferredAddrCallback;
        CallbackProvider cbp = this.tracer().getCallbackProvider(RequestContextSlot.APPSEC);
        if (cbp == null || ip == null && inferredClientIp == null && port == 0) {
            return Flow.ResultFlow.empty();
        }
        RequestContext ctx = span.getRequestContext();
        if (ctx == null) {
            return Flow.ResultFlow.empty();
        }
        if (inferredClientIp != null && (inferredAddrCallback = cbp.getCallback(Events.EVENTS.requestInferredClientAddress())) != null) {
            inferredAddrCallback.apply(ctx, inferredClientIp);
        }
        if ((ip != null || port != 0) && (addrCallback = cbp.getCallback(Events.EVENTS.requestClientSocketAddress())) != null) {
            return addrCallback.apply(ctx, ip != null ? ip : "0.0.0.0", port);
        }
        return Flow.ResultFlow.empty();
    }

    static {
        SERVER_PATHWAY_EDGE_TAGS.put("direction", "in");
        SERVER_PATHWAY_EDGE_TAGS.put("type", "http");
        DEFAULT_RESOURCE_NAME = UTF8BytesString.create("/");
        NOT_FOUND_RESOURCE_NAME = UTF8BytesString.create("404");
        SHOULD_SET_404_RESOURCE_NAME = Config.get().isRuleEnabled("URLAsResourceNameRule") && Config.get().isRuleEnabled("Status404Rule") && Config.get().isRuleEnabled("Status404Decorator");
        SHOULD_SET_URL_RESOURCE_NAME = Config.get().isRuleEnabled("URLAsResourceNameRule");
        SERVER_ERROR_STATUSES = Config.get().getHttpServerErrorStatuses();
    }

    private static final class ResponseHeaderTagClassifier
    implements AgentPropagation.KeyClassifier {
        private final AgentSpan span;
        private final Map<String, String> headerTags;

        static ResponseHeaderTagClassifier create(AgentSpan span, Map<String, String> headerTags) {
            if (span == null || headerTags == null || headerTags.isEmpty()) {
                return null;
            }
            return new ResponseHeaderTagClassifier(span, headerTags);
        }

        public ResponseHeaderTagClassifier(AgentSpan span, Map<String, String> headerTags) {
            this.span = span;
            this.headerTags = headerTags;
        }

        @Override
        public boolean accept(String key, String value) {
            String mappedKey = this.headerTags.get(key.toLowerCase(Locale.ROOT));
            if (mappedKey != null) {
                this.span.setTag(mappedKey, value);
            }
            return true;
        }
    }

    protected static final class IGKeyClassifier
    implements AgentPropagation.KeyClassifier {
        private final RequestContext requestContext;
        private final TriConsumer<RequestContext, String, String> headerCallback;
        private final Function<RequestContext, Flow<Void>> doneCallback;

        public static IGKeyClassifier create(RequestContext requestContext, TriConsumer<RequestContext, String, String> headerCallback, Function<RequestContext, Flow<Void>> doneCallback) {
            if (null == requestContext || null == headerCallback) {
                return null;
            }
            return new IGKeyClassifier(requestContext, headerCallback, doneCallback);
        }

        private IGKeyClassifier(RequestContext requestContext, TriConsumer<RequestContext, String, String> headerCallback, Function<RequestContext, Flow<Void>> doneCallback) {
            this.requestContext = requestContext;
            this.headerCallback = headerCallback;
            this.doneCallback = doneCallback;
        }

        @Override
        public boolean accept(String key, String value) {
            this.headerCallback.accept(this.requestContext, key, value);
            return true;
        }

        public Flow<Void> done() {
            if (null != this.doneCallback) {
                return this.doneCallback.apply(this.requestContext);
            }
            return Flow.ResultFlow.empty();
        }
    }
}

