/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.ConfigDefaults;
import datadog.trace.api.Platform;
import datadog.trace.api.ProductActivation;
import datadog.trace.api.ResolverCacheConfig;
import datadog.trace.bootstrap.config.provider.ConfigProvider;
import datadog.trace.bootstrap.config.provider.SystemPropertiesConfigSource;
import datadog.trace.util.CollectionUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class InstrumenterConfig {
    private final ConfigProvider configProvider;
    private final boolean integrationsEnabled;
    private final boolean traceEnabled;
    private final boolean logsInjectionEnabled;
    private final boolean logsMDCTagsInjectionEnabled;
    private final boolean profilingEnabled;
    private final boolean ciVisibilityEnabled;
    private final ProductActivation appSecActivation;
    private final boolean iastEnabled;
    private final boolean telemetryEnabled;
    private final boolean traceExecutorsAll;
    private final List<String> traceExecutors;
    private final Set<String> traceThreadPoolExecutorsExclude;
    private final String jdbcPreparedStatementClassName;
    private final String jdbcConnectionClassName;
    private final boolean directAllocationProfilingEnabled;
    private final List<String> excludedClasses;
    private final String excludedClassesFile;
    private final Set<String> excludedClassLoaders;
    private final List<String> excludedCodeSources;
    private final ResolverCacheConfig resolverCacheConfig;
    private final boolean resolverUseLoadClassEnabled;
    private final int resolverResetInterval;
    private final boolean runtimeContextFieldInjection;
    private final boolean serialVersionUIDFieldInjection;
    private final String traceAnnotations;
    private final String traceMethods;
    private final boolean internalExitOnFailure;
    private final boolean legacyInstallerEnabled;
    @SuppressFBWarnings(value={"SI_INSTANCE_BEFORE_FINALS_ASSIGNED"})
    private static final InstrumenterConfig INSTANCE = new InstrumenterConfig(Platform.isNativeImageBuilder() ? ConfigProvider.withoutCollector() : ConfigProvider.getInstance());

    private InstrumenterConfig() {
        this(ConfigProvider.createDefault());
    }

    InstrumenterConfig(ConfigProvider configProvider) {
        this.configProvider = configProvider;
        this.integrationsEnabled = configProvider.getBoolean("integrations.enabled", true, new String[0]);
        this.traceEnabled = configProvider.getBoolean("trace.enabled", true, new String[0]);
        this.logsInjectionEnabled = configProvider.getBoolean("logs.injection", true, new String[0]);
        this.logsMDCTagsInjectionEnabled = configProvider.getBoolean("logs.mdc.tags.injection", true, new String[0]);
        if (!Platform.isNativeImageBuilder()) {
            this.profilingEnabled = configProvider.getBoolean("profiling.enabled", false, new String[0]);
            this.ciVisibilityEnabled = configProvider.getBoolean("civisibility.enabled", false, new String[0]);
            String appSecEnabled = configProvider.getString("appsec.enabled");
            if ((appSecEnabled == null || appSecEnabled.isEmpty()) && (appSecEnabled = configProvider.getStringExcludingSource("appsec.enabled", "inactive", SystemPropertiesConfigSource.class, new String[0])).isEmpty()) {
                appSecEnabled = "inactive";
            }
            this.appSecActivation = ProductActivation.fromString(appSecEnabled);
            this.iastEnabled = configProvider.getBoolean("iast.enabled", false, new String[0]);
            this.telemetryEnabled = configProvider.getBoolean("instrumentation.telemetry.enabled", true, new String[0]);
        } else {
            this.profilingEnabled = false;
            this.ciVisibilityEnabled = false;
            this.appSecActivation = ProductActivation.FULLY_DISABLED;
            this.iastEnabled = false;
            this.telemetryEnabled = false;
        }
        this.traceExecutorsAll = configProvider.getBoolean("trace.executors.all", false, new String[0]);
        this.traceExecutors = CollectionUtils.tryMakeImmutableList(configProvider.getList("trace.executors"));
        this.traceThreadPoolExecutorsExclude = CollectionUtils.tryMakeImmutableSet(configProvider.getList("trace.thread-pool-executors.exclude"));
        this.jdbcPreparedStatementClassName = configProvider.getString("trace.jdbc.prepared.statement.class.name", "", new String[0]);
        this.jdbcConnectionClassName = configProvider.getString("trace.jdbc.connection.class.name", "", new String[0]);
        this.directAllocationProfilingEnabled = configProvider.getBoolean("profiling.directallocation.enabled", false, new String[0]);
        this.excludedClasses = CollectionUtils.tryMakeImmutableList(configProvider.getList("trace.classes.exclude"));
        this.excludedClassesFile = configProvider.getString("trace.classes.exclude.file");
        this.excludedClassLoaders = CollectionUtils.tryMakeImmutableSet(configProvider.getList("trace.classloaders.exclude"));
        this.excludedCodeSources = CollectionUtils.tryMakeImmutableList(configProvider.getList("trace.codesources.exclude"));
        this.resolverCacheConfig = configProvider.getEnum("resolver.cache.config", ResolverCacheConfig.class, ResolverCacheConfig.DEFAULT);
        this.resolverUseLoadClassEnabled = configProvider.getBoolean("resolver.use.loadclass", true, new String[0]);
        this.resolverResetInterval = Platform.isNativeImageBuilder() ? 0 : configProvider.getInteger("resolver.reset.interval", 300, new String[0]);
        this.runtimeContextFieldInjection = configProvider.getBoolean("trace.runtime.context.field.injection", true, new String[0]);
        this.serialVersionUIDFieldInjection = configProvider.getBoolean("trace.serialversionuid.field.injection", true, new String[0]);
        this.traceAnnotations = configProvider.getString("trace.annotations", ConfigDefaults.DEFAULT_TRACE_ANNOTATIONS, new String[0]);
        this.traceMethods = configProvider.getString("trace.methods", ConfigDefaults.DEFAULT_TRACE_METHODS, new String[0]);
        this.internalExitOnFailure = configProvider.getBoolean("trace.internal.exit.on.failure", false, new String[0]);
        this.legacyInstallerEnabled = configProvider.getBoolean("legacy.installer.enabled", false, new String[0]);
    }

    public boolean isIntegrationsEnabled() {
        return this.integrationsEnabled;
    }

    public boolean isIntegrationEnabled(Iterable<String> integrationNames, boolean defaultEnabled) {
        return this.configProvider.isEnabled(integrationNames, "integration.", ".enabled", defaultEnabled);
    }

    public boolean isIntegrationShortcutMatchingEnabled(Iterable<String> integrationNames, boolean defaultEnabled) {
        return this.configProvider.isEnabled(integrationNames, "integration.", ".matching.shortcut.enabled", defaultEnabled);
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public boolean isLogsInjectionEnabled() {
        return this.logsInjectionEnabled;
    }

    public boolean isLogsMDCTagsInjectionEnabled() {
        return this.logsMDCTagsInjectionEnabled && !Platform.isNativeImageBuilder();
    }

    public boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    public boolean isCiVisibilityEnabled() {
        return this.ciVisibilityEnabled;
    }

    public ProductActivation getAppSecActivation() {
        return this.appSecActivation;
    }

    public boolean isIastEnabled() {
        return this.iastEnabled;
    }

    public boolean isTelemetryEnabled() {
        return this.telemetryEnabled;
    }

    public boolean isTraceExecutorsAll() {
        return this.traceExecutorsAll;
    }

    public List<String> getTraceExecutors() {
        return this.traceExecutors;
    }

    public Set<String> getTraceThreadPoolExecutorsExclude() {
        return this.traceThreadPoolExecutorsExclude;
    }

    public String getJdbcPreparedStatementClassName() {
        return this.jdbcPreparedStatementClassName;
    }

    public String getJdbcConnectionClassName() {
        return this.jdbcConnectionClassName;
    }

    public boolean isDirectAllocationProfilingEnabled() {
        return this.directAllocationProfilingEnabled;
    }

    public List<String> getExcludedClasses() {
        return this.excludedClasses;
    }

    public String getExcludedClassesFile() {
        return this.excludedClassesFile;
    }

    public Set<String> getExcludedClassLoaders() {
        return this.excludedClassLoaders;
    }

    public List<String> getExcludedCodeSources() {
        return this.excludedCodeSources;
    }

    public boolean isResolverOutliningEnabled() {
        return this.resolverCacheConfig.outlinePoolSize() > 0;
    }

    public int getResolverOutlinePoolSize() {
        return this.resolverCacheConfig.outlinePoolSize();
    }

    public int getResolverTypePoolSize() {
        return this.resolverCacheConfig.typePoolSize();
    }

    public boolean isResolverUseLoadClassEnabled() {
        return this.resolverUseLoadClassEnabled;
    }

    public int getResolverResetInterval() {
        return this.resolverResetInterval;
    }

    public boolean isRuntimeContextFieldInjection() {
        return this.runtimeContextFieldInjection;
    }

    public boolean isSerialVersionUIDFieldInjection() {
        return this.serialVersionUIDFieldInjection;
    }

    public String getTraceAnnotations() {
        return this.traceAnnotations;
    }

    public String getTraceMethods() {
        return this.traceMethods;
    }

    public boolean isInternalExitOnFailure() {
        return this.internalExitOnFailure;
    }

    public boolean isLegacyInstallerEnabled() {
        return this.legacyInstallerEnabled;
    }

    public boolean isLegacyInstrumentationEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.configProvider.isEnabled(Arrays.asList(integrationNames), "", ".legacy.tracing.enabled", defaultEnabled);
    }

    public static InstrumenterConfig get() {
        return INSTANCE;
    }

    public String toString() {
        return "InstrumenterConfig{integrationsEnabled=" + this.integrationsEnabled + ", traceEnabled=" + this.traceEnabled + ", logsInjectionEnabled=" + this.logsInjectionEnabled + ", logsMDCTagsInjectionEnabled=" + this.logsMDCTagsInjectionEnabled + ", profilingEnabled=" + this.profilingEnabled + ", ciVisibilityEnabled=" + this.ciVisibilityEnabled + ", appSecActivation=" + (Object)((Object)this.appSecActivation) + ", iastEnabled=" + this.iastEnabled + ", telemetryEnabled=" + this.telemetryEnabled + ", traceExecutorsAll=" + this.traceExecutorsAll + ", traceExecutors=" + this.traceExecutors + ", jdbcPreparedStatementClassName='" + this.jdbcPreparedStatementClassName + '\'' + ", jdbcConnectionClassName='" + this.jdbcConnectionClassName + '\'' + ", excludedClasses=" + this.excludedClasses + ", excludedClassesFile=" + this.excludedClassesFile + ", excludedClassLoaders=" + this.excludedClassLoaders + ", excludedCodeSources=" + this.excludedCodeSources + ", resolverCacheConfig=" + (Object)((Object)this.resolverCacheConfig) + ", resolverUseLoadClassEnabled=" + this.resolverUseLoadClassEnabled + ", resolverResetInterval=" + this.resolverResetInterval + ", runtimeContextFieldInjection=" + this.runtimeContextFieldInjection + ", serialVersionUIDFieldInjection=" + this.serialVersionUIDFieldInjection + ", traceAnnotations='" + this.traceAnnotations + '\'' + ", traceMethods='" + this.traceMethods + '\'' + ", internalExitOnFailure=" + this.internalExitOnFailure + ", legacyInstallerEnabled=" + this.legacyInstallerEnabled + '}';
    }
}

