/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.cache;

import datadog.trace.api.Pair;
import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDPartialKeyCache;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.annotation.Nullable;

abstract class FixedSizeCache<E, K, V, H, C, P> {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    protected final int mask;
    protected final E[] elements;

    FixedSizeCache(int capacity, IntFunction<E[]> initializer) {
        int n;
        if (capacity <= 0) {
            throw new IllegalArgumentException("Cache capacity must be > 0");
        }
        if (capacity > 0x40000000) {
            capacity = 0x40000000;
        }
        n = (n = -1 >>> Integer.numberOfLeadingZeros(capacity - 1)) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
        this.elements = initializer.apply(n);
        this.mask = n - 1;
    }

    protected final V internalComputeIfAbsent(K key, int m, int n, H hasher, C comparator, P producer) {
        V value;
        int hash;
        if (key == null) {
            return null;
        }
        int h = hash = this.hash(hasher, key, m, n);
        int firstPos = h & this.mask;
        int i = 1;
        while (true) {
            int pos;
            E current;
            if ((current = this.elements[pos = h & this.mask]) == null) {
                value = this.produceAndStoreValue(producer, hash, key, m, n, pos);
                break;
            }
            if (this.equals(comparator, hash, key, m, n, current)) {
                value = this.getValue(current);
                break;
            }
            if (i == 3) {
                value = this.produceAndStoreValue(producer, hash, key, m, n, firstPos);
                break;
            }
            h = FixedSizeCache.rehash(h);
            ++i;
        }
        return value;
    }

    public void clear() {
        Arrays.fill(this.elements, null);
    }

    protected abstract int hash(H var1, K var2, int var3, int var4);

    protected abstract boolean equals(C var1, int var2, K var3, int var4, int var5, E var6);

    protected abstract V produceValue(P var1, K var2, int var3, int var4);

    protected abstract E toElement(int var1, K var2, V var3);

    protected abstract V getValue(E var1);

    private V produceAndStoreValue(P producer, int hash, K key, int m, int n, int pos) {
        V value = this.produceValue(producer, key, m, n);
        this.elements[pos] = this.toElement(hash, key, value);
        return value;
    }

    private static int rehash(int v) {
        int h = v * -1640532531;
        h = Integer.reverseBytes(h);
        return h * -1640532531;
    }

    static final class HVElement<U> {
        final int hash;
        final U value;

        static <U> HVElement<U> of(int hash, U value) {
            return new HVElement<U>(hash, value);
        }

        HVElement(int hash, @Nullable U value) {
            this.hash = hash;
            this.value = value;
        }
    }

    static final class FixedSizePartialKeyCache<K, V>
    extends FixedSizeCache<HVElement<V>, K, V, DDPartialKeyCache.Hasher<K>, DDPartialKeyCache.Comparator<K, V>, DDPartialKeyCache.Producer<K, ? extends V>>
    implements DDPartialKeyCache<K, V> {
        public FixedSizePartialKeyCache(int capacity) {
            super(capacity, n -> {
                HVElement[] elements = new HVElement[n];
                return elements;
            });
        }

        @Override
        public V computeIfAbsent(K key, int m, int n, DDPartialKeyCache.Hasher<K> hasher, DDPartialKeyCache.Comparator<K, V> comparator, DDPartialKeyCache.Producer<K, ? extends V> producer) {
            return this.internalComputeIfAbsent(key, m, n, hasher, comparator, producer);
        }

        @Override
        protected int hash(DDPartialKeyCache.Hasher<K> hasher, K key, int m, int n) {
            return hasher.apply(key, m, n);
        }

        @Override
        protected boolean equals(DDPartialKeyCache.Comparator<K, V> comparator, int hash, K key, int m, int n, HVElement<V> current) {
            return hash == current.hash && comparator.test(key, m, n, current.value);
        }

        @Override
        protected V produceValue(DDPartialKeyCache.Producer<K, ? extends V> producer, K key, int m, int n) {
            return producer.apply(key, m, n);
        }

        @Override
        protected HVElement<V> toElement(int hash, K key, V value) {
            return HVElement.of(hash, value);
        }

        @Override
        protected V getValue(HVElement<V> element) {
            return (V)element.value;
        }
    }

    static final class ArrayHash<K, V>
    extends FixedSizeKeyValueCache<K[], V> {
        ArrayHash(int capacity) {
            super(capacity);
        }

        @Override
        int hash(K[] key) {
            return Arrays.hashCode(key);
        }

        @Override
        boolean equals(K[] key, Pair<K[], V> current) {
            return Arrays.equals(key, current.getLeft());
        }
    }

    static final class IdentityHash<K, V>
    extends FixedSizeKeyValueCache<K, V> {
        IdentityHash(int capacity) {
            super(capacity);
        }

        @Override
        int hash(K key) {
            return System.identityHashCode(key);
        }

        @Override
        boolean equals(K key, Pair<K, V> current) {
            return key == current.getLeft();
        }
    }

    static final class ObjectHash<K, V>
    extends FixedSizeKeyValueCache<K, V> {
        ObjectHash(int capacity) {
            super(capacity);
        }

        @Override
        int hash(K key) {
            return key.hashCode();
        }

        @Override
        boolean equals(K key, Pair<K, V> current) {
            return key.equals(current.getLeft());
        }
    }

    static abstract class FixedSizeKeyValueCache<K, V>
    extends FixedSizeCache<Pair<K, V>, K, V, Void, Void, Function<K, ? extends V>>
    implements DDCache<K, V> {
        public FixedSizeKeyValueCache(int capacity) {
            super(capacity, n -> {
                Pair[] elements = new Pair[n];
                return elements;
            });
        }

        @Override
        public final V computeIfAbsent(K key, Function<K, ? extends V> producer) {
            return this.internalComputeIfAbsent(key, 0, 0, null, null, producer);
        }

        @Override
        protected final int hash(Void unused, K key, int m, int n) {
            return this.hash(key);
        }

        @Override
        protected final boolean equals(Void unused, int hash, K key, int m, int n, Pair<K, V> current) {
            return this.equals(key, current);
        }

        @Override
        protected final V produceValue(Function<K, ? extends V> producer, K key, int m, int n) {
            return producer.apply(key);
        }

        @Override
        protected final Pair<K, V> toElement(int hash, K key, V value) {
            return Pair.of(key, value);
        }

        @Override
        protected final V getValue(Pair<K, V> element) {
            return element.getRight();
        }

        abstract int hash(K var1);

        abstract boolean equals(K var1, Pair<K, V> var2);
    }
}

