/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import java.util.function.Function;

public interface WeakCache<K, V> {
    public V getIfPresent(K var1);

    public V computeIfAbsent(K var1, Function<? super K, ? extends V> var2);

    public void put(K var1, V var2);

    public void clear();

    public static abstract class Supplier {
        private static volatile Supplier SUPPLIER;

        protected abstract <K, V> WeakCache<K, V> get(long var1);

        public static <K, V> WeakCache<K, V> newWeakCache(long maxSize) {
            return SUPPLIER.get(maxSize);
        }

        public static synchronized void registerIfAbsent(Supplier supplier) {
            if (null == SUPPLIER) {
                SUPPLIER = supplier;
            }
        }
    }
}

