/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.debugger;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.debugger.DebuggerSpan;
import datadog.trace.bootstrap.debugger.DiagnosticMessage;
import datadog.trace.bootstrap.debugger.Snapshot;
import java.util.List;

public class DebuggerContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebuggerContext.class);
    private static volatile Sink sink;
    private static volatile ProbeResolver probeResolver;
    private static volatile ClassFilter classFilter;
    private static volatile MetricForwarder metricForwarder;
    private static volatile Tracer tracer;
    private static volatile SnapshotSerializer snapshotSerializer;

    public static void init(Sink sink, ProbeResolver probeResolver, MetricForwarder metricForwarder) {
        DebuggerContext.sink = sink;
        DebuggerContext.probeResolver = probeResolver;
        DebuggerContext.metricForwarder = metricForwarder;
    }

    public static void initTracer(Tracer tracer) {
        DebuggerContext.tracer = tracer;
    }

    public static void initClassFilter(ClassFilter classFilter) {
        DebuggerContext.classFilter = classFilter;
    }

    public static void initSnapshotSerializer(SnapshotSerializer snapshotSerializer) {
        DebuggerContext.snapshotSerializer = snapshotSerializer;
    }

    public static void skipSnapshot(String probeId, SkipCause cause) {
        Sink localSink = sink;
        if (localSink == null) {
            return;
        }
        localSink.skipSnapshot(probeId, cause);
    }

    public static void addSnapshot(Snapshot snapshot) {
        Sink localSink = sink;
        if (localSink == null) {
            return;
        }
        localSink.addSnapshot(snapshot);
    }

    public static void reportDiagnostics(String probeId, List<DiagnosticMessage> messages) {
        Sink localSink = sink;
        if (localSink == null) {
            return;
        }
        localSink.addDiagnostics(probeId, messages);
    }

    public static Snapshot.ProbeDetails resolveProbe(String id, Class<?> callingClass) {
        ProbeResolver resolver = probeResolver;
        if (resolver == null) {
            return null;
        }
        return resolver.resolve(id, callingClass);
    }

    public static boolean isDenied(String fullyQualifiedClassName) {
        ClassFilter filter = classFilter;
        if (filter == null) {
            LOGGER.warn("no class filter => all classes are denied");
            return true;
        }
        return filter.isDenied(fullyQualifiedClassName);
    }

    public static void count(String name, long delta, String[] tags) {
        MetricForwarder forwarder = metricForwarder;
        if (forwarder == null) {
            return;
        }
        forwarder.count(name, delta, tags);
    }

    public static void gauge(String name, long value, String[] tags) {
        MetricForwarder forwarder = metricForwarder;
        if (forwarder == null) {
            return;
        }
        forwarder.gauge(name, value, tags);
    }

    public static void histogram(String name, long value, String[] tags) {
        MetricForwarder forwarder = metricForwarder;
        if (forwarder == null) {
            return;
        }
        forwarder.histogram(name, value, tags);
    }

    public static String serializeSnapshot(String serviceName, Snapshot snapshot) {
        SnapshotSerializer serializer = snapshotSerializer;
        if (serializer == null) {
            LOGGER.warn("Cannot serialize snapshots, no serializer set");
            return null;
        }
        return serializer.serializeSnapshot(serviceName, snapshot);
    }

    public static String serializeValue(Snapshot.CapturedValue value) {
        SnapshotSerializer serializer = snapshotSerializer;
        if (serializer == null) {
            LOGGER.warn("Cannot serialize value, no serializer set");
            return null;
        }
        return serializer.serializeValue(value);
    }

    public static DebuggerSpan createSpan(String operationName, String[] tags) {
        Tracer localTracer = tracer;
        if (localTracer == null) {
            return null;
        }
        return localTracer.createSpan(operationName, tags);
    }

    public static interface SnapshotSerializer {
        public String serializeSnapshot(String var1, Snapshot var2);

        public String serializeValue(Snapshot.CapturedValue var1);
    }

    public static interface Tracer {
        public DebuggerSpan createSpan(String var1, String[] var2);
    }

    public static interface MetricForwarder {
        public void count(String var1, long var2, String[] var4);

        public void gauge(String var1, long var2, String[] var4);

        public void histogram(String var1, long var2, String[] var4);
    }

    public static interface ClassFilter {
        public boolean isDenied(String var1);
    }

    public static interface ProbeResolver {
        public Snapshot.ProbeDetails resolve(String var1, Class<?> var2);
    }

    public static interface Sink {
        public void addSnapshot(Snapshot var1);

        public void addDiagnostics(String var1, List<DiagnosticMessage> var2);

        default public void skipSnapshot(String probeId, SkipCause cause) {
        }
    }

    public static enum SkipCause {
        RATE,
        CONDITION;

    }
}

