/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.debugger;

import java.time.Instant;
import java.util.Objects;

public final class DiagnosticMessage {
    private final long timestamp;
    private final Kind kind;
    private final String message;
    private final Throwable throwable;

    public DiagnosticMessage(Kind kind, String message) {
        this(Instant.now().toEpochMilli(), kind, message, null);
    }

    public DiagnosticMessage(Kind kind, Throwable throwable) {
        this(Instant.now().toEpochMilli(), kind, null, throwable);
    }

    public DiagnosticMessage(long timestamp, Kind kind, String message, Throwable throwable) {
        this.timestamp = timestamp;
        this.kind = kind;
        this.message = message;
        this.throwable = throwable;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getMessage() {
        return this.message;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        return "DiagnosticMessage{timestamp=" + this.timestamp + ", kind=" + (Object)((Object)this.kind) + ", message='" + this.message + ", throwable='" + this.throwable + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagnosticMessage that = (DiagnosticMessage)o;
        return this.timestamp == that.timestamp && this.kind == that.kind && this.throwable == that.throwable && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.kind, this.message, this.throwable});
    }

    public static enum Kind {
        INFO,
        WARN,
        ERROR;

    }
}

