/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.debugger;

import datadog.trace.bootstrap.debugger.Limits;
import java.lang.reflect.Field;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class Fields {
    public static void processFields(Object o, Predicate<Field> filteringIn, ProcessField processing, BiConsumer<Exception, Field> exHandling, Consumer<Field> onMaxFieldCount, Limits limits) {
        Class<?> currentClass = o.getClass();
        int processedFieldCount = 0;
        do {
            Field[] fields;
            for (Field field : fields = currentClass.getDeclaredFields()) {
                try {
                    if (!filteringIn.test(field)) continue;
                    field.setAccessible(true);
                    Object value = field.get(o);
                    processing.accept(field, value, limits);
                    if (++processedFieldCount < limits.maxFieldCount) continue;
                    onMaxFieldCount.accept(field);
                    return;
                }
                catch (Exception e) {
                    exHandling.accept(e, field);
                }
            }
        } while ((currentClass = currentClass.getSuperclass()) != null);
    }

    static boolean isPrimitiveClass(Object obj) {
        Class<?> clazz = obj.getClass();
        if (clazz == Byte.class) {
            return true;
        }
        if (clazz == Short.class) {
            return true;
        }
        if (clazz == Integer.class) {
            return true;
        }
        if (clazz == Character.class) {
            return true;
        }
        if (clazz == Long.class) {
            return true;
        }
        if (clazz == Float.class) {
            return true;
        }
        if (clazz == Double.class) {
            return true;
        }
        if (clazz == Boolean.class) {
            return true;
        }
        return clazz == String.class;
    }

    public static interface ProcessField {
        public void accept(Field var1, Object var2, Limits var3);
    }
}

