/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.debugger;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.debugger.CapturedStackFrame;
import datadog.trace.bootstrap.debugger.DebuggerContext;
import datadog.trace.bootstrap.debugger.Limits;
import datadog.trace.bootstrap.debugger.ProbeRateLimiter;
import datadog.trace.bootstrap.debugger.SnapshotSummaryBuilder;
import datadog.trace.bootstrap.debugger.SummaryBuilder;
import datadog.trace.bootstrap.debugger.el.DebuggerScript;
import datadog.trace.bootstrap.debugger.el.ReflectiveFieldValueResolver;
import datadog.trace.bootstrap.debugger.el.ValueReferenceResolver;
import datadog.trace.bootstrap.debugger.el.ValueReferences;
import datadog.trace.bootstrap.debugger.el.Values;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;

public class Snapshot {
    private static final Logger LOG = LoggerFactory.getLogger(Snapshot.class);
    private static final String LANGUAGE = "java";
    private static final int VERSION = 2;
    private String id;
    private final transient long startTs;
    private final transient int version;
    private final long timestamp;
    private transient long duration;
    private final List<CapturedStackFrame> stack = new ArrayList<CapturedStackFrame>();
    private final Captures captures;
    private final ProbeDetails probe;
    private final String language;
    private final transient CapturedThread thread;
    private final transient Map<String, SnapshotStatus> snapshotStatuses = new LinkedHashMap<String, SnapshotStatus>();
    private final transient Map<String, List<EvaluationError>> errorsByProbeIds = new HashMap<String, List<EvaluationError>>();
    private final transient String thisClassName;
    private String traceId;
    private String spanId;
    private List<EvaluationError> evaluationErrors;
    private final transient SummaryBuilder summaryBuilder;
    private transient boolean capturing = true;

    public Snapshot(Thread thread, ProbeDetails probeDetails, String thisClassName) {
        this.startTs = System.nanoTime();
        this.version = 2;
        this.timestamp = System.currentTimeMillis();
        this.captures = new Captures();
        this.language = LANGUAGE;
        this.thread = new CapturedThread(thread);
        this.probe = probeDetails;
        this.thisClassName = thisClassName;
        this.summaryBuilder = probeDetails.summaryBuilder;
        this.addSnapshotStatus(probeDetails);
    }

    public Snapshot(String id, int version, long timestamp, long duration, List<CapturedStackFrame> stack, Captures captures, ProbeDetails probeDetails, String language, CapturedThread thread, String thisClassName, String traceId, String spanId) {
        this.startTs = System.nanoTime();
        this.id = id;
        this.version = version;
        this.timestamp = timestamp;
        this.duration = duration;
        this.stack.addAll(stack);
        this.captures = captures;
        this.probe = probeDetails;
        this.language = language;
        this.thread = thread;
        this.traceId = traceId;
        this.spanId = spanId;
        this.thisClassName = thisClassName;
        this.summaryBuilder = probeDetails.summaryBuilder;
        this.addSnapshotStatus(this.probe);
    }

    private void addSnapshotStatus(ProbeDetails probe) {
        if (probe == null) {
            return;
        }
        this.snapshotStatuses.put(probe.id, new SnapshotStatus(probe.captureSnapshot, true, probe));
        for (ProbeDetails additionalProbe : probe.additionalProbes) {
            this.snapshotStatuses.put(additionalProbe.id, new SnapshotStatus(additionalProbe.captureSnapshot, true, additionalProbe));
        }
    }

    public void setEntry(CapturedContext context) {
        this.processSummaries(SummaryBuilder::addEntry, context);
        context.setThisClassName(this.thisClassName);
        if (this.checkCapture(context, MethodLocation.ENTRY)) {
            this.captures.setEntry(context);
        }
    }

    public void setExit(CapturedContext context) {
        this.duration = System.nanoTime() - this.startTs;
        context.addExtension(ValueReferences.DURATION_EXTENSION_NAME, this.duration);
        this.processSummaries(SummaryBuilder::addExit, context);
        context.setThisClassName(this.thisClassName);
        if (this.checkCapture(context, MethodLocation.EXIT)) {
            this.captures.setReturn(context);
        }
    }

    public void addLine(CapturedContext context, int line) {
        this.processSummaries(SummaryBuilder::addLine, context);
        context.setThisClassName(this.thisClassName);
        if (this.checkCapture(context, MethodLocation.DEFAULT)) {
            this.captures.addLine(line, context);
        }
    }

    public void addCaughtException(CapturedContext context) {
        this.captures.addCaughtException(context.throwable);
    }

    public String getId() {
        return this.id;
    }

    public int retrieveVersion() {
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long retrieveDuration() {
        return this.duration;
    }

    public List<CapturedStackFrame> getStack() {
        return this.stack;
    }

    public Captures getCaptures() {
        return this.captures;
    }

    public ProbeDetails getProbe() {
        return this.probe;
    }

    public String getLanguage() {
        return this.language;
    }

    public CapturedThread retrieveThread() {
        return this.thread;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public List<EvaluationError> getEvaluationErrors() {
        return this.evaluationErrors;
    }

    public String buildSummary() {
        String summary = this.summaryBuilder.build();
        List<EvaluationError> errors = this.summaryBuilder.getEvaluationErrors();
        if (!errors.isEmpty()) {
            if (this.evaluationErrors == null) {
                this.evaluationErrors = new ArrayList<EvaluationError>();
            }
            this.evaluationErrors.addAll(errors);
        }
        return summary;
    }

    public void commit() {
        for (Map.Entry<String, SnapshotStatus> entry : this.snapshotStatuses.entrySet()) {
            String currentProbeId = entry.getKey();
            SnapshotStatus status = entry.getValue();
            if (!status.sending) {
                DebuggerContext.skipSnapshot(currentProbeId, DebuggerContext.SkipCause.CONDITION);
                continue;
            }
            if (status.probeDetails.getScript() != null && !ProbeRateLimiter.tryProbe(currentProbeId)) {
                DebuggerContext.skipSnapshot(currentProbeId, DebuggerContext.SkipCause.RATE);
                continue;
            }
            this.recordStackTrace(3);
            DebuggerContext.addSnapshot(this.duplicateSnapshotForProbe(status.probeDetails));
        }
    }

    private Snapshot duplicateSnapshotForProbe(ProbeDetails probe) {
        Snapshot snapshot = new Snapshot(UUID.randomUUID().toString(), this.version, this.timestamp, this.duration, this.stack, probe.captureSnapshot ? this.captures : new Captures(), probe, this.language, this.thread, this.thisClassName, this.traceId, this.spanId);
        List<EvaluationError> evalErrors = this.errorsByProbeIds.get(probe.id);
        if (evalErrors != null) {
            snapshot.evaluationErrors = new ArrayList<EvaluationError>(evalErrors);
        }
        return snapshot;
    }

    public boolean isCapturing() {
        return this.capturing;
    }

    private boolean checkCapture(CapturedContext capture, MethodLocation methodLocation) {
        boolean ret = false;
        for (Map.Entry<String, SnapshotStatus> entry : this.snapshotStatuses.entrySet()) {
            DebuggerScript<Boolean> script;
            String currentProbeId = entry.getKey();
            SnapshotStatus status = entry.getValue();
            if (this.evaluateConditions(status.probeDetails, methodLocation) && !Snapshot.executeScript(script = status.probeDetails.getScript(), capture, currentProbeId)) {
                status.sending = false;
                status.capturing = false;
            }
            if (capture.hasEvaluationErrors()) {
                status.hasErrors = true;
                this.errorsByProbeIds.put(currentProbeId, this.extractEvaluationErrors(capture));
                status.sending = true;
            }
            ret |= status.capturing && !status.hasErrors;
        }
        if (ret) {
            capture.freeze();
        }
        this.capturing = ret;
        return ret;
    }

    private boolean evaluateConditions(ProbeDetails probe, MethodLocation methodLocation) {
        if (methodLocation == MethodLocation.DEFAULT || methodLocation == MethodLocation.ENTRY) {
            return probe.getEvaluateAt() == MethodLocation.DEFAULT || probe.getEvaluateAt() == MethodLocation.ENTRY;
        }
        return probe.getEvaluateAt() == methodLocation;
    }

    private List<EvaluationError> extractEvaluationErrors(CapturedContext capture) {
        ArrayList<EvaluationError> evalErrors = new ArrayList<EvaluationError>();
        evalErrors.addAll(capture.evaluationErrors);
        capture.evaluationErrors.clear();
        return evalErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean executeScript(DebuggerScript<Boolean> script, CapturedContext capture, String probeId) {
        if (script == null) {
            return true;
        }
        long startTs = System.nanoTime();
        try {
            if (!script.execute(capture).booleanValue()) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            LOG.debug("Script for probe[{}] evaluated in {}ns", (Object)probeId, (Object)(System.nanoTime() - startTs));
        }
        return true;
    }

    private void recordStackTrace(int offset) {
        this.stack.clear();
        int cntr = 0;
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            if (cntr++ < offset) continue;
            this.stack.add(CapturedStackFrame.from(ste));
        }
        this.summaryBuilder.addStack(this.stack);
        for (ProbeDetails additionalProbe : this.probe.additionalProbes) {
            additionalProbe.summaryBuilder.addStack(this.stack);
        }
    }

    private void processSummaries(BiConsumer<SummaryBuilder, CapturedContext> contextConsumer, CapturedContext context) {
        contextConsumer.accept(this.summaryBuilder, context);
        for (ProbeDetails additionalProbe : this.probe.additionalProbes) {
            contextConsumer.accept(additionalProbe.summaryBuilder, context);
        }
    }

    private static class SnapshotStatus {
        boolean capturing;
        boolean sending;
        boolean hasErrors;
        ProbeDetails probeDetails;

        public SnapshotStatus(boolean capturing, boolean sending, ProbeDetails probeDetails) {
            this.capturing = capturing;
            this.sending = sending;
            this.probeDetails = probeDetails;
        }

        public boolean isCapturing() {
            return this.capturing;
        }
    }

    public static class EvaluationError {
        private final String expr;
        private final String message;

        public EvaluationError(String expr, String message) {
            this.expr = expr;
            this.message = message;
        }

        public String getExpr() {
            return this.expr;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class CapturedThrowable {
        private final String type;
        private final String message;
        private final List<CapturedStackFrame> stacktrace;

        public CapturedThrowable(Throwable throwable) {
            this(throwable.getClass().getTypeName(), throwable.getLocalizedMessage(), CapturedThrowable.captureFrames(throwable.getStackTrace()));
        }

        public CapturedThrowable(String type, String message, List<CapturedStackFrame> stacktrace) {
            this.type = type;
            this.message = message;
            this.stacktrace = new ArrayList<CapturedStackFrame>(stacktrace);
        }

        public String getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }

        public List<CapturedStackFrame> getStacktrace() {
            return this.stacktrace;
        }

        private static List<CapturedStackFrame> captureFrames(StackTraceElement[] stackTrace) {
            if (stackTrace == null) {
                return Collections.emptyList();
            }
            ArrayList<CapturedStackFrame> capturedFrames = new ArrayList<CapturedStackFrame>(stackTrace.length);
            for (StackTraceElement element : stackTrace) {
                capturedFrames.add(CapturedStackFrame.from(element));
            }
            return capturedFrames;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CapturedThrowable that = (CapturedThrowable)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.message, that.message) && Objects.equals(this.stacktrace, that.stacktrace);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.message, this.stacktrace);
        }

        public String toString() {
            return "CapturedThrowable{type='" + this.type + '\'' + ", message='" + this.message + '\'' + ", stacktrace=" + this.stacktrace + '}';
        }
    }

    public static class CapturedThread {
        private final long id;
        private final String name;

        public CapturedThread(Thread thread) {
            this(thread.getId(), thread.getName());
        }

        public CapturedThread(long id, String name) {
            this.id = id;
            this.name = name;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CapturedThread that = (CapturedThread)o;
            return this.id == that.id && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }

        public String toString() {
            return "CapturedThread{id=" + this.id + ", name='" + this.name + '\'' + '}';
        }
    }

    public static class CapturedValue {
        public static final CapturedValue UNDEFINED = CapturedValue.of(null, Values.UNDEFINED_OBJECT);
        private String name;
        private final String declaredType;
        private final String type;
        private Object value;
        private String strValue;
        private final Map<String, CapturedValue> fields;
        private final Limits limits;
        private final String notCapturedReason;

        private CapturedValue(String name, String declaredType, Object value, Limits limits, Map<String, CapturedValue> fields, String notCapturedReason) {
            this.name = name;
            this.declaredType = declaredType;
            this.type = value != null && !CapturedValue.isPrimitive(declaredType) ? value.getClass().getTypeName() : declaredType;
            this.value = value;
            this.fields = fields == null ? Collections.emptyMap() : fields;
            this.limits = limits;
            this.notCapturedReason = notCapturedReason;
        }

        public boolean isResolved() {
            return true;
        }

        public String getName() {
            return this.name;
        }

        public String getDeclaredType() {
            return this.declaredType;
        }

        public String getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public String getStrValue() {
            return this.strValue;
        }

        public Map<String, CapturedValue> getFields() {
            return this.fields;
        }

        public Limits getLimits() {
            return this.limits;
        }

        public String getNotCapturedReason() {
            return this.notCapturedReason;
        }

        public void setName(String name) {
            this.name = name;
        }

        public static CapturedValue of(String declaredType, Object value) {
            return CapturedValue.build(null, declaredType, value, Limits.DEFAULT, null);
        }

        public static CapturedValue of(String name, String declaredType, Object value) {
            return CapturedValue.build(name, declaredType, value, Limits.DEFAULT, null);
        }

        public CapturedValue derive(String name, String type, Object value) {
            return CapturedValue.build(name, type, value, this.limits, null);
        }

        public static CapturedValue of(String name, String declaredType, Object value, int maxReferenceDepth, int maxCollectionSize, int maxLength, int maxFieldCount) {
            return CapturedValue.build(name, declaredType, value, new Limits(maxReferenceDepth, maxCollectionSize, maxLength, maxFieldCount), null);
        }

        public static CapturedValue notCapturedReason(String name, String type, String reason) {
            return CapturedValue.build(name, type, null, Limits.DEFAULT, reason);
        }

        public static CapturedValue raw(String type, Object value, String notCapturedReason) {
            return new CapturedValue(null, type, value, Limits.DEFAULT, Collections.emptyMap(), notCapturedReason);
        }

        public static CapturedValue raw(String name, String type, Object value, Limits limits, Map<String, CapturedValue> fields, String notCapturedReason) {
            return new CapturedValue(name, type, value, limits, fields, notCapturedReason);
        }

        private static CapturedValue build(String name, String declaredType, Object value, Limits limits, String notCapturedReason) {
            CapturedValue val = new CapturedValue(name, declaredType, value, limits, Collections.emptyMap(), notCapturedReason);
            return val;
        }

        public void freeze() {
            if (this.strValue != null) {
                return;
            }
            this.strValue = DebuggerContext.serializeValue(this);
            if (this.strValue != null) {
                this.value = null;
            }
        }

        private static boolean isPrimitive(String type) {
            if (type == null) {
                return false;
            }
            switch (type) {
                case "byte": 
                case "short": 
                case "char": 
                case "int": 
                case "long": 
                case "boolean": 
                case "float": 
                case "double": {
                    return true;
                }
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CapturedValue that = (CapturedValue)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.declaredType, that.declaredType) && Objects.equals(this.value, that.value) && Objects.equals(this.fields, that.fields) && Objects.equals(this.notCapturedReason, that.notCapturedReason);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.declaredType, this.value, this.fields, this.notCapturedReason);
        }

        public String toString() {
            return "CapturedValue{name='" + this.name + '\'' + ", type='" + this.declaredType + '\'' + ", value='" + this.value + '\'' + ", fields=" + this.fields + ", notCapturedReason='" + this.notCapturedReason + '\'' + '}';
        }
    }

    public static class CapturedContext
    implements ValueReferenceResolver {
        private final transient Map<String, Object> extensions = new HashMap<String, Object>();
        private Map<String, CapturedValue> arguments;
        private Map<String, CapturedValue> locals;
        private CapturedThrowable throwable;
        private Map<String, CapturedValue> fields;
        private Limits limits = Limits.DEFAULT;
        private String thisClassName;
        private List<EvaluationError> evaluationErrors;
        private String traceId;
        private String spanId;

        public CapturedContext() {
        }

        public CapturedContext(CapturedValue[] arguments, CapturedValue[] locals, CapturedValue returnValue, CapturedThrowable throwable, CapturedValue[] fields) {
            this.addArguments(arguments);
            this.addLocals(locals);
            this.addReturn(returnValue);
            this.throwable = throwable;
            this.addFields(fields);
        }

        private CapturedContext(CapturedContext other, Map<String, Object> extensions) {
            this.arguments = other.arguments;
            this.locals = other.getLocals();
            this.throwable = other.throwable;
            this.fields = other.fields;
            this.extensions.putAll(other.extensions);
            this.extensions.putAll(extensions);
        }

        @Override
        public Object lookup(String name) {
            Object target;
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("empty name for lookup operation");
            }
            if (name.startsWith(ValueReferences.SYNTHETIC_PREFIX)) {
                String rawName = name.substring(ValueReferences.SYNTHETIC_PREFIX.length());
                target = this.tryRetrieveSynthetic(rawName);
                this.checkUndefined(name, target, rawName, "Cannot find synthetic var: ");
            } else {
                target = this.tryRetrieve(name);
                this.checkUndefined(name, target, name, "Cannot find symbol: ");
            }
            return target instanceof CapturedValue ? ((CapturedValue)target).getValue() : target;
        }

        private void checkUndefined(String expr, Object target, String name, String msg) {
            if (target == Values.UNDEFINED_OBJECT) {
                this.addEvaluationError(expr, msg + name);
            }
        }

        @Override
        public Object getMember(Object target, String memberName) {
            CapturedValue capturedTarget;
            Map fields;
            if (target == Values.UNDEFINED_OBJECT) {
                return target;
            }
            target = target instanceof CapturedValue ? ((fields = ((CapturedValue)target).fields).containsKey(memberName) ? fields.get(memberName) : ((target = (capturedTarget = (CapturedValue)target).getValue()) != null ? ReflectiveFieldValueResolver.resolve(target, target.getClass(), memberName) : Values.UNDEFINED_OBJECT)) : ReflectiveFieldValueResolver.resolve(target, target.getClass(), memberName);
            this.checkUndefined(memberName, target, memberName, "Cannot dereference to field: ");
            return target;
        }

        private Object tryRetrieveSynthetic(String name) {
            if (this.extensions == null || this.extensions.isEmpty()) {
                return Values.UNDEFINED_OBJECT;
            }
            return this.extensions.getOrDefault(name, Values.UNDEFINED_OBJECT);
        }

        private Object tryRetrieve(String name) {
            CapturedValue result = null;
            if (this.arguments != null && !this.arguments.isEmpty()) {
                result = this.arguments.get(name);
            }
            if (result != null) {
                return result;
            }
            if (this.locals != null && !this.locals.isEmpty()) {
                result = this.locals.get(name);
            }
            if (result != null) {
                return result;
            }
            if (this.fields != null && !this.fields.isEmpty()) {
                result = this.fields.get(name);
            }
            return result != null ? result : Values.UNDEFINED_OBJECT;
        }

        @Override
        public ValueReferenceResolver withExtensions(Map<String, Object> extensions) {
            return new CapturedContext(this, extensions);
        }

        private void addExtension(String name, Object value) {
            this.extensions.put(name, value);
        }

        public void addArguments(CapturedValue[] values) {
            if (values == null) {
                return;
            }
            if (this.arguments == null) {
                this.arguments = new HashMap<String, CapturedValue>();
            }
            for (CapturedValue value : values) {
                this.arguments.put(value.name, value);
            }
        }

        public void addLocals(CapturedValue[] values) {
            if (values == null) {
                return;
            }
            if (this.locals == null) {
                this.locals = new HashMap<String, CapturedValue>();
            }
            for (CapturedValue value : values) {
                this.locals.put(value.name, value);
            }
        }

        public void addReturn(CapturedValue retValue) {
            if (retValue == null) {
                return;
            }
            if (this.locals == null) {
                this.locals = new HashMap<String, CapturedValue>();
            }
            this.locals.put("@return", retValue);
            this.extensions.put(ValueReferences.RETURN_EXTENSION_NAME, retValue);
        }

        public void addThrowable(Throwable t) {
            this.throwable = new CapturedThrowable(t);
        }

        public void addThrowable(CapturedThrowable capturedThrowable) {
            this.throwable = capturedThrowable;
        }

        public void addFields(CapturedValue[] values) {
            if (values == null) {
                return;
            }
            if (this.fields == null) {
                this.fields = new HashMap<String, CapturedValue>();
            }
            for (CapturedValue value : values) {
                this.fields.put(value.name, value);
            }
            this.traceId = this.extractSpecialId("dd.trace_id");
            this.spanId = this.extractSpecialId("dd.span_id");
        }

        private String extractSpecialId(String idName) {
            CapturedValue capturedValue = this.fields.get(idName);
            if (capturedValue == null) {
                return null;
            }
            Object value = capturedValue.getValue();
            return value instanceof String ? (String)value : null;
        }

        @Override
        public void addEvaluationError(String expr, String message) {
            if (this.evaluationErrors == null) {
                this.evaluationErrors = new ArrayList<EvaluationError>();
            }
            this.evaluationErrors.add(new EvaluationError(expr, message));
        }

        boolean hasEvaluationErrors() {
            if (this.evaluationErrors != null) {
                return !this.evaluationErrors.isEmpty();
            }
            return false;
        }

        public void setLimits(int maxReferenceDepth, int maxCollectionSize, int maxLength, int maxFieldCount) {
            this.limits = new Limits(maxReferenceDepth, maxCollectionSize, maxLength, maxFieldCount);
        }

        public void setThisClassName(String thisClassName) {
            this.thisClassName = thisClassName;
        }

        public Map<String, CapturedValue> getArguments() {
            return this.arguments;
        }

        public Map<String, CapturedValue> getLocals() {
            return this.locals;
        }

        public CapturedThrowable getThrowable() {
            return this.throwable;
        }

        public Map<String, CapturedValue> getFields() {
            return this.fields;
        }

        public Limits getLimits() {
            return this.limits;
        }

        public String getThisClassName() {
            return this.thisClassName;
        }

        public String getTraceId() {
            return this.traceId;
        }

        public String getSpanId() {
            return this.spanId;
        }

        public void freeze() {
            if (this.arguments != null) {
                this.arguments.values().forEach(CapturedValue::freeze);
            }
            if (this.locals != null) {
                this.locals.values().forEach(CapturedValue::freeze);
            }
            if (this.fields != null) {
                this.fields.values().forEach(CapturedValue::freeze);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CapturedContext context = (CapturedContext)o;
            return Objects.equals(this.arguments, context.arguments) && Objects.equals(this.locals, context.locals) && Objects.equals(this.throwable, context.throwable) && Objects.equals(this.fields, context.fields);
        }

        public int hashCode() {
            return Objects.hash(this.arguments, this.locals, this.throwable, this.fields);
        }

        public String toString() {
            return "CapturedContext{arguments=" + this.arguments + ", locals=" + this.locals + ", throwable=" + this.throwable + ", fields=" + this.fields + '}';
        }
    }

    public static class Captures {
        private CapturedContext entry;
        private Map<Integer, CapturedContext> lines;
        private CapturedContext _return;
        private List<CapturedThrowable> caughtExceptions;

        public CapturedContext getEntry() {
            return this.entry;
        }

        public Map<Integer, CapturedContext> getLines() {
            return this.lines;
        }

        public CapturedContext getReturn() {
            return this._return;
        }

        public List<CapturedThrowable> getCaughtExceptions() {
            return this.caughtExceptions;
        }

        public void setEntry(CapturedContext context) {
            this.entry = context;
        }

        public void setReturn(CapturedContext context) {
            this._return = context;
        }

        public void addLine(int line, CapturedContext context) {
            if (this.lines == null) {
                this.lines = new HashMap<Integer, CapturedContext>();
            }
            this.lines.put(line, context);
        }

        public void addCaughtException(CapturedThrowable context) {
            if (this.caughtExceptions == null) {
                this.caughtExceptions = new ArrayList<CapturedThrowable>();
            }
            this.caughtExceptions.add(context);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Captures captures = (Captures)o;
            return Objects.equals(this.entry, captures.entry) && Objects.equals(this.lines, captures.lines) && Objects.equals(this._return, captures._return) && Objects.equals(this.caughtExceptions, captures.caughtExceptions);
        }

        public int hashCode() {
            return Objects.hash(this.entry, this.lines, this._return, this.caughtExceptions);
        }

        public String toString() {
            return "Captures{entry=" + this.entry + ", lines=" + this.lines + ", exit=" + this._return + ", caughtExceptions=" + this.caughtExceptions + '}';
        }
    }

    public static class ProbeLocation {
        public static final ProbeLocation UNKNOWN = new ProbeLocation("UNKNOWN", "UNKNOWN", "UNKNOWN", Collections.emptyList());
        private final String type;
        private final String method;
        private final String file;
        private final List<String> lines;

        public ProbeLocation(String type, String method, String file, List<String> lines) {
            this.type = type;
            this.method = method;
            this.file = file;
            this.lines = lines;
        }

        public String getType() {
            return this.type;
        }

        public String getMethod() {
            return this.method;
        }

        public String getFile() {
            return this.file;
        }

        public List<String> getLines() {
            return this.lines;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProbeLocation that = (ProbeLocation)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.method, that.method) && Objects.equals(this.file, that.file) && Objects.equals(this.lines, that.lines);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.method, this.file, this.lines);
        }

        public String toString() {
            return "ProbeLocation{type='" + this.type + '\'' + ", method='" + this.method + '\'' + ", file='" + this.file + '\'' + ", lines=" + this.lines + '}';
        }
    }

    public static class ProbeDetails {
        public static final String ITW_PROBE_ID = "instrument-the-world-probe";
        public static final ProbeDetails UNKNOWN = new ProbeDetails("UNKNOWN", ProbeLocation.UNKNOWN);
        public static final ProbeDetails ITW_PROBE = new ProbeDetails("instrument-the-world-probe", ProbeLocation.UNKNOWN);
        private final String id;
        private final ProbeLocation location;
        private final MethodLocation evaluateAt;
        private final transient boolean captureSnapshot;
        private final DebuggerScript script;
        private final transient List<ProbeDetails> additionalProbes;
        private final String tags;
        private final transient SummaryBuilder summaryBuilder;

        public ProbeDetails(String id, ProbeLocation location) {
            this(id, location, MethodLocation.DEFAULT, true, null, null, new SnapshotSummaryBuilder(location), Collections.emptyList());
        }

        public ProbeDetails(String id, ProbeLocation location, MethodLocation evaluateAt, boolean captureSnapshot, DebuggerScript<Boolean> script, String tags, SummaryBuilder summaryBuilder) {
            this(id, location, evaluateAt, captureSnapshot, script, tags, summaryBuilder, Collections.emptyList());
        }

        public ProbeDetails(String id, ProbeLocation location, MethodLocation evaluateAt, boolean captureSnapshot, DebuggerScript<Boolean> script, String tags, SummaryBuilder summaryBuilder, List<ProbeDetails> additionalProbes) {
            this.id = id;
            this.location = location;
            this.evaluateAt = evaluateAt;
            this.captureSnapshot = captureSnapshot;
            this.script = script;
            this.additionalProbes = additionalProbes;
            this.tags = tags;
            this.summaryBuilder = summaryBuilder;
        }

        public String getId() {
            return this.id;
        }

        public ProbeLocation getLocation() {
            return this.location;
        }

        public MethodLocation getEvaluateAt() {
            return this.evaluateAt;
        }

        public DebuggerScript<Boolean> getScript() {
            return this.script;
        }

        public String getTags() {
            return this.tags;
        }

        public boolean isSnapshotProbe() {
            return this.summaryBuilder instanceof SnapshotSummaryBuilder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProbeDetails that = (ProbeDetails)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.location, that.location) && Objects.equals(this.script, that.script) && Objects.equals(this.tags, that.tags);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.location, this.script, this.tags);
        }

        public String toString() {
            return "ProbeDetails{id='" + this.id + '\'' + ", probeLocation=" + this.location + ", script=" + this.script + ", tags=" + this.tags + '}';
        }
    }

    public static enum MethodLocation {
        DEFAULT,
        ENTRY,
        EXIT;

    }

    public static enum Kind {
        ENTER,
        RETURN,
        UNHANDLED_EXCEPTION,
        HANDLED_EXCEPTION,
        BEFORE,
        AFTER;

    }
}

