/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.debugger;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.debugger.DebuggerContext;
import datadog.trace.bootstrap.debugger.ProbeRateLimiter;
import datadog.trace.bootstrap.debugger.Snapshot;

public final class SnapshotProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotProvider.class);

    public static Snapshot newSnapshot(String uuid, Class<?> callingClass) {
        Snapshot.ProbeDetails probeDetails = DebuggerContext.resolveProbe(uuid, callingClass);
        if (probeDetails == null) {
            LOG.info("Cannot resolve the probe: {}", (Object)uuid);
            probeDetails = Snapshot.ProbeDetails.UNKNOWN;
        }
        if (probeDetails.getScript() == null && probeDetails.isSnapshotProbe() && !ProbeRateLimiter.tryProbe(probeDetails.getId())) {
            DebuggerContext.skipSnapshot(probeDetails.getId(), DebuggerContext.SkipCause.RATE);
            return null;
        }
        return new Snapshot(Thread.currentThread(), probeDetails, callingClass.getTypeName());
    }
}

