/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.debugger;

import datadog.trace.bootstrap.debugger.CapturedStackFrame;
import datadog.trace.bootstrap.debugger.Snapshot;
import datadog.trace.bootstrap.debugger.SummaryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SnapshotSummaryBuilder
implements SummaryBuilder {
    private final Snapshot.ProbeLocation probeLocation;
    private String arguments;
    private String method;
    private String returnValue;
    private String locals;

    public SnapshotSummaryBuilder(Snapshot.ProbeLocation probeLocation) {
        this.probeLocation = probeLocation;
    }

    @Override
    public void addEntry(Snapshot.CapturedContext entry) {
        if (entry == null) {
            return;
        }
        if (entry.getArguments() != null) {
            this.arguments = SnapshotSummaryBuilder.formatCapturedValues(entry.getArguments());
        }
    }

    @Override
    public void addExit(Snapshot.CapturedContext exit) {
        if (exit == null) {
            return;
        }
        if (exit.getLocals() == null) {
            return;
        }
        this.locals = SnapshotSummaryBuilder.formatCapturedValues(SnapshotSummaryBuilder.removeReturnFromLocals(exit.getLocals()));
        Snapshot.CapturedValue capturedReturnValue = exit.getLocals().get("@return");
        if (capturedReturnValue != null) {
            this.returnValue = String.valueOf(capturedReturnValue.getValue());
        }
    }

    @Override
    public void addLine(Snapshot.CapturedContext line) {
        if (line == null) {
            return;
        }
        if (line.getArguments() != null) {
            this.arguments = SnapshotSummaryBuilder.formatCapturedValues(line.getArguments());
        }
        if (line.getLocals() != null) {
            this.locals = SnapshotSummaryBuilder.formatCapturedValues(line.getLocals());
        }
    }

    @Override
    public void addStack(List<CapturedStackFrame> stack) {
        this.method = SnapshotSummaryBuilder.formatMethod(stack, this.probeLocation);
    }

    @Override
    public String build() {
        StringBuilder sb = new StringBuilder();
        if (this.method == null) {
            this.method = SnapshotSummaryBuilder.formatMethod(this.probeLocation);
        }
        sb.append(this.method);
        sb.append("(");
        if (this.arguments != null) {
            sb.append(this.arguments);
        }
        sb.append(")");
        if (this.returnValue != null) {
            sb.append(": ").append(this.returnValue);
        }
        if (this.locals != null && !this.locals.isEmpty()) {
            sb.append("\n").append(this.locals);
        }
        return sb.toString();
    }

    @Override
    public List<Snapshot.EvaluationError> getEvaluationErrors() {
        return Collections.emptyList();
    }

    private static String formatMethod(List<CapturedStackFrame> stack, Snapshot.ProbeLocation probeLocation) {
        if (stack != null && stack.size() > 0) {
            CapturedStackFrame topFrame = stack.get(0);
            return SnapshotSummaryBuilder.formatMethod(topFrame);
        }
        if (probeLocation != null) {
            return SnapshotSummaryBuilder.formatMethod(probeLocation);
        }
        return null;
    }

    private static String formatMethod(CapturedStackFrame stackFrame) {
        if (stackFrame.getFunction() != null) {
            List<String> classAndMethod = SnapshotSummaryBuilder.getClassAndMethod(stackFrame.getFunction());
            if (classAndMethod.size() == 2) {
                return classAndMethod.get(1) + "." + classAndMethod.get(0);
            }
            if (classAndMethod.size() == 1) {
                return classAndMethod.get(0);
            }
            return stackFrame.getFunction();
        }
        return stackFrame.getFileName();
    }

    private static List<String> getClassAndMethod(String stackFrameFunction) {
        int lastDotIdx;
        int firstParenIdx = stackFrameFunction.indexOf(40);
        if (firstParenIdx >= 0) {
            stackFrameFunction = stackFrameFunction.substring(0, firstParenIdx);
        }
        if ((lastDotIdx = stackFrameFunction.lastIndexOf(46)) == -1) {
            return Collections.singletonList(stackFrameFunction);
        }
        ArrayList<String> results = new ArrayList<String>();
        while (lastDotIdx > -1 && results.size() < 2) {
            String part = stackFrameFunction.substring(lastDotIdx + 1);
            results.add(part);
            stackFrameFunction = stackFrameFunction.substring(0, lastDotIdx);
            lastDotIdx = stackFrameFunction.lastIndexOf(46);
        }
        return results;
    }

    private static String formatMethod(Snapshot.ProbeLocation probeLocation) {
        if (probeLocation.getType() != null && probeLocation.getMethod() != null) {
            String fqn = probeLocation.getType();
            String className = fqn.substring(fqn.lastIndexOf(46) + 1);
            return className + "." + probeLocation.getMethod();
        }
        if (probeLocation.getMethod() != null) {
            return probeLocation.getMethod();
        }
        return probeLocation.getFile() + ":" + probeLocation.getLines();
    }

    private static String formatCapturedValues(Map<String, Snapshot.CapturedValue> capturedValues) {
        return capturedValues.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> (String)entry.getKey() + "=" + ((Snapshot.CapturedValue)entry.getValue()).getValue()).collect(Collectors.joining(", "));
    }

    private static Map<String, Snapshot.CapturedValue> removeReturnFromLocals(Map<String, Snapshot.CapturedValue> locals) {
        HashMap<String, Snapshot.CapturedValue> localMap = new HashMap<String, Snapshot.CapturedValue>(locals);
        localMap.remove("@return");
        return localMap;
    }
}

