/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api;

import datadog.trace.api.DDTraceId;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTrace;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.PathwayContext;
import java.util.Collections;
import java.util.Map;

public class TagContext
implements AgentSpan.Context.Extracted {
    private static final HttpHeaders EMPTY_HTTP_HEADERS = new HttpHeaders();
    private final String origin;
    private final Map<String, String> tags;
    private Object requestContextDataAppSec;
    private Object requestContextDataIast;
    private final HttpHeaders httpHeaders;
    private final Map<String, String> baggage;
    private final int samplingPriority;

    public TagContext() {
        this(null, null);
    }

    public TagContext(String origin, Map<String, String> tags) {
        this(origin, tags, null, null, -128);
    }

    public TagContext(String origin, Map<String, String> tags, HttpHeaders httpHeaders, Map<String, String> baggage, int samplingPriority) {
        this.origin = origin;
        this.tags = tags;
        this.httpHeaders = httpHeaders == null ? EMPTY_HTTP_HEADERS : httpHeaders;
        this.baggage = baggage == null ? Collections.emptyMap() : baggage;
        this.samplingPriority = samplingPriority;
    }

    public final String getOrigin() {
        return this.origin;
    }

    @Override
    public String getForwarded() {
        return this.httpHeaders.forwarded;
    }

    @Override
    public String getXForwardedProto() {
        return this.httpHeaders.xForwardedProto;
    }

    @Override
    public String getXForwardedHost() {
        return this.httpHeaders.xForwardedHost;
    }

    @Override
    public String getXForwardedPort() {
        return this.httpHeaders.xForwardedPort;
    }

    @Override
    public String getForwardedFor() {
        return this.httpHeaders.forwardedFor;
    }

    @Override
    public String getXForwarded() {
        return this.httpHeaders.xForwarded;
    }

    @Override
    public String getXForwardedFor() {
        return this.httpHeaders.xForwardedFor;
    }

    @Override
    public String getXClusterClientIp() {
        return this.httpHeaders.xClusterClientIp;
    }

    @Override
    public String getXRealIp() {
        return this.httpHeaders.xRealIp;
    }

    @Override
    public String getClientIp() {
        return this.httpHeaders.clientIp;
    }

    @Override
    public String getUserAgent() {
        return this.httpHeaders.userAgent;
    }

    @Override
    public String getVia() {
        return this.httpHeaders.via;
    }

    @Override
    public String getTrueClientIp() {
        return this.httpHeaders.trueClientIp;
    }

    @Override
    public String getCustomIpHeader() {
        return this.httpHeaders.customIpHeader;
    }

    public final Map<String, String> getTags() {
        return this.tags;
    }

    public final int getSamplingPriority() {
        return this.samplingPriority;
    }

    public final Map<String, String> getBaggage() {
        return this.baggage;
    }

    @Override
    public Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggage.entrySet();
    }

    @Override
    public DDTraceId getTraceId() {
        return DDTraceId.ZERO;
    }

    @Override
    public long getSpanId() {
        return 0L;
    }

    @Override
    public final AgentTrace getTrace() {
        return AgentTracer.NoopAgentTrace.INSTANCE;
    }

    public final Object getRequestContextDataAppSec() {
        return this.requestContextDataAppSec;
    }

    public final TagContext withRequestContextDataAppSec(Object requestContextData) {
        this.requestContextDataAppSec = requestContextData;
        return this;
    }

    public final Object getRequestContextDataIast() {
        return this.requestContextDataIast;
    }

    public final TagContext withRequestContextDataIast(Object requestContextData) {
        this.requestContextDataIast = requestContextData;
        return this;
    }

    @Override
    public PathwayContext getPathwayContext() {
        return null;
    }

    public static class HttpHeaders {
        public String forwardedFor;
        public String xForwarded;
        public String forwarded;
        public String xForwardedProto;
        public String xForwardedHost;
        public String xForwardedPort;
        public String xForwardedFor;
        public String xClusterClientIp;
        public String xRealIp;
        public String clientIp;
        public String userAgent;
        public String via;
        public String trueClientIp;
        public String customIpHeader;
    }
}

