/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.trace.api.Config;
import datadog.trace.api.Functions;
import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDCaches;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.decorator.ClientDecorator;
import java.util.function.Function;

public abstract class DatabaseClientDecorator<CONNECTION>
extends ClientDecorator {
    private static final DDCache<CharSequence, CharSequence> CACHE = DDCaches.newFixedSizeCache(16);
    private static final Function<CharSequence, CharSequence> APPEND_OPERATION = new Functions.Suffix(".query");

    protected abstract String dbType();

    protected abstract String dbUser(CONNECTION var1);

    protected abstract String dbInstance(CONNECTION var1);

    protected abstract CharSequence dbHostname(CONNECTION var1);

    public AgentSpan onConnection(AgentSpan span, CONNECTION connection) {
        if (connection != null) {
            CharSequence hostName;
            span.setTag("db.user", this.dbUser(connection));
            String instanceName = this.dbInstance(connection);
            span.setTag("db.instance", instanceName);
            if (instanceName != null && Config.get().isDbClientSplitByInstance()) {
                span.setServiceName(Config.get().isDbClientSplitByInstanceTypeSuffix() ? instanceName + "-" + this.dbType() : instanceName);
            }
            if ((hostName = this.dbHostname(connection)) != null) {
                span.setTag("peer.hostname", hostName);
            }
        }
        return span;
    }

    public AgentSpan onStatement(AgentSpan span, CharSequence statement) {
        span.setResourceName(statement);
        return span;
    }

    protected void processDatabaseType(AgentSpan span, String dbType) {
        span.setServiceName(dbType);
        span.setOperationName(CACHE.computeIfAbsent(dbType, APPEND_OPERATION));
        span.setTag("db.type", dbType);
    }
}

