/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.api.function.TriConsumer;
import datadog.trace.api.function.TriFunction;
import datadog.trace.api.gateway.BlockResponseFunction;
import datadog.trace.api.gateway.CallbackProvider;
import datadog.trace.api.gateway.Events;
import datadog.trace.api.gateway.Flow;
import datadog.trace.api.gateway.IGSpanInfo;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.api.gateway.RequestContextSlot;
import datadog.trace.bootstrap.ActiveSubsystems;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.InternalSpanTypes;
import datadog.trace.bootstrap.instrumentation.api.PathwayContext;
import datadog.trace.bootstrap.instrumentation.api.TagContext;
import datadog.trace.bootstrap.instrumentation.api.URIDataAdapter;
import datadog.trace.bootstrap.instrumentation.api.URIUtils;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.bootstrap.instrumentation.decorator.ServerDecorator;
import datadog.trace.bootstrap.instrumentation.decorator.http.ClientIpAddressResolver;
import datadog.trace.bootstrap.instrumentation.decorator.http.HttpResourceDecorator;
import java.net.InetAddress;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public abstract class HttpServerDecorator<REQUEST, CONNECTION, RESPONSE, REQUEST_CARRIER>
extends ServerDecorator {
    private static final Logger log = LoggerFactory.getLogger(HttpServerDecorator.class);
    private static final int UNSET_PORT = 0;
    public static final String DD_SPAN_ATTRIBUTE = "datadog.span";
    public static final String DD_DISPATCH_SPAN_ATTRIBUTE = "datadog.span.dispatch";
    public static final String DD_RESPONSE_ATTRIBUTE = "datadog.response";
    public static final LinkedHashMap<String, String> SERVER_PATHWAY_EDGE_TAGS = new LinkedHashMap(2);
    private static final UTF8BytesString DEFAULT_RESOURCE_NAME;
    protected static final UTF8BytesString NOT_FOUND_RESOURCE_NAME;
    private static final boolean SHOULD_SET_404_RESOURCE_NAME;
    private static final boolean SHOULD_SET_URL_RESOURCE_NAME;
    private static final BitSet SERVER_ERROR_STATUSES;
    private final boolean traceClientIpResolverEnabled = Config.get().isTraceClientIpResolverEnabled();

    protected abstract AgentPropagation.ContextVisitor<REQUEST_CARRIER> getter();

    protected abstract AgentPropagation.ContextVisitor<RESPONSE> responseGetter();

    public abstract CharSequence spanName();

    protected abstract String method(REQUEST var1);

    protected abstract URIDataAdapter url(REQUEST var1);

    protected abstract String peerHostIP(CONNECTION var1);

    protected abstract int peerPort(CONNECTION var1);

    protected abstract int status(RESPONSE var1);

    @Override
    protected CharSequence spanType() {
        return InternalSpanTypes.HTTP_SERVER;
    }

    @Override
    protected boolean traceAnalyticsDefault() {
        return Config.get().isTraceAnalyticsEnabled();
    }

    protected AgentTracer.TracerAPI tracer() {
        return AgentTracer.get();
    }

    public AgentSpan.Context.Extracted extract(REQUEST_CARRIER carrier) {
        AgentPropagation.ContextVisitor<REQUEST_CARRIER> getter = this.getter();
        if (null == carrier || null == getter) {
            return null;
        }
        return this.tracer().propagate().extract(carrier, getter);
    }

    public AgentSpan startSpan(REQUEST_CARRIER carrier, AgentSpan.Context.Extracted context) {
        AgentSpan span = this.tracer().startSpan(this.spanName(), this.callIGCallbackStart(context)).setMeasured(true);
        Flow<Void> flow = this.callIGCallbackRequestHeaders(span, carrier);
        if (flow.getAction() instanceof Flow.Action.RequestBlockingAction) {
            span.setRequestBlockingAction((Flow.Action.RequestBlockingAction)flow.getAction());
        }
        AgentPropagation.ContextVisitor<REQUEST_CARRIER> getter = this.getter();
        if (null != carrier && null != getter) {
            PathwayContext pathwayContext = AgentTracer.propagate().extractPathwayContext(carrier, getter);
            span.mergePathwayContext(pathwayContext);
            this.tracer().setDataStreamCheckpoint(span, SERVER_PATHWAY_EDGE_TAGS);
        }
        return span;
    }

    public AgentSpan onRequest(AgentSpan span, CONNECTION connection, REQUEST request, AgentSpan.Context.Extracted context) {
        BlockResponseFunction brf;
        RequestContext requestContext;
        boolean clientIpResolverEnabled;
        Config config = Config.get();
        boolean bl = clientIpResolverEnabled = config.isClientIpEnabled() || this.traceClientIpResolverEnabled && ActiveSubsystems.APPSEC_ACTIVE;
        if (ActiveSubsystems.APPSEC_ACTIVE && (requestContext = span.getRequestContext()) != null && (brf = this.createBlockResponseFunction(request, connection)) != null) {
            requestContext.setBlockResponseFunction(brf);
        }
        if (context != null) {
            String userAgent;
            if (clientIpResolverEnabled) {
                String forwardedPort;
                String forwardedIp;
                String forwardedHost;
                String forwardedProto;
                String forwarded = context.getForwarded();
                if (forwarded != null) {
                    span.setTag("http.forwarded", forwarded);
                }
                if ((forwardedProto = context.getXForwardedProto()) != null) {
                    span.setTag("http.forwarded.proto", forwardedProto);
                }
                if ((forwardedHost = context.getXForwardedHost()) != null) {
                    span.setTag("http.forwarded.host", forwardedHost);
                }
                if ((forwardedIp = context.getXForwardedFor()) != null) {
                    span.setTag("http.forwarded.ip", forwardedIp);
                }
                if ((forwardedPort = context.getXForwardedPort()) != null) {
                    span.setTag("http.forwarded.port", forwardedPort);
                }
            }
            if ((userAgent = context.getUserAgent()) != null) {
                span.setTag("http.useragent", userAgent);
            }
        }
        if (request != null) {
            String method = this.method(request);
            span.setTag("http.method", method);
            try {
                URIDataAdapter url = this.url(request);
                if (url != null) {
                    Flow<Void> flow;
                    boolean supportsRaw = url.supportsRaw();
                    boolean encoded = supportsRaw && config.isHttpServerRawResource();
                    String path = encoded ? url.rawPath() : url.path();
                    span.setTag("http.url", URIUtils.buildURL(url.scheme(), url.host(), url.port(), path));
                    if (context != null && context.getXForwardedHost() != null) {
                        span.setTag("http.hostname", context.getXForwardedHost());
                    } else if (url.host() != null) {
                        span.setTag("http.hostname", url.host());
                    }
                    if (config.isHttpServerTagQueryString()) {
                        String query = supportsRaw && config.isHttpServerRawQueryString() ? url.rawQuery() : url.query();
                        span.setTag("http.query.string", query);
                        span.setTag("http.fragment.string", url.fragment());
                    }
                    if ((flow = this.callIGCallbackURI(span, url, method)).getAction() instanceof Flow.Action.RequestBlockingAction) {
                        span.setRequestBlockingAction((Flow.Action.RequestBlockingAction)flow.getAction());
                    }
                    if (SHOULD_SET_URL_RESOURCE_NAME) {
                        HttpResourceDecorator.HTTP_RESOURCE_DECORATOR.withServerPath(span, method, path, encoded);
                    }
                } else if (SHOULD_SET_URL_RESOURCE_NAME) {
                    span.setResourceName(DEFAULT_RESOURCE_NAME);
                }
            }
            catch (Exception e) {
                log.debug("Error tagging url", e);
            }
        }
        String peerIp = null;
        int peerPort = 0;
        if (connection != null) {
            peerIp = this.peerHostIP(connection);
            peerPort = this.peerPort(connection);
        }
        String inferredAddressStr = null;
        if (clientIpResolverEnabled) {
            InetAddress inferredAddress = ClientIpAddressResolver.resolve(context, span);
            if (peerIp != null) {
                InetAddress peerAddress;
                if (inferredAddress == null) {
                    inferredAddress = ClientIpAddressResolver.parseIpAddress(peerIp);
                } else if (ClientIpAddressResolver.isIpAddrPrivate(inferredAddress) && !ClientIpAddressResolver.isIpAddrPrivate(peerAddress = ClientIpAddressResolver.parseIpAddress(peerIp))) {
                    inferredAddress = peerAddress;
                }
            }
            if (inferredAddress != null) {
                inferredAddressStr = inferredAddress.getHostAddress();
                span.setTag("http.client_ip", inferredAddressStr);
            }
        }
        if (peerIp != null) {
            if (peerIp.indexOf(58) > 0) {
                span.setTag("peer.ipv6", peerIp);
            } else {
                span.setTag("peer.ipv4", peerIp);
            }
        }
        this.setPeerPort(span, peerPort);
        Flow<Void> flow = this.callIGCallbackAddressAndPort(span, peerIp, peerPort, inferredAddressStr);
        if (flow.getAction() instanceof Flow.Action.RequestBlockingAction) {
            span.setRequestBlockingAction((Flow.Action.RequestBlockingAction)flow.getAction());
        }
        return span;
    }

    protected BlockResponseFunction createBlockResponseFunction(REQUEST request, CONNECTION connection) {
        return null;
    }

    public AgentSpan onResponse(AgentSpan span, RESPONSE response) {
        if (response != null) {
            ResponseHeaderTagClassifier tagger;
            AgentPropagation.ContextVisitor<RESPONSE> getter;
            int status = this.status(response);
            if (status > 0) {
                span.setHttpStatusCode(status);
            }
            if (SERVER_ERROR_STATUSES.get(status)) {
                span.setError(true);
            }
            if (SHOULD_SET_404_RESOURCE_NAME && status == 404) {
                span.setResourceName(NOT_FOUND_RESOURCE_NAME, (byte)2);
            }
            if ((getter = this.responseGetter()) != null && (tagger = ResponseHeaderTagClassifier.create(span, Config.get().getResponseHeaderTags())) != null) {
                getter.forEachKey(response, tagger);
            }
            this.callIGCallbackResponseAndHeaders(span, response, status);
        }
        return span;
    }

    private AgentSpan.Context.Extracted callIGCallbackStart(AgentSpan.Context.Extracted context) {
        AgentTracer.TracerAPI tracer = this.tracer();
        Supplier<Flow<Object>> startedCbAppSec = tracer.getCallbackProvider(RequestContextSlot.APPSEC).getCallback(Events.EVENTS.requestStarted());
        Supplier<Flow<Object>> startedCbIast = tracer.getCallbackProvider(RequestContextSlot.IAST).getCallback(Events.EVENTS.requestStarted());
        if (startedCbAppSec == null && startedCbIast == null) {
            return context;
        }
        TagContext tagContext = null;
        if (context == null) {
            tagContext = new TagContext();
        } else if (context instanceof TagContext) {
            tagContext = (TagContext)context;
        }
        if (tagContext != null) {
            if (startedCbAppSec != null) {
                tagContext.withRequestContextDataAppSec(startedCbAppSec.get().getResult());
            }
            if (startedCbIast != null) {
                tagContext.withRequestContextDataIast(startedCbIast.get().getResult());
            }
            return tagContext;
        }
        return context;
    }

    private Flow<Void> callIGCallbackRequestHeaders(AgentSpan span, REQUEST_CARRIER carrier) {
        CallbackProvider cbp = this.tracer().getCallbackProvider(RequestContextSlot.APPSEC);
        RequestContext requestContext = span.getRequestContext();
        AgentPropagation.ContextVisitor<REQUEST_CARRIER> getter = this.getter();
        if (requestContext == null || cbp == null || getter == null) {
            return Flow.ResultFlow.empty();
        }
        IGKeyClassifier igKeyClassifier = IGKeyClassifier.create(requestContext, cbp.getCallback(Events.EVENTS.requestHeader()), cbp.getCallback(Events.EVENTS.requestHeaderDone()));
        if (null != igKeyClassifier) {
            getter.forEachKey(carrier, igKeyClassifier);
            return igKeyClassifier.done();
        }
        return Flow.ResultFlow.empty();
    }

    private void callIGCallbackResponseAndHeaders(AgentSpan span, RESPONSE carrier, int status) {
        AgentPropagation.ContextVisitor<RESPONSE> getter;
        CallbackProvider cbp = this.tracer().getCallbackProvider(RequestContextSlot.APPSEC);
        RequestContext requestContext = span.getRequestContext();
        if (cbp == null || requestContext == null) {
            return;
        }
        BiFunction<RequestContext, Integer, Flow<Void>> addrCallback = cbp.getCallback(Events.EVENTS.responseStarted());
        if (null != addrCallback) {
            addrCallback.apply(requestContext, status);
        }
        if ((getter = this.responseGetter()) == null) {
            return;
        }
        IGKeyClassifier igKeyClassifier = IGKeyClassifier.create(requestContext, cbp.getCallback(Events.EVENTS.responseHeader()), cbp.getCallback(Events.EVENTS.responseHeaderDone()));
        if (null != igKeyClassifier) {
            getter.forEachKey(carrier, igKeyClassifier);
            igKeyClassifier.done();
        }
    }

    private Flow<Void> callIGCallbackURI(@Nonnull AgentSpan span, @Nonnull URIDataAdapter url, String method) {
        CallbackProvider cbp = this.tracer().getCallbackProvider(RequestContextSlot.APPSEC);
        RequestContext requestContext = span.getRequestContext();
        if (requestContext == null || cbp == null) {
            return Flow.ResultFlow.empty();
        }
        TriFunction<RequestContext, String, URIDataAdapter, Flow<Void>> callback = cbp.getCallback(Events.EVENTS.requestMethodUriRaw());
        if (callback != null) {
            return callback.apply(requestContext, method, url);
        }
        return Flow.ResultFlow.empty();
    }

    @Override
    public AgentSpan beforeFinish(AgentSpan span) {
        this.onRequestEndForInstrumentationGateway(span);
        return super.beforeFinish(span);
    }

    private void onRequestEndForInstrumentationGateway(@Nonnull AgentSpan span) {
        BiFunction<RequestContext, IGSpanInfo, Flow<Void>> callback;
        if (span.getLocalRootSpan() != span) {
            return;
        }
        CallbackProvider cbp = this.tracer().getUniversalCallbackProvider();
        RequestContext requestContext = span.getRequestContext();
        if (cbp != null && requestContext != null && (callback = cbp.getCallback(Events.EVENTS.requestEnded())) != null) {
            callback.apply(requestContext, span);
        }
    }

    private Flow<Void> callIGCallbackAddressAndPort(@Nonnull AgentSpan span, String ip, int port, String inferredClientIp) {
        TriFunction<RequestContext, String, Integer, Flow<Void>> addrCallback;
        BiFunction<RequestContext, String, Flow<Void>> inferredAddrCallback;
        CallbackProvider cbp = this.tracer().getCallbackProvider(RequestContextSlot.APPSEC);
        if (cbp == null || ip == null && inferredClientIp == null && port == 0) {
            return Flow.ResultFlow.empty();
        }
        RequestContext ctx = span.getRequestContext();
        if (ctx == null) {
            return Flow.ResultFlow.empty();
        }
        if (inferredClientIp != null && (inferredAddrCallback = cbp.getCallback(Events.EVENTS.requestInferredClientAddress())) != null) {
            inferredAddrCallback.apply(ctx, inferredClientIp);
        }
        if ((ip != null || port != 0) && (addrCallback = cbp.getCallback(Events.EVENTS.requestClientSocketAddress())) != null) {
            return addrCallback.apply(ctx, ip != null ? ip : "0.0.0.0", port);
        }
        return Flow.ResultFlow.empty();
    }

    static {
        SERVER_PATHWAY_EDGE_TAGS.put("direction", "in");
        SERVER_PATHWAY_EDGE_TAGS.put("type", "http");
        DEFAULT_RESOURCE_NAME = UTF8BytesString.create("/");
        NOT_FOUND_RESOURCE_NAME = UTF8BytesString.create("404");
        SHOULD_SET_404_RESOURCE_NAME = Config.get().isRuleEnabled("URLAsResourceNameRule") && Config.get().isRuleEnabled("Status404Rule") && Config.get().isRuleEnabled("Status404Decorator");
        SHOULD_SET_URL_RESOURCE_NAME = Config.get().isRuleEnabled("URLAsResourceNameRule");
        SERVER_ERROR_STATUSES = Config.get().getHttpServerErrorStatuses();
    }

    private static final class ResponseHeaderTagClassifier
    implements AgentPropagation.KeyClassifier {
        private final AgentSpan span;
        private final Map<String, String> headerTags;

        static ResponseHeaderTagClassifier create(AgentSpan span, Map<String, String> headerTags) {
            if (span == null || headerTags == null || headerTags.isEmpty()) {
                return null;
            }
            return new ResponseHeaderTagClassifier(span, headerTags);
        }

        public ResponseHeaderTagClassifier(AgentSpan span, Map<String, String> headerTags) {
            this.span = span;
            this.headerTags = headerTags;
        }

        @Override
        public boolean accept(String key, String value) {
            String mappedKey = this.headerTags.get(key.toLowerCase());
            if (mappedKey != null) {
                this.span.setTag(mappedKey, value);
            }
            return true;
        }
    }

    private static final class IGKeyClassifier
    implements AgentPropagation.KeyClassifier {
        private final RequestContext requestContext;
        private final TriConsumer<RequestContext, String, String> headerCallback;
        private final Function<RequestContext, Flow<Void>> doneCallback;

        private static IGKeyClassifier create(RequestContext requestContext, TriConsumer<RequestContext, String, String> headerCallback, Function<RequestContext, Flow<Void>> doneCallback) {
            if (null == requestContext || null == headerCallback) {
                return null;
            }
            return new IGKeyClassifier(requestContext, headerCallback, doneCallback);
        }

        private IGKeyClassifier(RequestContext requestContext, TriConsumer<RequestContext, String, String> headerCallback, Function<RequestContext, Flow<Void>> doneCallback) {
            this.requestContext = requestContext;
            this.headerCallback = headerCallback;
            this.doneCallback = doneCallback;
        }

        @Override
        public boolean accept(String key, String value) {
            this.headerCallback.accept(this.requestContext, key, value);
            return true;
        }

        public Flow<Void> done() {
            if (null != this.doneCallback) {
                return this.doneCallback.apply(this.requestContext);
            }
            return Flow.ResultFlow.empty();
        }
    }
}

