/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.trace.api.Config;
import datadog.trace.api.civisibility.InstrumentationBridge;
import datadog.trace.api.civisibility.codeowners.Codeowners;
import datadog.trace.api.civisibility.source.MethodLinesResolver;
import datadog.trace.api.civisibility.source.SourcePathResolver;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.InternalSpanTypes;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.bootstrap.instrumentation.decorator.BaseDecorator;
import datadog.trace.util.Strings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class TestDecorator
extends BaseDecorator {
    public static final String TEST_TYPE = "test";
    public static final String TEST_PASS = "pass";
    public static final String TEST_FAIL = "fail";
    public static final String TEST_SKIP = "skip";
    public static final UTF8BytesString CIAPP_TEST_ORIGIN = UTF8BytesString.create("ciapp-test");

    public boolean isCI() {
        return InstrumentationBridge.isCi();
    }

    public Map<String, String> getCiTags() {
        return InstrumentationBridge.getCiTags();
    }

    protected abstract String testFramework();

    protected String testType() {
        return TEST_TYPE;
    }

    protected String spanKind() {
        return TEST_TYPE;
    }

    protected String runtimeName() {
        return System.getProperty("java.runtime.name");
    }

    protected String runtimeVendor() {
        return System.getProperty("java.vendor");
    }

    protected String runtimeVersion() {
        return System.getProperty("java.version");
    }

    protected String osArch() {
        return System.getProperty("os.arch");
    }

    protected String osPlatform() {
        return System.getProperty("os.name");
    }

    protected String osVersion() {
        return System.getProperty("os.version");
    }

    protected UTF8BytesString origin() {
        return CIAPP_TEST_ORIGIN;
    }

    @Override
    protected CharSequence spanType() {
        return InternalSpanTypes.TEST;
    }

    @Override
    public AgentSpan afterStart(AgentSpan span) {
        span.setTag("span.kind", this.spanKind());
        span.setTag("test.framework", this.testFramework());
        span.setTag("test.type", this.testType());
        span.setSamplingPriority(1);
        span.setTag("runtime.name", this.runtimeName());
        span.setTag("runtime.vendor", this.runtimeVendor());
        span.setTag("runtime.version", this.runtimeVersion());
        span.setTag("os.architecture", this.osArch());
        span.setTag("os.platform", this.osPlatform());
        span.setTag("os.version", this.osVersion());
        span.setTag("_dd.origin", CIAPP_TEST_ORIGIN);
        Map<String, String> ciTags = InstrumentationBridge.getCiTags();
        for (Map.Entry<String, String> ciTag : ciTags.entrySet()) {
            span.setTag(ciTag.getKey(), ciTag.getValue());
        }
        return super.afterStart(span);
    }

    protected AgentSpan afterTestStart(AgentSpan span, String testSuiteName, String testName, String testParameters, String version, Class<?> testClass, Method testMethod) {
        span.setResourceName(testSuiteName + "." + testName);
        span.setTag("test.suite", testSuiteName);
        span.setTag("test.name", testName);
        if (testParameters != null) {
            span.setTag("test.parameters", testParameters);
        }
        if (version != null) {
            span.setTag("test.framework_version", version);
        }
        if (Config.get().isCiVisibilitySourceDataEnabled()) {
            this.populateSourceDataTags(span, testClass, testMethod);
        }
        return this.afterStart(span);
    }

    private void populateSourceDataTags(AgentSpan span, Class<?> testClass, Method testMethod) {
        Codeowners codeowners;
        Collection<String> testCodeOwners;
        MethodLinesResolver methodLinesResolver;
        MethodLinesResolver.MethodLines testMethodLines;
        if (testClass == null) {
            return;
        }
        SourcePathResolver sourcePathResolver = InstrumentationBridge.getSourcePathResolver();
        String sourcePath = sourcePathResolver.getSourcePath(testClass);
        if (sourcePath == null || sourcePath.isEmpty()) {
            return;
        }
        span.setTag("test.source.file", sourcePath);
        if (testMethod != null && (testMethodLines = (methodLinesResolver = InstrumentationBridge.getMethodLinesResolver()).getLines(testMethod)).isValid()) {
            span.setTag("test.source.start", testMethodLines.getStartLineNumber());
            span.setTag("test.source.end", testMethodLines.getFinishLineNumber());
        }
        if ((testCodeOwners = (codeowners = InstrumentationBridge.getCodeowners()).getOwners(sourcePath)) != null) {
            span.setTag("test.codeowners", Strings.toJson(testCodeOwners));
        }
    }

    public List<Method> testMethods(Class<?> testClass, Class<? extends Annotation> testAnnotation) {
        Method[] methods;
        ArrayList<Method> testMethods = new ArrayList<Method>();
        for (Method method : methods = testClass.getMethods()) {
            if (method.getAnnotation(testAnnotation) == null) continue;
            testMethods.add(method);
        }
        return testMethods;
    }

    public boolean isTestSpan(AgentSpan activeSpan) {
        if (activeSpan == null) {
            return false;
        }
        return this.spanKind().equals(activeSpan.getSpanType()) && this.testType().equals(activeSpan.getTag("test.type"));
    }
}

