/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator.http;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.interceptor.MutableSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.decorator.http.utils.IPAddressUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.function.Function;

public class ClientIpAddressResolver {
    private static final Logger log = LoggerFactory.getLogger(ClientIpAddressResolver.class);
    private static final Function<String, InetAddress> PLAIN_IP_ADDRESS_PARSER = new ParsePlainIpAddress();
    private static final Function<String, InetAddress> FORWARDED_PARSER = new ParseForwarded();
    private static final Function<String, InetAddress> VIA_PARSER = new ParseVia();
    private static final int BIT_X_FORWARDED_FOR = 1;
    private static final int BIT_X_REAL_IP = 2;
    private static final int BIT_CLIENT_IP = 4;
    private static final int BIT_X_FORWARDED = 8;
    private static final int BIT_X_CLUSTER_CLIENT_IP = 16;
    private static final int BIT_FORWARDED_FOR = 32;
    private static final int BIT_FORWARDED = 64;
    private static final int BIT_VIA = 128;
    private static final int BIT_TRUE_CLIENT_IP = 256;
    private static final byte[] PRIVATE_IPV4_RANGES = new byte[]{10, 0, 0, 0, -1, 0, 0, 0, -84, 16, 0, 0, -1, -16, 0, 0, -64, -88, 0, 0, -1, -1, 0, 0, 127, 0, 0, 0, -1, 0, 0, 0, -87, -2, 0, 0, -1, -1, 0, 0};
    private static final int PRIVATE_IPV4_RANGES_SIZE = PRIVATE_IPV4_RANGES.length / 8;
    private static final byte[] PRIVATE_IPV6_RANGES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int PRIVATE_IPV6_RANGES_SIZE = PRIVATE_IPV4_RANGES.length / 32;

    public static InetAddress resolve(AgentSpan.Context.Extracted context, MutableSpan span) {
        try {
            return ClientIpAddressResolver.doResolve(context, span);
        }
        catch (RuntimeException rte) {
            log.warn("Unexpected exception (bug) inferring client IP address", rte);
            return null;
        }
    }

    private static InetAddress doResolve(AgentSpan.Context.Extracted context, MutableSpan span) {
        if (context == null) {
            return null;
        }
        String customIpHeader = context.getCustomIpHeader();
        if (customIpHeader != null) {
            InetAddress result = ClientIpAddressResolver.tryHeader(customIpHeader, FORWARDED_PARSER);
            if (result != null) {
                return result;
            }
            result = ClientIpAddressResolver.tryHeader(customIpHeader, PLAIN_IP_ADDRESS_PARSER);
            if (result != null) {
                return result;
            }
            return null;
        }
        int foundHeaders = 0;
        InetAddress result = null;
        InetAddress addr = ClientIpAddressResolver.tryHeader(context.getXForwardedFor(), PLAIN_IP_ADDRESS_PARSER);
        if (addr != null) {
            foundHeaders |= 1;
            result = addr;
        }
        if ((addr = ClientIpAddressResolver.tryHeader(context.getXRealIp(), PLAIN_IP_ADDRESS_PARSER)) != null) {
            foundHeaders |= 2;
            result = ClientIpAddressResolver.preferPublic(result, addr);
        }
        if ((addr = ClientIpAddressResolver.tryHeader(context.getClientIp(), PLAIN_IP_ADDRESS_PARSER)) != null) {
            foundHeaders |= 4;
            result = ClientIpAddressResolver.preferPublic(result, addr);
        }
        if ((addr = ClientIpAddressResolver.tryHeader(context.getXForwarded(), FORWARDED_PARSER)) != null) {
            foundHeaders |= 8;
            result = ClientIpAddressResolver.preferPublic(result, addr);
        }
        if ((addr = ClientIpAddressResolver.tryHeader(context.getXClusterClientIp(), PLAIN_IP_ADDRESS_PARSER)) != null) {
            foundHeaders |= 0x10;
            result = ClientIpAddressResolver.preferPublic(result, addr);
        }
        if ((addr = ClientIpAddressResolver.tryHeader(context.getForwardedFor(), PLAIN_IP_ADDRESS_PARSER)) != null) {
            foundHeaders |= 0x20;
            result = ClientIpAddressResolver.preferPublic(result, addr);
        }
        if ((addr = ClientIpAddressResolver.tryHeader(context.getForwarded(), FORWARDED_PARSER)) != null) {
            foundHeaders |= 0x40;
            result = ClientIpAddressResolver.preferPublic(result, addr);
        }
        if ((addr = ClientIpAddressResolver.tryHeader(context.getVia(), VIA_PARSER)) != null) {
            foundHeaders |= 0x80;
            result = ClientIpAddressResolver.preferPublic(result, addr);
        }
        if ((addr = ClientIpAddressResolver.tryHeader(context.getTrueClientIp(), PLAIN_IP_ADDRESS_PARSER)) != null) {
            foundHeaders |= 0x100;
            result = ClientIpAddressResolver.preferPublic(result, addr);
        }
        ClientIpAddressResolver.reportMultipleHeaders(foundHeaders, span);
        return result;
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    private static void reportMultipleHeaders(int foundHeaders, MutableSpan span) {
        if (Integer.bitCount(foundHeaders) <= 1) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        while (foundHeaders != 0) {
            int bit = Integer.highestOneBit(foundHeaders);
            switch (bit) {
                case 1: {
                    sb.append("x-forward-for,");
                    break;
                }
                case 2: {
                    sb.append("x-real-ip,");
                    break;
                }
                case 4: {
                    sb.append("client-ip,");
                    break;
                }
                case 8: {
                    sb.append("x-forwarded,");
                    break;
                }
                case 16: {
                    sb.append("x-cluster-client-ip,");
                    break;
                }
                case 32: {
                    sb.append("forwarded-for,");
                    break;
                }
                case 64: {
                    sb.append("forwarded,");
                    break;
                }
                case 128: {
                    sb.append("via,");
                    break;
                }
                case 256: {
                    sb.append("true-client-ip,");
                }
            }
            foundHeaders ^= bit;
        }
        sb.setLength(sb.length() - 1);
        span.setTag("_dd.multiple-ip-headers", sb.toString());
    }

    private static InetAddress preferPublic(InetAddress prevAddr, InetAddress newAddr) {
        if (prevAddr == null || ClientIpAddressResolver.isIpAddrPrivate(prevAddr)) {
            return newAddr;
        }
        return prevAddr;
    }

    private static InetAddress tryHeader(String headerValue, Function<String, InetAddress> parseFun) {
        if (headerValue == null || headerValue.isEmpty()) {
            return null;
        }
        return parseFun.apply(headerValue);
    }

    public static boolean isIpAddrPrivate(InetAddress ipAddr) {
        block3: {
            block2: {
                if (!(ipAddr instanceof Inet4Address)) break block2;
                byte[] addr = ipAddr.getAddress();
                for (int i = 0; i < PRIVATE_IPV4_RANGES_SIZE; ++i) {
                    if (!ClientIpAddressResolver.matchesPrivateRange4(addr, i)) continue;
                    return true;
                }
                break block3;
            }
            if (!(ipAddr instanceof Inet6Address)) break block3;
            byte[] addr = ipAddr.getAddress();
            for (int i = 0; i < PRIVATE_IPV6_RANGES_SIZE; ++i) {
                if (!ClientIpAddressResolver.matchesPrivateRange6(addr, i)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean matchesPrivateRange4(byte[] addr, int n) {
        byte[] maskedAddr = new byte[]{(byte)(addr[0] & PRIVATE_IPV4_RANGES[n * 8 + 4]), (byte)(addr[1] & PRIVATE_IPV4_RANGES[n * 8 + 5]), (byte)(addr[2] & PRIVATE_IPV4_RANGES[n * 8 + 6]), (byte)(addr[3] & PRIVATE_IPV4_RANGES[n * 8 + 7])};
        return maskedAddr[0] == PRIVATE_IPV4_RANGES[n * 8] && maskedAddr[1] == PRIVATE_IPV4_RANGES[n * 8 + 1] && maskedAddr[2] == PRIVATE_IPV4_RANGES[n * 8 + 2] && maskedAddr[3] == PRIVATE_IPV4_RANGES[n * 8 + 3];
    }

    private static boolean matchesPrivateRange6(byte[] addr, int n) {
        int base = n * 32;
        byte[] maskedAddr = new byte[]{(byte)(addr[0] & PRIVATE_IPV6_RANGES[base + 16]), (byte)(addr[1] & PRIVATE_IPV6_RANGES[base + 17]), (byte)(addr[2] & PRIVATE_IPV6_RANGES[base + 18]), (byte)(addr[3] & PRIVATE_IPV6_RANGES[base + 19]), (byte)(addr[4] & PRIVATE_IPV6_RANGES[base + 20]), (byte)(addr[5] & PRIVATE_IPV6_RANGES[base + 21]), (byte)(addr[6] & PRIVATE_IPV6_RANGES[base + 22]), (byte)(addr[7] & PRIVATE_IPV6_RANGES[base + 23]), (byte)(addr[8] & PRIVATE_IPV6_RANGES[base + 24]), (byte)(addr[9] & PRIVATE_IPV6_RANGES[base + 25]), (byte)(addr[10] & PRIVATE_IPV6_RANGES[base + 26]), (byte)(addr[11] & PRIVATE_IPV6_RANGES[base + 27]), (byte)(addr[12] & PRIVATE_IPV6_RANGES[base + 28]), (byte)(addr[13] & PRIVATE_IPV6_RANGES[base + 29]), (byte)(addr[14] & PRIVATE_IPV6_RANGES[base + 30]), (byte)(addr[15] & PRIVATE_IPV6_RANGES[base + 31])};
        return maskedAddr[0] == PRIVATE_IPV6_RANGES[base] && maskedAddr[1] == PRIVATE_IPV6_RANGES[base + 1] && maskedAddr[2] == PRIVATE_IPV6_RANGES[base + 2] && maskedAddr[3] == PRIVATE_IPV6_RANGES[base + 3] && maskedAddr[4] == PRIVATE_IPV6_RANGES[base + 4] && maskedAddr[5] == PRIVATE_IPV6_RANGES[base + 5] && maskedAddr[6] == PRIVATE_IPV6_RANGES[base + 6] && maskedAddr[7] == PRIVATE_IPV6_RANGES[base + 7] && maskedAddr[8] == PRIVATE_IPV6_RANGES[base + 8] && maskedAddr[9] == PRIVATE_IPV6_RANGES[base + 9] && maskedAddr[10] == PRIVATE_IPV6_RANGES[base + 10] && maskedAddr[11] == PRIVATE_IPV6_RANGES[base + 11] && maskedAddr[12] == PRIVATE_IPV6_RANGES[base + 12] && maskedAddr[13] == PRIVATE_IPV6_RANGES[base + 13] && maskedAddr[14] == PRIVATE_IPV6_RANGES[base + 14] && maskedAddr[15] == PRIVATE_IPV6_RANGES[base + 15];
    }

    private static InetAddress parseIpAddressAndMaybePort(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        if (str.charAt(0) == '[') {
            int posClose = str.indexOf(93, 1);
            if (posClose == -1) {
                return null;
            }
            return ClientIpAddressResolver.parseIpAddress(str.substring(1, posClose));
        }
        int posColon = str.indexOf(58);
        if (posColon == -1) {
            return ClientIpAddressResolver.parseIpAddress(str);
        }
        return ClientIpAddressResolver.parseIpAddress(str.substring(0, posColon));
    }

    public static InetAddress parseIpAddress(String str) {
        if (str.length() == 0) {
            return null;
        }
        char firstChar = str.charAt(0);
        if ((firstChar < '0' || firstChar > '9') && firstChar != ':') {
            return null;
        }
        try {
            byte[] addr = IPAddressUtil.textToNumericFormatV4(str);
            if (addr == null) {
                addr = IPAddressUtil.textToNumericFormatV6(str);
            }
            return InetAddress.getByAddress(str, addr);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private static class ParseForwarded
    implements Function<String, InetAddress> {
        private ParseForwarded() {
        }

        @Override
        public InetAddress apply(String headerValue) {
            InetAddress resultPrivate = null;
            ForwardedParseState state = ForwardedParseState.BETWEEN;
            int end = headerValue.length();
            int start = 0;
            boolean considerValue = false;
            block7: for (int pos = 0; pos < end; ++pos) {
                char c = headerValue.charAt(pos);
                switch (state) {
                    case BETWEEN: {
                        if (c == ' ' || c == ';' || c == ',') continue block7;
                        start = pos;
                        state = ForwardedParseState.KEY;
                        continue block7;
                    }
                    case KEY: {
                        if (c != '=') continue block7;
                        state = ForwardedParseState.BEFORE_VALUE;
                        if (pos - start == 3) {
                            String key = headerValue.substring(start, pos);
                            considerValue = key.equalsIgnoreCase("for");
                            continue block7;
                        }
                        considerValue = false;
                        continue block7;
                    }
                    case BEFORE_VALUE: {
                        if (c == '\"') {
                            start = pos + 1;
                            state = ForwardedParseState.VALUE_QUOTED;
                            continue block7;
                        }
                        if (c == ' ' || c == ';' || c == ',') {
                            state = ForwardedParseState.BETWEEN;
                            continue block7;
                        }
                        start = pos;
                        state = ForwardedParseState.VALUE_TOKEN;
                        continue block7;
                    }
                    case VALUE_TOKEN: {
                        InetAddress ipAddr;
                        int tokenEnd;
                        if (c == ' ' || c == ';' || c == ',') {
                            tokenEnd = pos;
                        } else {
                            if (pos + 1 != end) continue block7;
                            tokenEnd = end;
                        }
                        if (considerValue && (ipAddr = ClientIpAddressResolver.parseIpAddressAndMaybePort(headerValue.substring(start, tokenEnd))) != null) {
                            if (ClientIpAddressResolver.isIpAddrPrivate(ipAddr)) {
                                if (resultPrivate == null) {
                                    resultPrivate = ipAddr;
                                }
                            } else {
                                return ipAddr;
                            }
                        }
                        state = ForwardedParseState.BETWEEN;
                        continue block7;
                    }
                    case VALUE_QUOTED: {
                        if (c == '\"') {
                            InetAddress ipAddr;
                            if (considerValue && (ipAddr = ClientIpAddressResolver.parseIpAddressAndMaybePort(headerValue.substring(start, pos))) != null && !ClientIpAddressResolver.isIpAddrPrivate(ipAddr)) {
                                return ipAddr;
                            }
                            state = ForwardedParseState.BETWEEN;
                            continue block7;
                        }
                        if (c != '\\') continue block7;
                        ++pos;
                    }
                }
            }
            return resultPrivate;
        }

        static enum ForwardedParseState {
            KEY,
            BEFORE_VALUE,
            VALUE_TOKEN,
            VALUE_QUOTED,
            BETWEEN;

        }
    }

    private static class ParsePlainIpAddress
    implements Function<String, InetAddress> {
        private ParsePlainIpAddress() {
        }

        @Override
        public InetAddress apply(String str) {
            InetAddress result = null;
            InetAddress resultPrivate = null;
            int pos = 0;
            int end = str.length();
            while (true) {
                if (pos < end && str.charAt(pos) == ' ') {
                    ++pos;
                    continue;
                }
                int posComma = str.indexOf(44, pos);
                int endCur = posComma != -1 ? posComma : end;
                InetAddress addr = ClientIpAddressResolver.parseIpAddress(str.substring(pos, endCur));
                if (addr != null) {
                    if (ClientIpAddressResolver.isIpAddrPrivate(addr)) {
                        if (resultPrivate == null) {
                            resultPrivate = addr;
                        }
                    } else {
                        result = addr;
                    }
                }
                int n = pos = posComma != -1 && posComma + 1 < end ? posComma + 1 : -1;
                if (result != null || pos == -1) break;
            }
            return result != null ? result : resultPrivate;
        }
    }

    private static class ParseVia
    implements Function<String, InetAddress> {
        private ParseVia() {
        }

        @Override
        public InetAddress apply(String str) {
            int pos = 0;
            int end = str.length();
            InetAddress result = null;
            InetAddress resultPrivate = null;
            do {
                int posComma;
                int endCur;
                if ((pos = ParseVia.skipWs(str, pos, endCur = (posComma = str.indexOf(44, pos)) == -1 ? end : posComma)) != endCur) {
                    InetAddress addr;
                    pos = ParseVia.skipNonWs(str, pos, endCur);
                    if ((pos = ParseVia.skipWs(str, pos, endCur)) != endCur && (addr = ClientIpAddressResolver.parseIpAddressAndMaybePort(str.substring(pos, endCur = ParseVia.skipNonWs(str, pos, endCur)))) != null) {
                        if (ClientIpAddressResolver.isIpAddrPrivate(addr)) {
                            if (resultPrivate == null) {
                                resultPrivate = addr;
                            }
                        } else {
                            result = addr;
                        }
                    }
                }
                int n = pos = posComma != -1 && posComma + 1 < end ? posComma + 1 : -1;
            } while (result == null && pos != -1);
            return result != null ? result : resultPrivate;
        }

        private static int skipNonWs(String str, int pos, int endCur) {
            char c;
            while (pos < endCur && (c = str.charAt(pos)) != ' ' && c != '\t') {
                ++pos;
            }
            return pos;
        }

        private static int skipWs(String str, int pos, int endCur) {
            char c;
            while (pos < endCur && ((c = str.charAt(pos)) == ' ' || c == '\t')) {
                ++pos;
            }
            return pos;
        }
    }
}

