/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.util;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Platform;
import datadog.trace.util.Strings;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.lang.management.ManagementFactory;
import java.util.function.Supplier;

@SuppressForbidden
public final class PidHelper {
    private static final Logger log = LoggerFactory.getLogger(PidHelper.class);
    private static final String PID = PidHelper.findPid();
    private static final long PID_AS_LONG = PidHelper.parsePid();

    public static String getPid() {
        return PID;
    }

    public static long getPidAsLong() {
        return PID_AS_LONG;
    }

    private static String findPid() {
        String pid = "";
        if (Platform.isJavaVersionAtLeast(9)) {
            try {
                pid = Strings.trim((String)((Supplier)Class.forName("datadog.trace.util.JDK9PidSupplier").getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).get());
            }
            catch (Throwable e) {
                log.debug("JDK9PidSupplier not available", e);
            }
        }
        if (pid.isEmpty()) {
            try {
                String vmId = ManagementFactory.getRuntimeMXBean().getName();
                int pidEnd = vmId.indexOf(64);
                if (pidEnd > 0) {
                    pid = vmId.substring(0, pidEnd).trim();
                }
            }
            catch (Throwable e) {
                log.debug("Process id not available", e);
            }
        }
        return pid;
    }

    private static long parsePid() {
        if (!PID.isEmpty()) {
            try {
                return Long.parseLong(PID);
            }
            catch (NumberFormatException e) {
                log.warn("Cannot parse PID {} as number. Default to 0", (Object)PID, (Object)e);
            }
        }
        return 0L;
    }
}

