/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal;

import android.app.Application;
import android.content.Context;
import androidx.annotation.AnyThread;
import androidx.annotation.WorkerThread;
import com.datadog.android.Datadog;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.context.NetworkInfo;
import com.datadog.android.api.context.TimeInfo;
import com.datadog.android.api.context.UserInfo;
import com.datadog.android.api.feature.Feature;
import com.datadog.android.api.feature.FeatureContextUpdateReceiver;
import com.datadog.android.api.feature.FeatureEventReceiver;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.core.InternalSdkCore;
import com.datadog.android.core.configuration.BatchSize;
import com.datadog.android.core.configuration.Configuration;
import com.datadog.android.core.configuration.UploadFrequency;
import com.datadog.android.core.internal.ContextProvider;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.DatadogCore;
import com.datadog.android.core.internal.SdkFeature;
import com.datadog.android.core.internal.lifecycle.ProcessLifecycleCallback;
import com.datadog.android.core.internal.lifecycle.ProcessLifecycleMonitor;
import com.datadog.android.core.internal.net.FirstPartyHostHeaderTypeResolver;
import com.datadog.android.core.internal.system.BuildSdkVersionProvider;
import com.datadog.android.core.internal.time.DefaultAppStartTimeProvider;
import com.datadog.android.core.internal.time.TimeProvider;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import com.datadog.android.core.thread.FlushableExecutorService;
import com.datadog.android.error.internal.CrashReportsFeature;
import com.datadog.android.ndk.internal.NdkCrashHandler;
import com.datadog.android.privacy.TrackingConsent;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u0000 \u0093\u00012\u00020\u0001:\u0002\u0093\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010R\u001a\u00020S2\u0014\u0010T\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010V0UH\u0017J\u001c\u0010W\u001a\u00020S2\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020V0UH\u0002J\b\u0010Y\u001a\u00020SH\u0017J\u0010\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020\u0005H\u0016J\u0010\u0010]\u001a\u00020^2\u0006\u0010\\\u001a\u00020\u0005H\u0016J\b\u0010_\u001a\u00020SH\u0017J\r\u0010`\u001a\u00020SH\u0001\u00a2\u0006\u0002\baJ\u000e\u0010b\u001a\b\u0012\u0004\u0012\u00020d0cH\u0016J\n\u0010e\u001a\u0004\u0018\u00010fH\u0016J\u0012\u0010g\u001a\u0004\u0018\u00010d2\u0006\u0010h\u001a\u00020\u0005H\u0016J\u001e\u0010i\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010V0U2\u0006\u0010h\u001a\u00020\u0005H\u0016J\b\u0010j\u001a\u00020^H\u0016J\u0015\u0010k\u001a\u00020S2\u0006\u0010l\u001a\u00020mH\u0000\u00a2\u0006\u0002\bnJ\b\u0010o\u001a\u00020SH\u0002J\u0010\u0010p\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010q\u001a\u00020/2\u0006\u0010r\u001a\u00020\u0005H\u0002J\u0010\u0010s\u001a\u00020m2\u0006\u0010l\u001a\u00020mH\u0002J\u0010\u0010t\u001a\u00020S2\u0006\u0010u\u001a\u00020vH\u0016J\u0018\u0010w\u001a\u00020S2\u0006\u0010h\u001a\u00020\u00052\u0006\u0010x\u001a\u00020yH\u0016J\u0010\u0010z\u001a\u00020S2\u0006\u0010h\u001a\u00020\u0005H\u0016J\b\u0010{\u001a\u00020SH\u0002J\u0010\u0010|\u001a\u00020S2\u0006\u0010l\u001a\u00020mH\u0002J\u0018\u0010}\u001a\u00020S2\u0006\u0010h\u001a\u00020\u00052\u0006\u0010x\u001a\u00020yH\u0016J\u0019\u0010~\u001a\u00020S2\u0006\u0010h\u001a\u00020\u00052\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0016J\u0012\u0010\u0081\u0001\u001a\u00020S2\u0007\u0010\u0082\u0001\u001a\u00020OH\u0017J?\u0010\u0083\u0001\u001a\u00020S2\t\u0010\u0084\u0001\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\t\u0010\u0085\u0001\u001a\u0004\u0018\u00010\u00052\u0014\u0010T\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010V0UH\u0017J\u0012\u0010\u0086\u0001\u001a\u00020S2\u0007\u0010\u0087\u0001\u001a\u00020\u0003H\u0002J\t\u0010\u0088\u0001\u001a\u00020SH\u0002J\u000f\u0010\u0089\u0001\u001a\u00020SH\u0000\u00a2\u0006\u0003\b\u008a\u0001JD\u0010\u008b\u0001\u001a\u00020S2\u0006\u0010h\u001a\u00020\u000521\u0010\u008c\u0001\u001a,\u0012\"\u0012 \u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010V0!\u00a2\u0006\r\b\u008d\u0001\u0012\b\b\u0006\u0012\u0004\b\b(\u0002\u0012\u0004\u0012\u00020S0\bH\u0016J\u0012\u0010\u008e\u0001\u001a\u00020S2\u0007\u0010\u008f\u0001\u001a\u00020\u0011H\u0017J\u0013\u0010\u0090\u0001\u001a\u00020S2\b\u0010\u0091\u0001\u001a\u00030\u0092\u0001H\u0017R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\"0!X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020/8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u001e\u00103\u001a\u00020/2\u0006\u00102\u001a\u00020/@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00101R\u0016\u00104\u001a\u0004\u0018\u00010\u00118WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0016\u00107\u001a\u0004\u0018\u0001088WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010*R\u0014\u0010<\u001a\u00020=8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0010\u0010@\u001a\u0004\u0018\u00010AX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010B\u001a\u00020C8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u0014\u0010F\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010*R\u000e\u0010H\u001a\u00020IX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010J\u001a\u00020K8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010MR\u0014\u0010N\u001a\u00020O8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010Q\u00a8\u0006\u0094\u0001"}, d2={"Lcom/datadog/android/core/internal/DatadogCore;", "Lcom/datadog/android/core/InternalSdkCore;", "context", "Landroid/content/Context;", "instanceId", "", "name", "internalLoggerProvider", "Lkotlin/Function1;", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "Lcom/datadog/android/api/InternalLogger;", "executorServiceFactory", "Lcom/datadog/android/core/thread/FlushableExecutorService$Factory;", "buildSdkVersionProvider", "Lcom/datadog/android/core/internal/system/BuildSdkVersionProvider;", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lcom/datadog/android/core/thread/FlushableExecutorService$Factory;Lcom/datadog/android/core/internal/system/BuildSdkVersionProvider;)V", "appStartTimeNs", "", "getAppStartTimeNs", "()J", "getContext$dd_sdk_android_core_release", "()Landroid/content/Context;", "contextProvider", "Lcom/datadog/android/core/internal/ContextProvider;", "getContextProvider$dd_sdk_android_core_release", "()Lcom/datadog/android/core/internal/ContextProvider;", "coreFeature", "Lcom/datadog/android/core/internal/CoreFeature;", "getCoreFeature$dd_sdk_android_core_release", "()Lcom/datadog/android/core/internal/CoreFeature;", "setCoreFeature$dd_sdk_android_core_release", "(Lcom/datadog/android/core/internal/CoreFeature;)V", "features", "", "Lcom/datadog/android/core/internal/SdkFeature;", "getFeatures$dd_sdk_android_core_release", "()Ljava/util/Map;", "firstPartyHostResolver", "Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "getFirstPartyHostResolver", "()Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "getInstanceId$dd_sdk_android_core_release", "()Ljava/lang/String;", "internalLogger", "getInternalLogger", "()Lcom/datadog/android/api/InternalLogger;", "isActive", "", "isActive$dd_sdk_android_core_release", "()Z", "<set-?>", "isDeveloperModeEnabled", "lastFatalAnrSent", "getLastFatalAnrSent", "()Ljava/lang/Long;", "lastViewEvent", "Lcom/google/gson/JsonObject;", "getLastViewEvent", "()Lcom/google/gson/JsonObject;", "getName", "networkInfo", "Lcom/datadog/android/api/context/NetworkInfo;", "getNetworkInfo", "()Lcom/datadog/android/api/context/NetworkInfo;", "processLifecycleMonitor", "Lcom/datadog/android/core/internal/lifecycle/ProcessLifecycleMonitor;", "rootStorageDir", "Ljava/io/File;", "getRootStorageDir", "()Ljava/io/File;", "service", "getService", "shutdownHook", "Ljava/lang/Thread;", "time", "Lcom/datadog/android/api/context/TimeInfo;", "getTime", "()Lcom/datadog/android/api/context/TimeInfo;", "trackingConsent", "Lcom/datadog/android/privacy/TrackingConsent;", "getTrackingConsent", "()Lcom/datadog/android/privacy/TrackingConsent;", "addUserProperties", "", "extraInfo", "", "", "applyAdditionalConfiguration", "additionalConfiguration", "clearAllData", "createScheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "executorContext", "createSingleThreadExecutorService", "Ljava/util/concurrent/ExecutorService;", "deleteLastViewEvent", "flushStoredData", "flushStoredData$dd_sdk_android_core_release", "getAllFeatures", "", "Lcom/datadog/android/api/feature/FeatureScope;", "getDatadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "getFeature", "featureName", "getFeatureContext", "getPersistenceExecutorService", "initialize", "configuration", "Lcom/datadog/android/core/configuration/Configuration;", "initialize$dd_sdk_android_core_release", "initializeCrashReportFeature", "isAppDebuggable", "isEnvironmentNameValid", "envName", "modifyConfigurationForDeveloperDebug", "registerFeature", "feature", "Lcom/datadog/android/api/feature/Feature;", "removeContextUpdateReceiver", "listener", "Lcom/datadog/android/api/feature/FeatureContextUpdateReceiver;", "removeEventReceiver", "removeShutdownHook", "sendCoreConfigurationTelemetryEvent", "setContextUpdateReceiver", "setEventReceiver", "receiver", "Lcom/datadog/android/api/feature/FeatureEventReceiver;", "setTrackingConsent", "consent", "setUserInfo", "id", "email", "setupLifecycleMonitorCallback", "appContext", "setupShutdownHook", "stop", "stop$dd_sdk_android_core_release", "updateFeatureContext", "updateCallback", "Lkotlin/ParameterName;", "writeLastFatalAnrSent", "anrTimestamp", "writeLastViewEvent", "data", "", "Companion", "dd-sdk-android-core_release"})
@SourceDebugExtension(value={"SMAP\nDatadogCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatadogCore.kt\ncom/datadog/android/core/internal/DatadogCore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,594:1\n1855#2,2:595\n1855#2,2:608\n515#3:597\n500#3,6:598\n215#4,2:604\n215#4,2:606\n*S KotlinDebug\n*F\n+ 1 DatadogCore.kt\ncom/datadog/android/core/internal/DatadogCore\n*L\n188#1:595,2\n561#1:608,2\n210#1:597\n210#1:598,6\n211#1:604,2\n538#1:606,2\n*E\n"})
public final class DatadogCore
implements InternalSdkCore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String instanceId;
    @NotNull
    private final String name;
    @Nullable
    private final FlushableExecutorService.Factory executorServiceFactory;
    @NotNull
    private final BuildSdkVersionProvider buildSdkVersionProvider;
    public CoreFeature coreFeature;
    private Thread shutdownHook;
    @NotNull
    private final Map<String, SdkFeature> features;
    @NotNull
    private final Context context;
    @Nullable
    private ProcessLifecycleMonitor processLifecycleMonitor;
    @NotNull
    private final InternalLogger internalLogger;
    private boolean isDeveloperModeEnabled;
    @NotNull
    public static final String SHUTDOWN_THREAD_NAME = "datadog_shutdown";
    @NotNull
    public static final String ENV_NAME_VALIDATION_REG_EX = "[a-zA-Z0-9_:./-]{0,195}[a-zA-Z0-9_./-]";
    @NotNull
    public static final String MESSAGE_ENV_NAME_NOT_VALID = "The environment name should contain maximum 196 of the following allowed characters [a-zA-Z0-9_:./-] and should never finish with a semicolon.In this case the Datadog SDK will not be initialised.";
    @NotNull
    public static final String MISSING_FEATURE_FOR_EVENT_RECEIVER = "Cannot add event receiver for feature \"%s\", it is not registered.";
    @NotNull
    public static final String MISSING_FEATURE_FOR_CONTEXT_UPDATE_LISTENER = "Cannot add event listener for feature \"%s\", it is not registered.";
    @NotNull
    public static final String EVENT_RECEIVER_ALREADY_EXISTS = "Feature \"%s\" already has event receiver registered, overwriting it.";
    @NotNull
    public static final String NO_NEED_TO_WRITE_LAST_VIEW_EVENT = "No need to write last RUM view event: NDK crash reports feature is not enabled and API is below 30.";
    private static final long CONFIGURATION_TELEMETRY_DELAY_MS = TimeUnit.SECONDS.toMillis(5L);
    private static final long startupTimeNs = System.nanoTime();

    public DatadogCore(@NotNull Context context, @NotNull String instanceId, @NotNull String name, @NotNull Function1<? super FeatureSdkCore, ? extends InternalLogger> internalLoggerProvider, @Nullable FlushableExecutorService.Factory executorServiceFactory, @NotNull BuildSdkVersionProvider buildSdkVersionProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(internalLoggerProvider, (String)"internalLoggerProvider");
        Intrinsics.checkNotNullParameter((Object)buildSdkVersionProvider, (String)"buildSdkVersionProvider");
        this.instanceId = instanceId;
        this.name = name;
        this.executorServiceFactory = executorServiceFactory;
        this.buildSdkVersionProvider = buildSdkVersionProvider;
        this.features = new ConcurrentHashMap();
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.context = context2;
        this.internalLogger = (InternalLogger)internalLoggerProvider.invoke((Object)this);
    }

    public /* synthetic */ DatadogCore(Context context, String string, String string2, Function1 function1, FlushableExecutorService.Factory factory, BuildSdkVersionProvider buildSdkVersionProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            factory = null;
        }
        if ((n & 0x20) != 0) {
            buildSdkVersionProvider = BuildSdkVersionProvider.Companion.getDEFAULT();
        }
        this(context, string, string2, (Function1<? super FeatureSdkCore, ? extends InternalLogger>)function1, factory, buildSdkVersionProvider);
    }

    @NotNull
    public final String getInstanceId$dd_sdk_android_core_release() {
        return this.instanceId;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final CoreFeature getCoreFeature$dd_sdk_android_core_release() {
        CoreFeature coreFeature = this.coreFeature;
        if (coreFeature != null) {
            return coreFeature;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"coreFeature");
        return null;
    }

    public final void setCoreFeature$dd_sdk_android_core_release(@NotNull CoreFeature coreFeature) {
        Intrinsics.checkNotNullParameter((Object)coreFeature, (String)"<set-?>");
        this.coreFeature = coreFeature;
    }

    @NotNull
    public final Map<String, SdkFeature> getFeatures$dd_sdk_android_core_release() {
        return this.features;
    }

    @NotNull
    public final Context getContext$dd_sdk_android_core_release() {
        return this.context;
    }

    @Nullable
    public final ContextProvider getContextProvider$dd_sdk_android_core_release() {
        return this.getCoreFeature$dd_sdk_android_core_release().getInitialized$dd_sdk_android_core_release().get() ? this.getCoreFeature$dd_sdk_android_core_release().getContextProvider$dd_sdk_android_core_release() : null;
    }

    public final boolean isActive$dd_sdk_android_core_release() {
        return this.getCoreFeature$dd_sdk_android_core_release().getInitialized$dd_sdk_android_core_release().get();
    }

    @Override
    @NotNull
    public TimeInfo getTime() {
        TimeProvider $this$_get_time__u24lambda_u240 = this.getCoreFeature$dd_sdk_android_core_release().getTimeProvider$dd_sdk_android_core_release();
        boolean bl = false;
        long deviceTimeMs = $this$_get_time__u24lambda_u240.getDeviceTimestamp();
        long serverTimeMs = $this$_get_time__u24lambda_u240.getServerTimestamp();
        return new TimeInfo(TimeUnit.MILLISECONDS.toNanos(deviceTimeMs), TimeUnit.MILLISECONDS.toNanos(serverTimeMs), TimeUnit.MILLISECONDS.toNanos(serverTimeMs - deviceTimeMs), serverTimeMs - deviceTimeMs);
    }

    @Override
    @NotNull
    public String getService() {
        return this.getCoreFeature$dd_sdk_android_core_release().getServiceName$dd_sdk_android_core_release();
    }

    @Override
    @NotNull
    public FirstPartyHostHeaderTypeResolver getFirstPartyHostResolver() {
        return this.getCoreFeature$dd_sdk_android_core_release().getFirstPartyHostHeaderTypeResolver$dd_sdk_android_core_release();
    }

    @Override
    @NotNull
    public InternalLogger getInternalLogger() {
        return this.internalLogger;
    }

    @Override
    public boolean isDeveloperModeEnabled() {
        return this.isDeveloperModeEnabled;
    }

    @Override
    public void registerFeature(@NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        SdkFeature sdkFeature = new SdkFeature(this.getCoreFeature$dd_sdk_android_core_release(), feature, this.getInternalLogger());
        this.features.put(feature.getName(), sdkFeature);
        sdkFeature.initialize(this.context, this.instanceId);
        String string = feature.getName();
        if (Intrinsics.areEqual((Object)string, (Object)"logs")) {
            this.getCoreFeature$dd_sdk_android_core_release().getNdkCrashHandler$dd_sdk_android_core_release().handleNdkCrash(this, NdkCrashHandler.ReportTarget.LOGS);
        } else if (Intrinsics.areEqual((Object)string, (Object)"rum")) {
            this.getCoreFeature$dd_sdk_android_core_release().getNdkCrashHandler$dd_sdk_android_core_release().handleNdkCrash(this, NdkCrashHandler.ReportTarget.RUM);
        }
    }

    @Override
    @Nullable
    public FeatureScope getFeature(@NotNull String featureName) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        return this.features.get(featureName);
    }

    @Override
    @AnyThread
    public void setTrackingConsent(@NotNull TrackingConsent consent) {
        Intrinsics.checkNotNullParameter((Object)((Object)consent), (String)"consent");
        this.getCoreFeature$dd_sdk_android_core_release().getTrackingConsentProvider$dd_sdk_android_core_release().setConsent(consent);
    }

    @Override
    @AnyThread
    public void setUserInfo(@Nullable String id, @Nullable String name, @Nullable String email, @NotNull Map<String, ? extends Object> extraInfo) {
        Intrinsics.checkNotNullParameter(extraInfo, (String)"extraInfo");
        this.getCoreFeature$dd_sdk_android_core_release().getUserInfoProvider$dd_sdk_android_core_release().setUserInfo(new UserInfo(id, name, email, extraInfo));
    }

    @Override
    @AnyThread
    public void addUserProperties(@NotNull Map<String, ? extends Object> extraInfo) {
        Intrinsics.checkNotNullParameter(extraInfo, (String)"extraInfo");
        this.getCoreFeature$dd_sdk_android_core_release().getUserInfoProvider$dd_sdk_android_core_release().addUserProperties(extraInfo);
    }

    @Override
    @AnyThread
    public void clearAllData() {
        Iterable $this$forEach$iv = this.features.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SdkFeature it = (SdkFeature)element$iv;
            boolean bl = false;
            it.clearAllData();
        }
        ConcurrencyExtKt.submitSafe(this.getPersistenceExecutorService(), "Clear all data", this.getInternalLogger(), () -> DatadogCore.clearAllData$lambda$2(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void updateFeatureContext(@NotNull String featureName, @NotNull Function1<? super Map<String, Object>, Unit> updateCallback) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter(updateCallback, (String)"updateCallback");
        SdkFeature sdkFeature = this.features.get(featureName);
        if (sdkFeature == null) {
            return;
        }
        SdkFeature feature = sdkFeature;
        ContextProvider contextProvider = this.getContextProvider$dd_sdk_android_core_release();
        if (contextProvider != null) {
            ContextProvider it = contextProvider;
            boolean bl = false;
            SdkFeature sdkFeature2 = feature;
            synchronized (sdkFeature2) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                boolean bl2 = false;
                Map<String, Object> featureContext = it.getFeatureContext(featureName);
                Map mutableContext = MapsKt.toMutableMap(featureContext);
                updateCallback.invoke((Object)mutableContext);
                it.setFeatureContext(featureName, mutableContext);
                Map $this$filter$iv = this.features;
                boolean $i$f$filter = false;
                Object object = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it2 = element$iv$iv = iterator.next();
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual(it2.getKey(), (Object)featureName))) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                $this$filter$iv = destination$iv$iv;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = (Map.Entry)object.next();
                    boolean bl4 = false;
                    SdkFeature feature2 = (SdkFeature)entry.getValue();
                    feature2.notifyContextUpdated$dd_sdk_android_core_release(featureName, MapsKt.toMap((Map)mutableContext));
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Override
    @NotNull
    public Map<String, Object> getFeatureContext(@NotNull String featureName) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Object object = this.getContextProvider$dd_sdk_android_core_release();
        if (object == null || (object = object.getFeatureContext(featureName)) == null) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    @Override
    public void setEventReceiver(@NotNull String featureName, @NotNull FeatureEventReceiver receiver) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        SdkFeature feature = this.features.get(featureName);
        if (feature == null) {
            InternalLogger.DefaultImpls.log$default(this.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, (Function0)new Function0<String>(featureName){
                final /* synthetic */ String $featureName;
                {
                    this.$featureName = $featureName;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Cannot add event receiver for feature \"%s\", it is not registered.";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$featureName};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }, null, false, null, 56, null);
        } else {
            if (feature.getEventReceiver$dd_sdk_android_core_release().get() != null) {
                InternalLogger.DefaultImpls.log$default(this.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, (Function0)new Function0<String>(featureName){
                    final /* synthetic */ String $featureName;
                    {
                        this.$featureName = $featureName;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        String string = "Feature \"%s\" already has event receiver registered, overwriting it.";
                        Locale locale = Locale.US;
                        Object[] objectArray = new Object[]{this.$featureName};
                        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                        return string2;
                    }
                }, null, false, null, 56, null);
            }
            feature.getEventReceiver$dd_sdk_android_core_release().set(receiver);
        }
    }

    @Override
    public void setContextUpdateReceiver(@NotNull String featureName, @NotNull FeatureContextUpdateReceiver listener) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        SdkFeature feature = this.features.get(featureName);
        if (feature == null) {
            InternalLogger.DefaultImpls.log$default(this.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, (Function0)new Function0<String>(featureName){
                final /* synthetic */ String $featureName;
                {
                    this.$featureName = $featureName;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Cannot add event listener for feature \"%s\", it is not registered.";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$featureName};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }, null, false, null, 56, null);
        } else {
            feature.setContextUpdateListener$dd_sdk_android_core_release(listener);
        }
    }

    @Override
    public void removeContextUpdateReceiver(@NotNull String featureName, @NotNull FeatureContextUpdateReceiver listener) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            SdkFeature sdkFeature = this.features.get(featureName);
            if (sdkFeature == null) break block0;
            sdkFeature.removeContextUpdateListener$dd_sdk_android_core_release(listener);
        }
    }

    @Override
    public void removeEventReceiver(@NotNull String featureName) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
            Object object = this.features.get(featureName);
            if (object == null || (object = ((SdkFeature)object).getEventReceiver$dd_sdk_android_core_release()) == null) break block0;
            ((AtomicReference)object).set(null);
        }
    }

    @Override
    @NotNull
    public ExecutorService createSingleThreadExecutorService(@NotNull String executorContext) {
        Intrinsics.checkNotNullParameter((Object)executorContext, (String)"executorContext");
        return this.getCoreFeature$dd_sdk_android_core_release().createExecutorService(executorContext);
    }

    @Override
    @NotNull
    public ScheduledExecutorService createScheduledExecutorService(@NotNull String executorContext) {
        Intrinsics.checkNotNullParameter((Object)executorContext, (String)"executorContext");
        return this.getCoreFeature$dd_sdk_android_core_release().createScheduledExecutorService(executorContext);
    }

    @Override
    @NotNull
    public NetworkInfo getNetworkInfo() {
        return this.getCoreFeature$dd_sdk_android_core_release().getNetworkInfoProvider$dd_sdk_android_core_release().getLatestNetworkInfo();
    }

    @Override
    @NotNull
    public TrackingConsent getTrackingConsent() {
        return this.getCoreFeature$dd_sdk_android_core_release().getTrackingConsentProvider$dd_sdk_android_core_release().getConsent();
    }

    @Override
    @NotNull
    public File getRootStorageDir() {
        return this.getCoreFeature$dd_sdk_android_core_release().getStorageDir$dd_sdk_android_core_release();
    }

    @Override
    @WorkerThread
    @Nullable
    public JsonObject getLastViewEvent() {
        return this.getCoreFeature$dd_sdk_android_core_release().getLastViewEvent$dd_sdk_android_core_release();
    }

    @Override
    @WorkerThread
    @Nullable
    public Long getLastFatalAnrSent() {
        return this.getCoreFeature$dd_sdk_android_core_release().getLastFatalAnrSent$dd_sdk_android_core_release();
    }

    @Override
    public long getAppStartTimeNs() {
        return this.getCoreFeature$dd_sdk_android_core_release().getAppStartTimeNs$dd_sdk_android_core_release();
    }

    @Override
    @WorkerThread
    public void writeLastViewEvent(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.buildSdkVersionProvider.getVersion() >= 30 || this.features.containsKey("ndk-crash-reporting")) {
            this.getCoreFeature$dd_sdk_android_core_release().writeLastViewEvent$dd_sdk_android_core_release(data);
        } else {
            InternalLogger.DefaultImpls.log$default(this.getInternalLogger(), InternalLogger.Level.INFO, InternalLogger.Target.MAINTAINER, (Function0)writeLastViewEvent.1.INSTANCE, null, false, null, 56, null);
        }
    }

    @Override
    @WorkerThread
    public void deleteLastViewEvent() {
        this.getCoreFeature$dd_sdk_android_core_release().deleteLastViewEvent$dd_sdk_android_core_release();
    }

    @Override
    @WorkerThread
    public void writeLastFatalAnrSent(long anrTimestamp) {
        this.getCoreFeature$dd_sdk_android_core_release().writeLastFatalAnrSent$dd_sdk_android_core_release(anrTimestamp);
    }

    @Override
    @NotNull
    public ExecutorService getPersistenceExecutorService() {
        return this.getCoreFeature$dd_sdk_android_core_release().getPersistenceExecutorService$dd_sdk_android_core_release();
    }

    @Override
    @NotNull
    public List<FeatureScope> getAllFeatures() {
        return CollectionsKt.toList((Iterable)this.features.values());
    }

    @Override
    @Nullable
    public DatadogContext getDatadogContext() {
        ContextProvider contextProvider = this.getContextProvider$dd_sdk_android_core_release();
        return contextProvider != null ? contextProvider.getContext() : null;
    }

    public final void initialize$dd_sdk_android_core_release(@NotNull Configuration configuration) {
        FlushableExecutorService.Factory factory;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (!this.isEnvironmentNameValid(configuration.getEnv$dd_sdk_android_core_release())) {
            throw new IllegalArgumentException(MESSAGE_ENV_NAME_NOT_VALID);
        }
        boolean isDebug = this.isAppDebuggable(this.context);
        Configuration mutableConfig = configuration;
        if (isDebug & configuration.getCoreConfig$dd_sdk_android_core_release().getEnableDeveloperModeWhenDebuggable()) {
            mutableConfig = this.modifyConfigurationForDeveloperDebug(configuration);
            this.isDeveloperModeEnabled = true;
            Datadog.setVerbosity(2);
        }
        if ((factory = this.executorServiceFactory) == null) {
            factory = CoreFeature.Companion.getDEFAULT_FLUSHABLE_EXECUTOR_SERVICE_FACTORY$dd_sdk_android_core_release();
        }
        FlushableExecutorService.Factory flushableExecutorServiceFactory = factory;
        this.setCoreFeature$dd_sdk_android_core_release(new CoreFeature(this.getInternalLogger(), new DefaultAppStartTimeProvider(null, 1, null), flushableExecutorServiceFactory, CoreFeature.Companion.getDEFAULT_SCHEDULED_EXECUTOR_SERVICE_FACTORY$dd_sdk_android_core_release()));
        this.getCoreFeature$dd_sdk_android_core_release().initialize(this.context, this.instanceId, mutableConfig, TrackingConsent.PENDING);
        this.applyAdditionalConfiguration(mutableConfig.getAdditionalConfig$dd_sdk_android_core_release());
        if (mutableConfig.getCrashReportsEnabled$dd_sdk_android_core_release()) {
            this.initializeCrashReportFeature();
        }
        this.setupLifecycleMonitorCallback(this.context);
        this.setupShutdownHook();
        this.sendCoreConfigurationTelemetryEvent(configuration);
    }

    private final void initializeCrashReportFeature() {
        CrashReportsFeature crashReportsFeature = new CrashReportsFeature(this);
        this.registerFeature(crashReportsFeature);
    }

    private final Configuration modifyConfigurationForDeveloperDebug(Configuration configuration) {
        return Configuration.copy$default(configuration, Configuration.Core.copy$default(configuration.getCoreConfig$dd_sdk_android_core_release(), false, false, null, BatchSize.SMALL, UploadFrequency.FREQUENT, null, null, null, null, null, null, null, 4071, null), null, null, null, null, false, null, 126, null);
    }

    private final void applyAdditionalConfiguration(Map<String, ? extends Object> additionalConfiguration) {
        block5: {
            Object it;
            Object object = additionalConfiguration.get("_dd.source");
            if (object != null) {
                it = object;
                boolean bl = false;
                if (it instanceof String && !StringsKt.isBlank((CharSequence)((CharSequence)it))) {
                    this.getCoreFeature$dd_sdk_android_core_release().setSourceName$dd_sdk_android_core_release((String)it);
                }
            }
            Object object2 = additionalConfiguration.get("_dd.sdk_version");
            if (object2 != null) {
                it = object2;
                boolean bl = false;
                if (it instanceof String && !StringsKt.isBlank((CharSequence)((CharSequence)it))) {
                    this.getCoreFeature$dd_sdk_android_core_release().setSdkVersion$dd_sdk_android_core_release((String)it);
                }
            }
            Object object3 = additionalConfiguration.get("_dd.version");
            if (object3 == null) break block5;
            it = object3;
            boolean bl = false;
            if (it instanceof String && !StringsKt.isBlank((CharSequence)((CharSequence)it))) {
                this.getCoreFeature$dd_sdk_android_core_release().getPackageVersionProvider$dd_sdk_android_core_release().setVersion((String)it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setupLifecycleMonitorCallback(Context appContext) {
        if (appContext instanceof Application) {
            void $this$setupLifecycleMonitorCallback_u24lambda_u2410;
            ProcessLifecycleMonitor processLifecycleMonitor;
            ProcessLifecycleMonitor processLifecycleMonitor2 = processLifecycleMonitor = new ProcessLifecycleMonitor(new ProcessLifecycleCallback(appContext, this.getInternalLogger()));
            DatadogCore datadogCore = this;
            boolean bl = false;
            ((Application)appContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)$this$setupLifecycleMonitorCallback_u24lambda_u2410);
            datadogCore.processLifecycleMonitor = processLifecycleMonitor;
        }
    }

    private final boolean isEnvironmentNameValid(String envName) {
        CharSequence charSequence = envName;
        return new Regex(ENV_NAME_VALIDATION_REG_EX).matches(charSequence);
    }

    private final boolean isAppDebuggable(Context context) {
        return (context.getApplicationInfo().flags & 2) != 0;
    }

    private final void setupShutdownHook() {
        try {
            Runnable hookRunnable = () -> DatadogCore.setupShutdownHook$lambda$11(this);
            this.shutdownHook = new Thread(hookRunnable, SHUTDOWN_THREAD_NAME);
            Runtime runtime = Runtime.getRuntime();
            Thread thread = this.shutdownHook;
            if (thread == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shutdownHook");
                thread = null;
            }
            runtime.addShutdownHook(thread);
        }
        catch (IllegalStateException e) {
            InternalLogger.DefaultImpls.log$default(this.getInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, (Function0)setupShutdownHook.1.INSTANCE, (Throwable)e, false, null, 48, null);
            this.stop$dd_sdk_android_core_release();
        }
        catch (IllegalArgumentException e) {
            InternalLogger.DefaultImpls.log$default(this.getInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, (Function0)setupShutdownHook.2.INSTANCE, (Throwable)e, false, null, 48, null);
        }
        catch (SecurityException e) {
            InternalLogger.DefaultImpls.log$default(this.getInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, (Function0)setupShutdownHook.3.INSTANCE, (Throwable)e, false, null, 48, null);
        }
    }

    private final void removeShutdownHook() {
        if (this.shutdownHook != null) {
            try {
                Runtime runtime = Runtime.getRuntime();
                Thread thread = this.shutdownHook;
                if (thread == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"shutdownHook");
                    thread = null;
                }
                runtime.removeShutdownHook(thread);
            }
            catch (IllegalStateException e) {
                InternalLogger.DefaultImpls.log$default(this.getInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, (Function0)removeShutdownHook.2.INSTANCE, (Throwable)e, false, null, 48, null);
            }
            catch (SecurityException e) {
                InternalLogger.DefaultImpls.log$default(this.getInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, (Function0)removeShutdownHook.3.INSTANCE, (Throwable)e, false, null, 48, null);
            }
        }
    }

    private final void sendCoreConfigurationTelemetryEvent(Configuration configuration) {
        Runnable runnable = () -> DatadogCore.sendCoreConfigurationTelemetryEvent$lambda$12(this, configuration);
        ConcurrencyExtKt.scheduleSafe(this.getCoreFeature$dd_sdk_android_core_release().getUploadExecutorService$dd_sdk_android_core_release(), "Configuration telemetry", CONFIGURATION_TELEMETRY_DELAY_MS, TimeUnit.MILLISECONDS, this.getInternalLogger(), runnable);
    }

    public final void stop$dd_sdk_android_core_release() {
        Map<String, SdkFeature> $this$forEach$iv = this.features;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, SdkFeature>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, SdkFeature> element$iv;
            Map.Entry<String, SdkFeature> it = element$iv = iterator.next();
            boolean bl = false;
            it.getValue().stop();
        }
        this.features.clear();
        if (this.context instanceof Application && this.processLifecycleMonitor != null) {
            ((Application)this.context).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.processLifecycleMonitor);
        }
        this.getCoreFeature$dd_sdk_android_core_release().stop();
        this.removeShutdownHook();
    }

    @WorkerThread
    public final void flushStoredData$dd_sdk_android_core_release() {
        this.getCoreFeature$dd_sdk_android_core_release().drainAndShutdownExecutors();
        Iterable $this$forEach$iv = this.features.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SdkFeature it = (SdkFeature)element$iv;
            boolean bl = false;
            it.flushStoredData$dd_sdk_android_core_release();
        }
    }

    private static final void clearAllData$lambda$2(DatadogCore this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getCoreFeature$dd_sdk_android_core_release().deleteLastViewEvent$dd_sdk_android_core_release();
        this$0.getCoreFeature$dd_sdk_android_core_release().deleteLastFatalAnrSent$dd_sdk_android_core_release();
    }

    private static final void setupShutdownHook$lambda$11(DatadogCore this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.stop$dd_sdk_android_core_release();
    }

    private static final void sendCoreConfigurationTelemetryEvent$lambda$12(DatadogCore this$0, Configuration $configuration) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$configuration, (String)"$configuration");
        FeatureScope featureScope = this$0.getFeature("rum");
        if (featureScope == null) {
            return;
        }
        FeatureScope rumFeature = featureScope;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"telemetry_configuration"), TuplesKt.to((Object)"track_errors", (Object)$configuration.getCrashReportsEnabled$dd_sdk_android_core_release()), TuplesKt.to((Object)"batch_size", (Object)$configuration.getCoreConfig$dd_sdk_android_core_release().getBatchSize().getWindowDurationMs$dd_sdk_android_core_release()), TuplesKt.to((Object)"batch_upload_frequency", (Object)$configuration.getCoreConfig$dd_sdk_android_core_release().getUploadFrequency().getBaseStepMs$dd_sdk_android_core_release()), TuplesKt.to((Object)"use_proxy", (Object)($configuration.getCoreConfig$dd_sdk_android_core_release().getProxy() != null ? 1 : 0)), TuplesKt.to((Object)"use_local_encryption", (Object)($configuration.getCoreConfig$dd_sdk_android_core_release().getEncryption() != null ? 1 : 0)), TuplesKt.to((Object)"batch_processing_level", (Object)$configuration.getCoreConfig$dd_sdk_android_core_release().getBatchProcessingLevel().getMaxBatchesPerUploadJob()), TuplesKt.to((Object)"use_persistence_strategy_factory", (Object)($configuration.getCoreConfig$dd_sdk_android_core_release().getPersistenceStrategyFactory() != null ? 1 : 0))};
        Map coreConfigurationEvent = MapsKt.mapOf((Pair[])pairArray);
        rumFeature.sendEvent(coreConfigurationEvent);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/datadog/android/core/internal/DatadogCore$Companion;", "", "()V", "CONFIGURATION_TELEMETRY_DELAY_MS", "", "getCONFIGURATION_TELEMETRY_DELAY_MS$dd_sdk_android_core_release", "()J", "ENV_NAME_VALIDATION_REG_EX", "", "EVENT_RECEIVER_ALREADY_EXISTS", "MESSAGE_ENV_NAME_NOT_VALID", "MISSING_FEATURE_FOR_CONTEXT_UPDATE_LISTENER", "MISSING_FEATURE_FOR_EVENT_RECEIVER", "NO_NEED_TO_WRITE_LAST_VIEW_EVENT", "SHUTDOWN_THREAD_NAME", "startupTimeNs", "getStartupTimeNs$dd_sdk_android_core_release", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getCONFIGURATION_TELEMETRY_DELAY_MS$dd_sdk_android_core_release() {
            return CONFIGURATION_TELEMETRY_DELAY_MS;
        }

        public final long getStartupTimeNs$dd_sdk_android_core_release() {
            return startupTimeNs;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

