/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.metrics;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.metrics.MethodCalledTelemetry;
import com.datadog.android.core.metrics.PerformanceMetric;
import java.lang.constant.Constable;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/core/internal/metrics/MethodCalledTelemetry;", "Lcom/datadog/android/core/metrics/PerformanceMetric;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "operationName", "", "callerClass", "startTime", "", "(Lcom/datadog/android/api/InternalLogger;Ljava/lang/String;Ljava/lang/String;J)V", "getCallerClass$dd_sdk_android_core_release", "()Ljava/lang/String;", "getInternalLogger$dd_sdk_android_core_release", "()Lcom/datadog/android/api/InternalLogger;", "getOperationName$dd_sdk_android_core_release", "getStartTime$dd_sdk_android_core_release", "()J", "stopAndSend", "", "isSuccessful", "", "Companion", "dd-sdk-android-core_release"})
public final class MethodCalledTelemetry
implements PerformanceMetric {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final String operationName;
    @NotNull
    private final String callerClass;
    private final long startTime;
    @NotNull
    public static final String METHOD_CALLED_METRIC_NAME = "[Mobile Metric] Method Called";
    @NotNull
    public static final String METRIC_TYPE_VALUE = "method called";
    @NotNull
    public static final String OPERATION_NAME = "operation_name";
    @NotNull
    public static final String CALLER_CLASS = "caller_class";
    @NotNull
    public static final String IS_SUCCESSFUL = "is_successful";
    @NotNull
    public static final String EXECUTION_TIME = "execution_time";

    public MethodCalledTelemetry(@NotNull InternalLogger internalLogger, @NotNull String operationName, @NotNull String callerClass, long startTime) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter((Object)callerClass, (String)"callerClass");
        this.internalLogger = internalLogger;
        this.operationName = operationName;
        this.callerClass = callerClass;
        this.startTime = startTime;
    }

    public /* synthetic */ MethodCalledTelemetry(InternalLogger internalLogger, String string, String string2, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            l = System.nanoTime();
        }
        this(internalLogger, string, string2, l);
    }

    @NotNull
    public final InternalLogger getInternalLogger$dd_sdk_android_core_release() {
        return this.internalLogger;
    }

    @NotNull
    public final String getOperationName$dd_sdk_android_core_release() {
        return this.operationName;
    }

    @NotNull
    public final String getCallerClass$dd_sdk_android_core_release() {
        return this.callerClass;
    }

    public final long getStartTime$dd_sdk_android_core_release() {
        return this.startTime;
    }

    @Override
    public void stopAndSend(boolean isSuccessful) {
        long executionTime = System.nanoTime() - this.startTime;
        Map additionalProperties = new LinkedHashMap();
        Constable constable = executionTime;
        additionalProperties.put(EXECUTION_TIME, constable);
        additionalProperties.put(OPERATION_NAME, this.operationName);
        additionalProperties.put(CALLER_CLASS, this.callerClass);
        constable = Boolean.valueOf(isSuccessful);
        additionalProperties.put(IS_SUCCESSFUL, constable);
        additionalProperties.put("metric_type", METRIC_TYPE_VALUE);
        this.internalLogger.logMetric((Function0<String>)((Function0)stopAndSend.1.INSTANCE), additionalProperties);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/android/core/internal/metrics/MethodCalledTelemetry$Companion;", "", "()V", "CALLER_CLASS", "", "EXECUTION_TIME", "IS_SUCCESSFUL", "METHOD_CALLED_METRIC_NAME", "METRIC_TYPE_VALUE", "OPERATION_NAME", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

