/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.batch;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.core.internal.persistence.file.batch.BatchFileReaderWriter;
import com.datadog.android.core.internal.persistence.file.batch.EncryptedBatchReaderWriter;
import com.datadog.android.security.Encryption;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0012H\u0017R\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/EncryptedBatchReaderWriter;", "Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReaderWriter;", "encryption", "Lcom/datadog/android/security/Encryption;", "delegate", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/security/Encryption;Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReaderWriter;Lcom/datadog/android/api/InternalLogger;)V", "getDelegate$dd_sdk_android_core_release", "()Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReaderWriter;", "getEncryption$dd_sdk_android_core_release", "()Lcom/datadog/android/security/Encryption;", "readData", "", "Lcom/datadog/android/api/storage/RawBatchEvent;", "file", "Ljava/io/File;", "writeData", "", "data", "append", "Companion", "dd-sdk-android-core_release"})
@SourceDebugExtension(value={"SMAP\nEncryptedBatchReaderWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptedBatchReaderWriter.kt\ncom/datadog/android/core/internal/persistence/file/batch/EncryptedBatchReaderWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1549#2:67\n1620#2,3:68\n*S KotlinDebug\n*F\n+ 1 EncryptedBatchReaderWriter.kt\ncom/datadog/android/core/internal/persistence/file/batch/EncryptedBatchReaderWriter\n*L\n53#1:67\n53#1:68,3\n*E\n"})
public final class EncryptedBatchReaderWriter
implements BatchFileReaderWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Encryption encryption;
    @NotNull
    private final BatchFileReaderWriter delegate;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    public static final String BAD_ENCRYPTION_RESULT_MESSAGE = "Encryption of non-empty data produced empty result, aborting write operation.";

    public EncryptedBatchReaderWriter(@NotNull Encryption encryption, @NotNull BatchFileReaderWriter delegate, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)encryption, (String)"encryption");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.encryption = encryption;
        this.delegate = delegate;
        this.internalLogger = internalLogger;
    }

    @NotNull
    public final Encryption getEncryption$dd_sdk_android_core_release() {
        return this.encryption;
    }

    @NotNull
    public final BatchFileReaderWriter getDelegate$dd_sdk_android_core_release() {
        return this.delegate;
    }

    @Override
    @WorkerThread
    public boolean writeData(@NotNull File file, @NotNull RawBatchEvent data, boolean append) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        RawBatchEvent encryptedRawBatchEvent = new RawBatchEvent(this.encryption.encrypt(data.getData()), this.encryption.encrypt(data.getMetadata()));
        if (!(data.getData().length == 0) && encryptedRawBatchEvent.getData().length == 0) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)writeData.1.INSTANCE, null, false, null, 56, null);
            return false;
        }
        return this.delegate.writeData(file, encryptedRawBatchEvent, append);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @WorkerThread
    @NotNull
    public List<RawBatchEvent> readData(@NotNull File file) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Iterable $this$map$iv = this.delegate.readData(file);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RawBatchEvent rawBatchEvent = (RawBatchEvent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new RawBatchEvent(!(it.getData().length == 0) ? this.encryption.decrypt(it.getData()) : it.getData(), !(it.getMetadata().length == 0) ? this.encryption.decrypt(it.getMetadata()) : it.getMetadata()));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/EncryptedBatchReaderWriter$Companion;", "", "()V", "BAD_ENCRYPTION_RESULT_MESSAGE", "", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

