/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.constraints;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.constraints.DataConstraints;
import com.datadog.android.core.constraints.DatadogDataConstraints;
import com.datadog.android.core.internal.utils.MapUtilsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u001a\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002JP\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u001a0\u0019\"\u0004\b\u0000\u0010\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u001a0\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u001fH\u0016J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u00062\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u0006H\u0016J(\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020#0\u00192\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020#0\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0005\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007j\u0002`\t0\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u000b\u00a8\u0006&"}, d2={"Lcom/datadog/android/core/constraints/DatadogDataConstraints;", "Lcom/datadog/android/core/constraints/DataConstraints;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/api/InternalLogger;)V", "tagTransforms", "", "Lkotlin/Function1;", "", "Lcom/datadog/android/core/internal/constraints/StringTransform;", "getTagTransforms$annotations", "()V", "convertAttributeKey", "rawKey", "prefixDotCount", "", "convertTag", "rawTag", "isKeyReserved", "", "tag", "resolveDiscardedAttrsWarning", "attributesGroupName", "discardedCount", "validateAttributes", "", "T", "attributes", "", "keyPrefix", "reservedKeys", "", "validateTags", "tags", "validateTimings", "", "timings", "Companion", "dd-sdk-android-core_release"})
@SourceDebugExtension(value={"SMAP\nDatadogDataConstraints.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatadogDataConstraints.kt\ncom/datadog/android/core/constraints/DatadogDataConstraints\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,222:1\n1603#2,9:223\n1855#2:232\n1856#2:234\n1612#2:235\n1238#2,4:255\n1789#2,3:259\n1#3:233\n1#3:236\n1#3:250\n1099#4,3:237\n970#4:262\n1041#4,3:263\n135#5,9:240\n215#5:249\n216#5:251\n144#5:252\n468#6:253\n414#6:254\n*S KotlinDebug\n*F\n+ 1 DatadogDataConstraints.kt\ncom/datadog/android/core/constraints/DatadogDataConstraints\n*L\n25#1:223,9\n25#1:232\n25#1:234\n25#1:235\n113#1:255,4\n167#1:259,3\n25#1:233\n63#1:250\n62#1:237,3\n190#1:262\n190#1:263,3\n63#1:240,9\n63#1:249\n63#1:251\n63#1:252\n113#1:253\n113#1:254\n*E\n"})
public final class DatadogDataConstraints
implements DataConstraints {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final List<Function1<String, String>> tagTransforms;
    private static final int MAX_TAG_LENGTH = 200;
    private static final int MAX_TAG_COUNT = 100;
    private static final int MAX_ATTR_COUNT = 128;
    private static final int MAX_DEPTH_LEVEL = 9;
    @NotNull
    public static final String CUSTOM_TIMING_KEY_REPLACED_WARNING = "Invalid timing name: %s, sanitized to: %s";
    @NotNull
    private static final Set<String> reservedTagKeys;

    public DatadogDataConstraints(@NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.internalLogger = internalLogger;
        Object[] objectArray = new Function1[]{tagTransforms.1.INSTANCE, tagTransforms.2.INSTANCE, tagTransforms.3.INSTANCE, tagTransforms.4.INSTANCE, tagTransforms.5.INSTANCE, new Function1<String, String>(this){
            final /* synthetic */ DatadogDataConstraints this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DatadogDataConstraints.access$isKeyReserved(this.this$0, it) ? null : it;
            }
        }};
        this.tagTransforms = CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> validateTags(@NotNull List<String> tags) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Iterable $this$mapNotNull$iv = tags;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String tag = this.convertTag(it);
            if (tag == null) {
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)new Function0<String>(it){
                    final /* synthetic */ String $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "\"" + this.$it + "\" is an invalid tag, and was ignored.";
                    }
                }, null, false, null, 56, null);
            } else if (!Intrinsics.areEqual((Object)tag, (Object)it)) {
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, (Function0)new Function0<String>(it, tag){
                    final /* synthetic */ String $it;
                    final /* synthetic */ String $tag;
                    {
                        this.$it = $it;
                        this.$tag = $tag;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "tag \"" + this.$it + "\" was modified to \"" + this.$tag + "\" to match our constraints.";
                    }
                }, null, true, null, 40, null);
            }
            if (tag == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List convertedTags2 = (List)destination$iv$iv;
        int discardedCount = convertedTags2.size() - 100;
        if (discardedCount > 0) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, (Function0)new Function0<String>(discardedCount){
                final /* synthetic */ int $discardedCount;
                {
                    this.$discardedCount = $discardedCount;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "too many tags were added, " + this.$discardedCount + " had to be discarded.";
                }
            }, null, false, null, 56, null);
        }
        return CollectionsKt.take((Iterable)convertedTags2, (int)100);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> Map<String, T> validateAttributes(@NotNull Map<String, ? extends T> attributes, @Nullable String keyPrefix, @Nullable String attributesGroupName, @NotNull Set<String> reservedKeys) {
        void $this$mapNotNullTo$iv$iv;
        int n;
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(reservedKeys, (String)"reservedKeys");
        String string = keyPrefix;
        if (string != null) {
            String it = string;
            boolean bl = false;
            CharSequence $this$count$iv = it;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char character = element$iv = $this$count$iv.charAt(i);
                boolean bl2 = false;
                if (!(character == '.')) continue;
                ++count$iv;
            }
            n = count$iv + 1;
        } else {
            n = 0;
        }
        int prefixDotCount = n;
        Map<String, ? extends T> $this$mapNotNull$iv = attributes;
        boolean $i$f$mapNotNull = false;
        Map<String, ? extends T> bl = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl3 = false;
            Map.Entry it = element$iv$iv;
            boolean bl4 = false;
            if (it.getKey() == null) {
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)new Function0<String>(it){
                    final /* synthetic */ Map.Entry<String, T> $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "\"" + this.$it + "\" is an invalid attribute, and was ignored.";
                    }
                }, null, false, null, 56, null);
                pair = null;
            } else if (reservedKeys.contains(it.getKey())) {
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)new Function0<String>(it){
                    final /* synthetic */ Map.Entry<String, T> $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "\"" + this.$it + "\" key was in the reservedKeys set, and was dropped.";
                    }
                }, null, false, null, 56, null);
                pair = null;
            } else {
                String key = this.convertAttributeKey((String)it.getKey(), prefixDotCount);
                if (!Intrinsics.areEqual((Object)key, it.getKey())) {
                    InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, (Function0)new Function0<String>(it, key){
                        final /* synthetic */ Map.Entry<String, T> $it;
                        final /* synthetic */ String $key;
                        {
                            this.$it = $it;
                            this.$key = $key;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Key \"" + this.$it.getKey() + "\" was modified to \"" + this.$key + "\" to match our constraints.";
                        }
                    }, null, false, null, 56, null);
                }
                pair = TuplesKt.to((Object)key, it.getValue());
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List convertedAttributes2 = (List)destination$iv$iv;
        int discardedCount = convertedAttributes2.size() - 128;
        if (discardedCount > 0) {
            String warningMessage = this.resolveDiscardedAttrsWarning(attributesGroupName, discardedCount);
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, (Function0)new Function0<String>(warningMessage){
                final /* synthetic */ String $warningMessage;
                {
                    this.$warningMessage = $warningMessage;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$warningMessage;
                }
            }, null, false, null, 56, null);
        }
        return MapUtilsKt.toMutableMap(CollectionsKt.take((Iterable)convertedAttributes2, (int)128));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Long> validateTimings(@NotNull Map<String, Long> timings) {
        void $this$mapKeysTo$iv$iv;
        Intrinsics.checkNotNullParameter(timings, (String)"timings");
        Map<String, Long> $this$mapKeys$iv = timings;
        boolean $i$f$mapKeys = false;
        Map<String, Long> map = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            String string;
            void entry;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Regex regex = new Regex("[^a-zA-Z0-9\\-_.@$]");
            CharSequence charSequence = (CharSequence)entry.getKey();
            String sanitizedKey = regex.replace(charSequence, string = "_");
            if (!Intrinsics.areEqual((Object)sanitizedKey, entry.getKey())) {
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, (Function0)new Function0<String>((Map.Entry<String, Long>)entry, sanitizedKey){
                    final /* synthetic */ Map.Entry<String, Long> $entry;
                    final /* synthetic */ String $sanitizedKey;
                    {
                        this.$entry = $entry;
                        this.$sanitizedKey = $sanitizedKey;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        String string = "Invalid timing name: %s, sanitized to: %s";
                        Locale locale = Locale.US;
                        Object[] objectArray = new Object[]{this.$entry.getKey(), this.$sanitizedKey};
                        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                        return string2;
                    }
                }, null, false, null, 56, null);
            }
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            String string2 = sanitizedKey;
            Map map3 = map2;
            boolean bl2 = false;
            Object v = it$iv$iv.getValue();
            map3.put(string2, v);
        }
        return MapsKt.toMutableMap((Map)destination$iv$iv);
    }

    private final String resolveDiscardedAttrsWarning(String attributesGroupName, int discardedCount) {
        return attributesGroupName != null ? "Too many attributes were added for [" + attributesGroupName + "], " + discardedCount + " had to be discarded." : "Too many attributes were added, " + discardedCount + " had to be discarded.";
    }

    private static /* synthetic */ void getTagTransforms$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    private final String convertTag(String rawTag) {
        Iterable $this$fold$iv = this.tagTransforms;
        boolean $i$f$fold = false;
        String accumulator$iv = rawTag;
        for (Object element$iv : $this$fold$iv) {
            void transform;
            Function1 function1 = (Function1)element$iv;
            String tag = accumulator$iv;
            boolean bl = false;
            String string = tag;
            accumulator$iv = string == null ? null : (String)transform.invoke((Object)string);
        }
        return accumulator$iv;
    }

    private final boolean isKeyReserved(String tag) {
        boolean bl;
        int firstColon = StringsKt.indexOf$default((CharSequence)tag, (char)':', (int)0, (boolean)false, (int)6, null);
        if (firstColon > 0) {
            String string = tag.substring(0, firstColon);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String key = string;
            bl = reservedTagKeys.contains(key);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final String convertAttributeKey(String rawKey, int prefixDotCount) {
        void $this$mapTo$iv$iv;
        int dotCount = 0;
        dotCount = prefixDotCount;
        CharSequence $this$map$iv = rawKey;
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
            void it;
            char item$iv$iv;
            char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf((char)(it == 46 ? (++dotCount > 9 ? 95 : it) : it)));
        }
        List mapped = (List)destination$iv$iv;
        return new String(CollectionsKt.toCharArray((Collection)mapped));
    }

    public static final /* synthetic */ boolean access$isKeyReserved(DatadogDataConstraints $this, String tag) {
        return $this.isKeyReserved(tag);
    }

    static {
        Object[] objectArray = new String[]{"host", "device", "source", "service"};
        reservedTagKeys = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/core/constraints/DatadogDataConstraints$Companion;", "", "()V", "CUSTOM_TIMING_KEY_REPLACED_WARNING", "", "MAX_ATTR_COUNT", "", "MAX_DEPTH_LEVEL", "MAX_TAG_COUNT", "MAX_TAG_LENGTH", "reservedTagKeys", "", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

