/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.data.upload;

import android.net.TrafficStats;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.net.Request;
import com.datadog.android.api.net.RequestExecutionContext;
import com.datadog.android.api.net.RequestFactory;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.core.internal.data.upload.DataOkHttpUploader;
import com.datadog.android.core.internal.data.upload.DataUploader;
import com.datadog.android.core.internal.data.upload.UploadStatus;
import com.datadog.android.core.internal.persistence.BatchId;
import com.datadog.android.core.internal.system.AndroidInfoProvider;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0000\u0018\u0000 ;2\u00020\u0001:\u0001;B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\tH\u0002J\u0010\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020+H\u0002J\u0012\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0018H\u0002J\u0018\u0010/\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u00101\u001a\u00020\t2\b\u0010(\u001a\u0004\u0018\u00010\tH\u0002J2\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u000207062\b\u00108\u001a\u0004\u0018\u0001092\b\u0010:\u001a\u0004\u0018\u00010\u0018H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010\u001d\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006<"}, d2={"Lcom/datadog/android/core/internal/data/upload/DataOkHttpUploader;", "Lcom/datadog/android/core/internal/data/upload/DataUploader;", "requestFactory", "Lcom/datadog/android/api/net/RequestFactory;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "callFactory", "Lokhttp3/Call$Factory;", "sdkVersion", "", "androidInfoProvider", "Lcom/datadog/android/core/internal/system/AndroidInfoProvider;", "(Lcom/datadog/android/api/net/RequestFactory;Lcom/datadog/android/api/InternalLogger;Lokhttp3/Call$Factory;Ljava/lang/String;Lcom/datadog/android/core/internal/system/AndroidInfoProvider;)V", "getAndroidInfoProvider", "()Lcom/datadog/android/core/internal/system/AndroidInfoProvider;", "attempts", "", "getCallFactory", "()Lokhttp3/Call$Factory;", "getInternalLogger", "()Lcom/datadog/android/api/InternalLogger;", "previousUploadStatus", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "previousUploadedBatchId", "Lcom/datadog/android/core/internal/persistence/BatchId;", "getRequestFactory", "()Lcom/datadog/android/api/net/RequestFactory;", "getSdkVersion", "()Ljava/lang/String;", "userAgent", "getUserAgent", "userAgent$delegate", "Lkotlin/Lazy;", "buildOkHttpRequest", "Lokhttp3/Request;", "request", "Lcom/datadog/android/api/net/Request;", "executeUploadRequest", "isValidHeaderValue", "", "value", "isValidHeaderValueChar", "c", "", "resolveExecutionContext", "Lcom/datadog/android/api/net/RequestExecutionContext;", "batchID", "responseCodeToUploadStatus", "code", "sanitizeHeaderValue", "upload", "context", "Lcom/datadog/android/api/context/DatadogContext;", "batch", "", "Lcom/datadog/android/api/storage/RawBatchEvent;", "batchMeta", "", "batchId", "Companion", "dd-sdk-android-core_release"})
@SourceDebugExtension(value={"SMAP\nDataOkHttpUploader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataOkHttpUploader.kt\ncom/datadog/android/core/internal/data/upload/DataOkHttpUploader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,256:1\n288#2,2:257\n429#3:259\n502#3,5:260\n1064#3,2:265\n*S KotlinDebug\n*F\n+ 1 DataOkHttpUploader.kt\ncom/datadog/android/core/internal/data/upload/DataOkHttpUploader\n*L\n142#1:257,2\n189#1:259\n189#1:260,5\n193#1:265,2\n*E\n"})
public final class DataOkHttpUploader
implements DataUploader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RequestFactory requestFactory;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final Call.Factory callFactory;
    @NotNull
    private final String sdkVersion;
    @NotNull
    private final AndroidInfoProvider androidInfoProvider;
    private volatile int attempts;
    @Nullable
    private volatile UploadStatus previousUploadStatus;
    @Nullable
    private volatile BatchId previousUploadedBatchId;
    @NotNull
    private final Lazy userAgent$delegate;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_CLIENT_TIMEOUT = 408;
    public static final int HTTP_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_TOO_MANY_REQUESTS = 429;
    public static final int HTTP_INTERNAL_ERROR = 500;
    public static final int HTTP_BAD_GATEWAY = 502;
    public static final int HTTP_UNAVAILABLE = 503;
    public static final int HTTP_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_INSUFFICIENT_STORAGE = 507;
    @NotNull
    public static final String SYSTEM_UA = "http.agent";
    @NotNull
    public static final String WARNING_USER_AGENT_HEADER_RESERVED = "Ignoring provided User-Agent header, because it is reserved.";
    @NotNull
    public static final String HEADER_USER_AGENT = "User-Agent";

    public DataOkHttpUploader(@NotNull RequestFactory requestFactory, @NotNull InternalLogger internalLogger, @NotNull Call.Factory callFactory, @NotNull String sdkVersion, @NotNull AndroidInfoProvider androidInfoProvider) {
        Intrinsics.checkNotNullParameter((Object)requestFactory, (String)"requestFactory");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)callFactory, (String)"callFactory");
        Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
        Intrinsics.checkNotNullParameter((Object)androidInfoProvider, (String)"androidInfoProvider");
        this.requestFactory = requestFactory;
        this.internalLogger = internalLogger;
        this.callFactory = callFactory;
        this.sdkVersion = sdkVersion;
        this.androidInfoProvider = androidInfoProvider;
        this.attempts = 1;
        this.userAgent$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DataOkHttpUploader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                Object object;
                CharSequence charSequence = DataOkHttpUploader.access$sanitizeHeaderValue(this.this$0, System.getProperty("http.agent"));
                DataOkHttpUploader dataOkHttpUploader = this.this$0;
                if (StringsKt.isBlank((CharSequence)charSequence)) {
                    boolean bl = false;
                    object = "Datadog/" + dataOkHttpUploader.getSdkVersion() + " (Linux; U; Android " + dataOkHttpUploader.getAndroidInfoProvider().getOsVersion() + "; " + dataOkHttpUploader.getAndroidInfoProvider().getDeviceModel() + " Build/" + dataOkHttpUploader.getAndroidInfoProvider().getDeviceBuildId() + ")";
                } else {
                    object = charSequence;
                }
                return (String)object;
            }
        }));
    }

    @NotNull
    public final RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @NotNull
    public final InternalLogger getInternalLogger() {
        return this.internalLogger;
    }

    @NotNull
    public final Call.Factory getCallFactory() {
        return this.callFactory;
    }

    @NotNull
    public final String getSdkVersion() {
        return this.sdkVersion;
    }

    @NotNull
    public final AndroidInfoProvider getAndroidInfoProvider() {
        return this.androidInfoProvider;
    }

    @Override
    @NotNull
    public UploadStatus upload(@NotNull DatadogContext context, @NotNull List<RawBatchEvent> batch, @Nullable byte[] batchMeta, @Nullable BatchId batchId) {
        UploadStatus uploadStatus2;
        Request request2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(batch, (String)"batch");
        RequestExecutionContext executionContext = this.resolveExecutionContext(batchId);
        try {
            Request request3 = this.requestFactory.create(context, executionContext, batch, batchMeta);
            if (request3 == null) {
                return new UploadStatus.RequestCreationError(null);
            }
            request2 = request3;
        }
        catch (Exception e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)upload.request.1.INSTANCE, (Throwable)e, false, null, 48, null);
            return new UploadStatus.RequestCreationError(e);
        }
        Request request4 = request2;
        try {
            uploadStatus2 = this.executeUploadRequest(request4);
        }
        catch (UnknownHostException e) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)new Function0<String>(context){
                final /* synthetic */ DatadogContext $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Unable to find host for site " + this.$context.getSite() + "; we will retry later.";
                }
            }, (Throwable)e, false, null, 48, null);
            uploadStatus2 = new UploadStatus.DNSError(e);
        }
        catch (IOException e) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)upload.uploadStatus.2.INSTANCE, (Throwable)e, false, null, 48, null);
            uploadStatus2 = new UploadStatus.NetworkError(e);
        }
        catch (Throwable e) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)upload.uploadStatus.3.INSTANCE, e, false, null, 48, null);
            uploadStatus2 = new UploadStatus.UnknownException(e);
        }
        UploadStatus uploadStatus3 = uploadStatus2;
        uploadStatus3.logStatus(request4.getDescription(), request4.getBody().length, this.internalLogger, executionContext.getAttemptNumber(), request4.getId());
        this.previousUploadStatus = uploadStatus3;
        return uploadStatus3;
    }

    private final String getUserAgent() {
        Lazy lazy = this.userAgent$delegate;
        return (String)lazy.getValue();
    }

    private final RequestExecutionContext resolveExecutionContext(BatchId batchID) {
        Integer previousResponseCode = null;
        if (batchID != null && this.previousUploadedBatchId != null && Intrinsics.areEqual((Object)this.previousUploadedBatchId, (Object)batchID)) {
            int n = this.attempts;
            this.attempts = n + 1;
            UploadStatus uploadStatus2 = this.previousUploadStatus;
            previousResponseCode = uploadStatus2 != null ? Integer.valueOf(uploadStatus2.getCode()) : null;
        } else {
            this.attempts = 1;
            previousResponseCode = null;
        }
        this.previousUploadedBatchId = batchID;
        return new RequestExecutionContext(this.attempts, previousResponseCode);
    }

    /*
     * WARNING - void declaration
     */
    private final UploadStatus executeUploadRequest(Request request2) {
        String apiKey;
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Iterable iterable = request2.getHeaders().entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)((String)it.getKey()), (String)"DD-API-KEY", (boolean)true)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        String string = apiKey = entry != null ? (String)entry.getValue() : null;
        if (apiKey != null && (((CharSequence)apiKey).length() == 0 || !this.isValidHeaderValue(apiKey))) {
            return new UploadStatus.InvalidTokenError(0);
        }
        okhttp3.Request okHttpRequest = this.buildOkHttpRequest(request2);
        TrafficStats.setThreadStatsTag((int)((int)Thread.currentThread().getId()));
        Call call = this.callFactory.newCall(okHttpRequest);
        Response response = call.execute();
        response.close();
        return this.responseCodeToUploadStatus(response.code(), request2);
    }

    private final okhttp3.Request buildOkHttpRequest(Request request2) {
        MediaType mediaType = request2.getContentType() == null ? null : MediaType.Companion.parse(request2.getContentType());
        Request.Builder builder = new Request.Builder().url(request2.getUrl()).post(RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])request2.getBody(), (MediaType)mediaType, (int)0, (int)0, (int)6, null));
        for (Map.Entry<String, String> entry : request2.getHeaders().entrySet()) {
            String header = entry.getKey();
            String value = entry.getValue();
            String string = header;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (Intrinsics.areEqual((Object)string2, (Object)"user-agent")) {
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.MAINTAINER, (Function0)buildOkHttpRequest.1.INSTANCE, null, false, null, 56, null);
                continue;
            }
            builder.addHeader(header, value);
        }
        builder.addHeader(HEADER_USER_AGENT, this.getUserAgent());
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final String sanitizeHeaderValue(String value) {
        String string;
        String string2;
        String string3 = value;
        if (string3 != null) {
            void $this$filterTo$iv$iv;
            String $this$filter$iv = string3;
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (!this.isValidHeaderValueChar(it)) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string4 = ((StringBuilder)destination$iv$iv).toString();
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "";
        }
        return string;
    }

    private final boolean isValidHeaderValue(String value) {
        boolean bl;
        block1: {
            CharSequence $this$all$iv = value;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (this.isValidHeaderValueChar(it)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidHeaderValueChar(char c) {
        if (c == '\t') return true;
        if (' ' > c) return false;
        if (c >= '\u007f') return false;
        return true;
    }

    private final UploadStatus responseCodeToUploadStatus(int code, Request request2) {
        UploadStatus uploadStatus2;
        switch (code) {
            case 202: {
                uploadStatus2 = new UploadStatus.Success(code);
                break;
            }
            case 401: 
            case 403: {
                uploadStatus2 = new UploadStatus.InvalidTokenError(code);
                break;
            }
            case 408: 
            case 429: {
                uploadStatus2 = new UploadStatus.HttpClientRateLimiting(code);
                break;
            }
            case 400: 
            case 413: {
                uploadStatus2 = new UploadStatus.HttpClientError(code);
                break;
            }
            case 500: 
            case 502: 
            case 503: 
            case 504: 
            case 507: {
                uploadStatus2 = new UploadStatus.HttpServerError(code);
                break;
            }
            default: {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(code, request2){
                    final /* synthetic */ int $code;
                    final /* synthetic */ Request $request;
                    {
                        this.$code = $code;
                        this.$request = $request;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Unexpected status code " + this.$code + " on upload request: " + this.$request.getDescription();
                    }
                }, null, false, null, 56, null);
                uploadStatus2 = new UploadStatus.UnknownHttpError(code);
            }
        }
        return uploadStatus2;
    }

    public static final /* synthetic */ String access$sanitizeHeaderValue(DataOkHttpUploader $this, String value) {
        return $this.sanitizeHeaderValue(value);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/datadog/android/core/internal/data/upload/DataOkHttpUploader$Companion;", "", "()V", "HEADER_USER_AGENT", "", "HTTP_ACCEPTED", "", "HTTP_BAD_GATEWAY", "HTTP_BAD_REQUEST", "HTTP_CLIENT_TIMEOUT", "HTTP_ENTITY_TOO_LARGE", "HTTP_FORBIDDEN", "HTTP_GATEWAY_TIMEOUT", "HTTP_INSUFFICIENT_STORAGE", "HTTP_INTERNAL_ERROR", "HTTP_TOO_MANY_REQUESTS", "HTTP_UNAUTHORIZED", "HTTP_UNAVAILABLE", "SYSTEM_UA", "WARNING_USER_AGENT_HEADER_RESERVED", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

