/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.data.upload;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.context.NetworkInfo;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.core.configuration.UploadSchedulerStrategy;
import com.datadog.android.core.internal.ContextProvider;
import com.datadog.android.core.internal.data.upload.DataUploader;
import com.datadog.android.core.internal.data.upload.UploadRunnable;
import com.datadog.android.core.internal.data.upload.UploadStatus;
import com.datadog.android.core.internal.metrics.RemovalReason;
import com.datadog.android.core.internal.net.info.NetworkInfoProvider;
import com.datadog.android.core.internal.persistence.BatchData;
import com.datadog.android.core.internal.persistence.BatchId;
import com.datadog.android.core.internal.persistence.Storage;
import com.datadog.android.core.internal.system.SystemInfo;
import com.datadog.android.core.internal.system.SystemInfoProvider;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u0000 /2\u00020\u0001:\u0001/BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J0\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\b\u0010$\u001a\u0004\u0018\u00010%H\u0003J\u0012\u0010&\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0003J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020+H\u0017J\u0010\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00060"}, d2={"Lcom/datadog/android/core/internal/data/upload/DataUploadRunnable;", "Lcom/datadog/android/core/internal/data/upload/UploadRunnable;", "featureName", "", "threadPoolExecutor", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "storage", "Lcom/datadog/android/core/internal/persistence/Storage;", "dataUploader", "Lcom/datadog/android/core/internal/data/upload/DataUploader;", "contextProvider", "Lcom/datadog/android/core/internal/ContextProvider;", "networkInfoProvider", "Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;", "systemInfoProvider", "Lcom/datadog/android/core/internal/system/SystemInfoProvider;", "uploadSchedulerStrategy", "Lcom/datadog/android/core/configuration/UploadSchedulerStrategy;", "maxBatchesPerJob", "", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Ljava/lang/String;Ljava/util/concurrent/ScheduledThreadPoolExecutor;Lcom/datadog/android/core/internal/persistence/Storage;Lcom/datadog/android/core/internal/data/upload/DataUploader;Lcom/datadog/android/core/internal/ContextProvider;Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;Lcom/datadog/android/core/internal/system/SystemInfoProvider;Lcom/datadog/android/core/configuration/UploadSchedulerStrategy;ILcom/datadog/android/api/InternalLogger;)V", "getMaxBatchesPerJob$dd_sdk_android_core_release", "()I", "getUploadSchedulerStrategy$dd_sdk_android_core_release", "()Lcom/datadog/android/core/configuration/UploadSchedulerStrategy;", "consumeBatch", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "context", "Lcom/datadog/android/api/context/DatadogContext;", "batchId", "Lcom/datadog/android/core/internal/persistence/BatchId;", "batch", "", "Lcom/datadog/android/api/storage/RawBatchEvent;", "batchMeta", "", "handleNextBatch", "isNetworkAvailable", "", "isSystemReady", "run", "", "scheduleNextUpload", "delayMs", "", "Companion", "dd-sdk-android-core_release"})
public final class DataUploadRunnable
implements UploadRunnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String featureName;
    @NotNull
    private final ScheduledThreadPoolExecutor threadPoolExecutor;
    @NotNull
    private final Storage storage;
    @NotNull
    private final DataUploader dataUploader;
    @NotNull
    private final ContextProvider contextProvider;
    @NotNull
    private final NetworkInfoProvider networkInfoProvider;
    @NotNull
    private final SystemInfoProvider systemInfoProvider;
    @NotNull
    private final UploadSchedulerStrategy uploadSchedulerStrategy;
    private final int maxBatchesPerJob;
    @NotNull
    private final InternalLogger internalLogger;
    public static final int LOW_BATTERY_THRESHOLD = 10;

    public DataUploadRunnable(@NotNull String featureName, @NotNull ScheduledThreadPoolExecutor threadPoolExecutor, @NotNull Storage storage, @NotNull DataUploader dataUploader, @NotNull ContextProvider contextProvider, @NotNull NetworkInfoProvider networkInfoProvider, @NotNull SystemInfoProvider systemInfoProvider, @NotNull UploadSchedulerStrategy uploadSchedulerStrategy, int maxBatchesPerJob, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter((Object)threadPoolExecutor, (String)"threadPoolExecutor");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)dataUploader, (String)"dataUploader");
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        Intrinsics.checkNotNullParameter((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkNotNullParameter((Object)systemInfoProvider, (String)"systemInfoProvider");
        Intrinsics.checkNotNullParameter((Object)uploadSchedulerStrategy, (String)"uploadSchedulerStrategy");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.featureName = featureName;
        this.threadPoolExecutor = threadPoolExecutor;
        this.storage = storage;
        this.dataUploader = dataUploader;
        this.contextProvider = contextProvider;
        this.networkInfoProvider = networkInfoProvider;
        this.systemInfoProvider = systemInfoProvider;
        this.uploadSchedulerStrategy = uploadSchedulerStrategy;
        this.maxBatchesPerJob = maxBatchesPerJob;
        this.internalLogger = internalLogger;
    }

    @NotNull
    public final UploadSchedulerStrategy getUploadSchedulerStrategy$dd_sdk_android_core_release() {
        return this.uploadSchedulerStrategy;
    }

    public final int getMaxBatchesPerJob$dd_sdk_android_core_release() {
        return this.maxBatchesPerJob;
    }

    @Override
    @WorkerThread
    public void run() {
        int uploadAttempts = 0;
        UploadStatus lastBatchUploadStatus = null;
        if (this.isNetworkAvailable() && this.isSystemReady()) {
            DatadogContext context = this.contextProvider.getContext();
            int batchConsumerAvailableAttempts = this.maxBatchesPerJob;
            do {
                --batchConsumerAvailableAttempts;
                lastBatchUploadStatus = this.handleNextBatch(context);
                if (lastBatchUploadStatus == null) continue;
                ++uploadAttempts;
            } while (batchConsumerAvailableAttempts > 0 && lastBatchUploadStatus instanceof UploadStatus.Success);
        }
        UploadStatus uploadStatus2 = lastBatchUploadStatus;
        UploadStatus uploadStatus3 = lastBatchUploadStatus;
        long delayMs = this.uploadSchedulerStrategy.getMsDelayUntilNextUpload(this.featureName, uploadAttempts, uploadStatus2 != null ? Integer.valueOf(uploadStatus2.getCode()) : null, uploadStatus3 != null ? uploadStatus3.getThrowable() : null);
        this.scheduleNextUpload(delayMs);
    }

    @WorkerThread
    private final UploadStatus handleNextBatch(DatadogContext context) {
        UploadStatus uploadStatus2 = null;
        BatchData nextBatchData = this.storage.readNextBatch();
        if (nextBatchData != null) {
            uploadStatus2 = this.consumeBatch(context, nextBatchData.getId(), nextBatchData.getData(), nextBatchData.getMetadata());
        }
        return uploadStatus2;
    }

    private final boolean isNetworkAvailable() {
        NetworkInfo networkInfo = this.networkInfoProvider.getLatestNetworkInfo();
        return networkInfo.getConnectivity() != NetworkInfo.Connectivity.NETWORK_NOT_CONNECTED;
    }

    private final boolean isSystemReady() {
        SystemInfo systemInfo = this.systemInfoProvider.getLatestSystemInfo();
        boolean hasEnoughPower = systemInfo.getBatteryFullOrCharging() || systemInfo.getOnExternalPowerSource() || systemInfo.getBatteryLevel() > 10;
        return hasEnoughPower && !systemInfo.getPowerSaveMode();
    }

    private final void scheduleNextUpload(long delayMs) {
        this.threadPoolExecutor.remove(this);
        ConcurrencyExtKt.scheduleSafe(this.threadPoolExecutor, this.featureName + ": data upload", delayMs, TimeUnit.MILLISECONDS, this.internalLogger, this);
    }

    @WorkerThread
    private final UploadStatus consumeBatch(DatadogContext context, BatchId batchId, List<RawBatchEvent> batch, byte[] batchMeta) {
        UploadStatus status = this.dataUploader.upload(context, batch, batchMeta, batchId);
        RemovalReason removalReason = status instanceof UploadStatus.RequestCreationError ? (RemovalReason)RemovalReason.Invalid.INSTANCE : (RemovalReason)new RemovalReason.IntakeCode(status.getCode());
        this.storage.confirmBatchRead(batchId, removalReason, !status.getShouldRetry());
        return status;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/DataUploadRunnable$Companion;", "", "()V", "LOW_BATTERY_THRESHOLD", "", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

