/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.data.upload;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.configuration.UploadSchedulerStrategy;
import com.datadog.android.core.internal.ContextProvider;
import com.datadog.android.core.internal.data.upload.DataUploadRunnable;
import com.datadog.android.core.internal.data.upload.DataUploader;
import com.datadog.android.core.internal.data.upload.UploadScheduler;
import com.datadog.android.core.internal.net.info.NetworkInfoProvider;
import com.datadog.android.core.internal.persistence.Storage;
import com.datadog.android.core.internal.system.SystemInfoProvider;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/datadog/android/core/internal/data/upload/DataUploadScheduler;", "Lcom/datadog/android/core/internal/data/upload/UploadScheduler;", "featureName", "", "storage", "Lcom/datadog/android/core/internal/persistence/Storage;", "dataUploader", "Lcom/datadog/android/core/internal/data/upload/DataUploader;", "contextProvider", "Lcom/datadog/android/core/internal/ContextProvider;", "networkInfoProvider", "Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;", "systemInfoProvider", "Lcom/datadog/android/core/internal/system/SystemInfoProvider;", "uploadSchedulerStrategy", "Lcom/datadog/android/core/configuration/UploadSchedulerStrategy;", "maxBatchesPerJob", "", "scheduledThreadPoolExecutor", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Ljava/lang/String;Lcom/datadog/android/core/internal/persistence/Storage;Lcom/datadog/android/core/internal/data/upload/DataUploader;Lcom/datadog/android/core/internal/ContextProvider;Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;Lcom/datadog/android/core/internal/system/SystemInfoProvider;Lcom/datadog/android/core/configuration/UploadSchedulerStrategy;ILjava/util/concurrent/ScheduledThreadPoolExecutor;Lcom/datadog/android/api/InternalLogger;)V", "runnable", "Lcom/datadog/android/core/internal/data/upload/DataUploadRunnable;", "getRunnable$dd_sdk_android_core_release", "()Lcom/datadog/android/core/internal/data/upload/DataUploadRunnable;", "startScheduling", "", "stopScheduling", "dd-sdk-android-core_release"})
public final class DataUploadScheduler
implements UploadScheduler {
    @NotNull
    private final String featureName;
    @NotNull
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final DataUploadRunnable runnable;

    public DataUploadScheduler(@NotNull String featureName, @NotNull Storage storage, @NotNull DataUploader dataUploader, @NotNull ContextProvider contextProvider, @NotNull NetworkInfoProvider networkInfoProvider, @NotNull SystemInfoProvider systemInfoProvider, @NotNull UploadSchedulerStrategy uploadSchedulerStrategy, int maxBatchesPerJob, @NotNull ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)dataUploader, (String)"dataUploader");
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        Intrinsics.checkNotNullParameter((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkNotNullParameter((Object)systemInfoProvider, (String)"systemInfoProvider");
        Intrinsics.checkNotNullParameter((Object)uploadSchedulerStrategy, (String)"uploadSchedulerStrategy");
        Intrinsics.checkNotNullParameter((Object)scheduledThreadPoolExecutor, (String)"scheduledThreadPoolExecutor");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.featureName = featureName;
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
        this.internalLogger = internalLogger;
        this.runnable = new DataUploadRunnable(this.featureName, this.scheduledThreadPoolExecutor, storage, dataUploader, contextProvider, networkInfoProvider, systemInfoProvider, uploadSchedulerStrategy, maxBatchesPerJob, this.internalLogger);
    }

    @NotNull
    public final DataUploadRunnable getRunnable$dd_sdk_android_core_release() {
        return this.runnable;
    }

    @Override
    public void startScheduling() {
        ConcurrencyExtKt.executeSafe(this.scheduledThreadPoolExecutor, this.featureName + ": data upload", this.internalLogger, this.runnable);
    }

    @Override
    public void stopScheduling() {
        this.scheduledThreadPoolExecutor.remove(this.runnable);
    }
}

