/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.data.upload;

import com.datadog.android.api.InternalLogger;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u001f2\u00020\u0001:\r\u001f !\"#$%&'()*+B'\b\u0004\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ4\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J2\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0001\f,-./01234567\u00a8\u00068"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "", "shouldRetry", "", "code", "", "throwable", "", "(ZILjava/lang/Throwable;)V", "getCode", "()I", "getShouldRetry", "()Z", "getThrowable", "()Ljava/lang/Throwable;", "buildStatusMessage", "", "requestId", "byteSize", "context", "requestAttempts", "logStatus", "", "logger", "Lcom/datadog/android/api/InternalLogger;", "attempts", "resolveInternalLogLevel", "Lcom/datadog/android/api/InternalLogger$Level;", "resolveInternalLogTarget", "", "Lcom/datadog/android/api/InternalLogger$Target;", "Companion", "DNSError", "HttpClientError", "HttpClientRateLimiting", "HttpRedirection", "HttpServerError", "InvalidTokenError", "NetworkError", "RequestCreationError", "Success", "UnknownException", "UnknownHttpError", "UnknownStatus", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$DNSError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$HttpClientError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$HttpClientRateLimiting;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$HttpRedirection;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$HttpServerError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$InvalidTokenError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$NetworkError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$RequestCreationError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$Success;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$UnknownException;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$UnknownHttpError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$UnknownStatus;", "dd-sdk-android-core_release"})
public abstract class UploadStatus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean shouldRetry;
    private final int code;
    @Nullable
    private final Throwable throwable;
    public static final int UNKNOWN_RESPONSE_CODE = 0;
    @NotNull
    public static final String ATTEMPTS_LOG_MESSAGE_FORMAT = " This request was attempted %d time(s).";

    private UploadStatus(boolean shouldRetry, int code, Throwable throwable) {
        this.shouldRetry = shouldRetry;
        this.code = code;
        this.throwable = throwable;
    }

    public /* synthetic */ UploadStatus(boolean bl, int n, Throwable throwable, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            throwable = null;
        }
        this(bl, n, throwable, null);
    }

    public final boolean getShouldRetry() {
        return this.shouldRetry;
    }

    public final int getCode() {
        return this.code;
    }

    @Nullable
    public final Throwable getThrowable() {
        return this.throwable;
    }

    public final void logStatus(@NotNull String context, int byteSize, @NotNull InternalLogger logger, int attempts, @Nullable String requestId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        InternalLogger.Level level = this.resolveInternalLogLevel();
        List<InternalLogger.Target> targets = this.resolveInternalLogTarget();
        InternalLogger.DefaultImpls.log$default(logger, level, targets, (Function0)new Function0<String>(this, requestId, byteSize, context, attempts){
            final /* synthetic */ UploadStatus this$0;
            final /* synthetic */ String $requestId;
            final /* synthetic */ int $byteSize;
            final /* synthetic */ String $context;
            final /* synthetic */ int $attempts;
            {
                this.this$0 = $receiver;
                this.$requestId = $requestId;
                this.$byteSize = $byteSize;
                this.$context = $context;
                this.$attempts = $attempts;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return UploadStatus.access$buildStatusMessage(this.this$0, this.$requestId, this.$byteSize, this.$context, this.this$0.getThrowable(), this.$attempts);
            }
        }, null, false, null, 56, null);
    }

    public static /* synthetic */ void logStatus$default(UploadStatus uploadStatus2, String string, int n, InternalLogger internalLogger, int n2, String string2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: logStatus");
        }
        if ((n3 & 0x10) != 0) {
            string2 = null;
        }
        uploadStatus2.logStatus(string, n, internalLogger, n2, string2);
    }

    private final List<InternalLogger.Target> resolveInternalLogTarget() {
        List list;
        UploadStatus uploadStatus2 = this;
        if ((uploadStatus2 instanceof HttpClientError ? true : uploadStatus2 instanceof HttpClientRateLimiting) ? true : uploadStatus2 instanceof UnknownStatus) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY};
            list = CollectionsKt.listOf((Object[])targetArray);
        } else if ((((((((uploadStatus2 instanceof DNSError ? true : uploadStatus2 instanceof HttpRedirection) ? true : uploadStatus2 instanceof HttpServerError) ? true : uploadStatus2 instanceof InvalidTokenError) ? true : uploadStatus2 instanceof NetworkError) ? true : uploadStatus2 instanceof RequestCreationError) ? true : uploadStatus2 instanceof Success) ? true : uploadStatus2 instanceof UnknownException) ? true : uploadStatus2 instanceof UnknownHttpError) {
            list = CollectionsKt.listOf((Object)((Object)InternalLogger.Target.USER));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final InternalLogger.Level resolveInternalLogLevel() {
        InternalLogger.Level level;
        UploadStatus uploadStatus2 = this;
        if (((((uploadStatus2 instanceof HttpClientError ? true : uploadStatus2 instanceof HttpServerError) ? true : uploadStatus2 instanceof InvalidTokenError) ? true : uploadStatus2 instanceof RequestCreationError) ? true : uploadStatus2 instanceof UnknownException) ? true : uploadStatus2 instanceof UnknownHttpError) {
            level = InternalLogger.Level.ERROR;
        } else if ((((uploadStatus2 instanceof DNSError ? true : uploadStatus2 instanceof HttpClientRateLimiting) ? true : uploadStatus2 instanceof HttpRedirection) ? true : uploadStatus2 instanceof UnknownStatus) ? true : uploadStatus2 instanceof NetworkError) {
            level = InternalLogger.Level.WARN;
        } else if (uploadStatus2 instanceof Success) {
            level = InternalLogger.Level.INFO;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return level;
    }

    private final String buildStatusMessage(String requestId, int byteSize, String context, Throwable throwable, int requestAttempts) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildStatusMessage_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (requestId == null) {
            $this$buildStatusMessage_u24lambda_u240.append("Batch [" + byteSize + " bytes] (" + context + ")");
        } else {
            $this$buildStatusMessage_u24lambda_u240.append("Batch " + requestId + " [" + byteSize + " bytes] (" + context + ")");
        }
        Object object = this;
        if (object instanceof DNSError) {
            $this$buildStatusMessage_u24lambda_u240.append(" failed because of a DNS error");
        } else if (object instanceof HttpClientError) {
            $this$buildStatusMessage_u24lambda_u240.append(" failed because of a processing error or invalid data");
        } else if (object instanceof HttpClientRateLimiting) {
            $this$buildStatusMessage_u24lambda_u240.append(" failed because of an intake rate limitation");
        } else if (object instanceof HttpRedirection) {
            $this$buildStatusMessage_u24lambda_u240.append(" failed because of a network redirection");
        } else if (object instanceof HttpServerError) {
            $this$buildStatusMessage_u24lambda_u240.append(" failed because of a server processing error");
        } else if (object instanceof InvalidTokenError) {
            $this$buildStatusMessage_u24lambda_u240.append(" failed because your token is invalid");
        } else if (object instanceof NetworkError) {
            $this$buildStatusMessage_u24lambda_u240.append(" failed because of a network error");
        } else if (object instanceof RequestCreationError) {
            $this$buildStatusMessage_u24lambda_u240.append(" failed because of an error when creating the request");
        } else if (object instanceof UnknownException) {
            $this$buildStatusMessage_u24lambda_u240.append(" failed because of an unknown error");
        } else if (object instanceof UnknownHttpError) {
            $this$buildStatusMessage_u24lambda_u240.append(" failed because of an unexpected HTTP error (status code = " + this.code + ")");
        } else if (object instanceof UnknownStatus) {
            $this$buildStatusMessage_u24lambda_u240.append(" status is unknown");
        } else if (object instanceof Success) {
            $this$buildStatusMessage_u24lambda_u240.append(" sent successfully.");
        }
        if (throwable != null) {
            $this$buildStatusMessage_u24lambda_u240.append(" (");
            $this$buildStatusMessage_u24lambda_u240.append(throwable.getClass().getName());
            $this$buildStatusMessage_u24lambda_u240.append(": ");
            $this$buildStatusMessage_u24lambda_u240.append(throwable.getMessage());
            $this$buildStatusMessage_u24lambda_u240.append(")");
        }
        if (this.shouldRetry) {
            $this$buildStatusMessage_u24lambda_u240.append("; we will retry later.");
        } else if (!(this instanceof Success)) {
            $this$buildStatusMessage_u24lambda_u240.append("; the batch was dropped.");
        }
        if (this instanceof InvalidTokenError) {
            $this$buildStatusMessage_u24lambda_u240.append(" Make sure that the provided token still exists and you're targeting the relevant Datadog site.");
        }
        object = ATTEMPTS_LOG_MESSAGE_FORMAT;
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{requestAttempts, this.code};
        String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        $this$buildStatusMessage_u24lambda_u240.append(string);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String buildString = string2;
        return buildString;
    }

    public /* synthetic */ UploadStatus(boolean shouldRetry, int code, Throwable throwable, DefaultConstructorMarker $constructor_marker) {
        this(shouldRetry, code, throwable);
    }

    public static final /* synthetic */ String access$buildStatusMessage(UploadStatus $this, String requestId, int byteSize, String context, Throwable throwable, int requestAttempts) {
        return $this.buildStatusMessage(requestId, byteSize, context, throwable, requestAttempts);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$Companion;", "", "()V", "ATTEMPTS_LOG_MESSAGE_FORMAT", "", "UNKNOWN_RESPONSE_CODE", "", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$DNSError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "throwable", "", "(Ljava/lang/Throwable;)V", "dd-sdk-android-core_release"})
    public static final class DNSError
    extends UploadStatus {
        public DNSError(@NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            super(true, 0, throwable, 2, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$HttpClientError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "responseCode", "", "(I)V", "dd-sdk-android-core_release"})
    public static final class HttpClientError
    extends UploadStatus {
        public HttpClientError(int responseCode) {
            super(false, responseCode, null, 4, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$HttpClientRateLimiting;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "responseCode", "", "(I)V", "dd-sdk-android-core_release"})
    public static final class HttpClientRateLimiting
    extends UploadStatus {
        public HttpClientRateLimiting(int responseCode) {
            super(true, responseCode, null, 4, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$HttpRedirection;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "responseCode", "", "(I)V", "dd-sdk-android-core_release"})
    public static final class HttpRedirection
    extends UploadStatus {
        public HttpRedirection(int responseCode) {
            super(false, responseCode, null, 4, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$HttpServerError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "responseCode", "", "(I)V", "dd-sdk-android-core_release"})
    public static final class HttpServerError
    extends UploadStatus {
        public HttpServerError(int responseCode) {
            super(true, responseCode, null, 4, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$InvalidTokenError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "responseCode", "", "(I)V", "dd-sdk-android-core_release"})
    public static final class InvalidTokenError
    extends UploadStatus {
        public InvalidTokenError(int responseCode) {
            super(false, responseCode, null, 4, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$NetworkError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "throwable", "", "(Ljava/lang/Throwable;)V", "dd-sdk-android-core_release"})
    public static final class NetworkError
    extends UploadStatus {
        public NetworkError(@NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            super(true, 0, throwable, 2, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$RequestCreationError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "throwable", "", "(Ljava/lang/Throwable;)V", "dd-sdk-android-core_release"})
    public static final class RequestCreationError
    extends UploadStatus {
        public RequestCreationError(@Nullable Throwable throwable) {
            super(false, 0, throwable, 2, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$Success;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "responseCode", "", "(I)V", "dd-sdk-android-core_release"})
    public static final class Success
    extends UploadStatus {
        public Success(int responseCode) {
            super(false, responseCode, null, 4, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$UnknownException;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "throwable", "", "(Ljava/lang/Throwable;)V", "dd-sdk-android-core_release"})
    public static final class UnknownException
    extends UploadStatus {
        public UnknownException(@NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            super(true, 0, throwable, 2, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$UnknownHttpError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "responseCode", "", "(I)V", "dd-sdk-android-core_release"})
    public static final class UnknownHttpError
    extends UploadStatus {
        public UnknownHttpError(int responseCode) {
            super(false, responseCode, null, 4, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$UnknownStatus;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "()V", "dd-sdk-android-core_release"})
    public static final class UnknownStatus
    extends UploadStatus {
        @NotNull
        public static final UnknownStatus INSTANCE = new UnknownStatus();

        private UnknownStatus() {
            super(false, 0, null, 4, null);
        }
    }
}

