/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.logger;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.core.internal.logger.LogcatLogHandler;
import com.datadog.android.core.internal.metrics.MethodCalledTelemetry;
import com.datadog.android.core.metrics.PerformanceMetric;
import com.datadog.android.core.metrics.TelemetryMetricType;
import com.datadog.android.core.sampling.RateBasedSampler;
import com.datadog.android.internal.telemetry.InternalTelemetryEvent;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 B2\u00020\u0001:\u0001BB1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\bJ5\u0010\u0013\u001a\u00020\u00142\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJP\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0018\u00010'H\u0016JV\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020 0)2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0018\u00010'H\u0016J\u001e\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u001a2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0005H\u0016JC\u0010.\u001a\u00020\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00170'2\u0006\u0010+\u001a\u00020\u001a2\b\u0010/\u001a\u0004\u0018\u00010\u001aH\u0016\u00a2\u0006\u0002\u00100J0\u00101\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\b\u00102\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0002JH\u00103\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\b\u00102\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0018\u00010'H\u0002J0\u00104\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\b\u00102\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0002J\u000e\u00105\u001a\u00020%2\u0006\u0010+\u001a\u00020\u001aJF\u00106\u001a\u00020\u00142\u0006\u00107\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\b\u00102\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J*\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020=2\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010>\u001a\u00020\u000eH\u0016J\f\u0010?\u001a\u00020@*\u00020\u001eH\u0002J\f\u0010A\u001a\u00020\u000e*\u00020\u000eH\u0002R\u0016\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006C"}, d2={"Lcom/datadog/android/core/internal/logger/SdkInternalLogger;", "Lcom/datadog/android/api/InternalLogger;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "userLogHandlerFactory", "Lkotlin/Function0;", "Lcom/datadog/android/core/internal/logger/LogcatLogHandler;", "maintainerLogHandlerFactory", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "maintainerLogger", "getMaintainerLogger$dd_sdk_android_core_release", "()Lcom/datadog/android/core/internal/logger/LogcatLogHandler;", "onlyOnceMaintainerMessages", "", "", "onlyOnceTelemetryMessages", "onlyOnceUserMessages", "userLogger", "getUserLogger$dd_sdk_android_core_release", "enrichWithNonNullValue", "", "map", "", "", "key", "value", "", "(Ljava/util/Map;Ljava/lang/String;Ljava/lang/Float;)V", "log", "level", "Lcom/datadog/android/api/InternalLogger$Level;", "target", "Lcom/datadog/android/api/InternalLogger$Target;", "messageBuilder", "throwable", "", "onlyOnce", "", "additionalProperties", "", "targets", "", "logApiUsage", "samplingRate", "apiUsageEventBuilder", "Lcom/datadog/android/internal/telemetry/InternalTelemetryEvent$ApiUsage;", "logMetric", "creationSampleRate", "(Lkotlin/jvm/functions/Function0;Ljava/util/Map;FLjava/lang/Float;)V", "logToMaintainer", "error", "logToTelemetry", "logToUser", "sample", "sendToLogHandler", "handler", "knownSingleMessages", "startPerformanceMeasure", "Lcom/datadog/android/core/metrics/PerformanceMetric;", "callerClass", "metric", "Lcom/datadog/android/core/metrics/TelemetryMetricType;", "operationName", "toLogLevel", "", "withSdkName", "Companion", "dd-sdk-android-core_release"})
@SourceDebugExtension(value={"SMAP\nSdkInternalLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkInternalLogger.kt\ncom/datadog/android/core/internal/logger/SdkInternalLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,300:1\n1855#2,2:301\n*S KotlinDebug\n*F\n+ 1 SdkInternalLogger.kt\ncom/datadog/android/core/internal/logger/SdkInternalLogger\n*L\n91#1:301,2\n*E\n"})
public final class SdkInternalLogger
implements InternalLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final LogcatLogHandler userLogger;
    @Nullable
    private final LogcatLogHandler maintainerLogger;
    @NotNull
    private final Set<String> onlyOnceUserMessages;
    @NotNull
    private final Set<String> onlyOnceMaintainerMessages;
    @NotNull
    private final Set<String> onlyOnceTelemetryMessages;
    @NotNull
    public static final String SDK_LOG_TAG = "DD_LOG";
    @NotNull
    public static final String DEV_LOG_TAG = "Datadog";

    public SdkInternalLogger(@Nullable FeatureSdkCore sdkCore, @NotNull Function0<LogcatLogHandler> userLogHandlerFactory, @NotNull Function0<LogcatLogHandler> maintainerLogHandlerFactory) {
        Intrinsics.checkNotNullParameter(userLogHandlerFactory, (String)"userLogHandlerFactory");
        Intrinsics.checkNotNullParameter(maintainerLogHandlerFactory, (String)"maintainerLogHandlerFactory");
        this.sdkCore = sdkCore;
        this.userLogger = (LogcatLogHandler)userLogHandlerFactory.invoke();
        this.maintainerLogger = (LogcatLogHandler)maintainerLogHandlerFactory.invoke();
        this.onlyOnceUserMessages = new LinkedHashSet();
        this.onlyOnceMaintainerMessages = new LinkedHashSet();
        this.onlyOnceTelemetryMessages = new LinkedHashSet();
    }

    public /* synthetic */ SdkInternalLogger(FeatureSdkCore featureSdkCore, Function0 function0, Function0 function02, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function02 = 2.INSTANCE;
        }
        this(featureSdkCore, (Function0<LogcatLogHandler>)function0, (Function0<LogcatLogHandler>)function02);
    }

    @NotNull
    public final LogcatLogHandler getUserLogger$dd_sdk_android_core_release() {
        return this.userLogger;
    }

    @Nullable
    public final LogcatLogHandler getMaintainerLogger$dd_sdk_android_core_release() {
        return this.maintainerLogger;
    }

    @Override
    public void log(@NotNull InternalLogger.Level level, @NotNull InternalLogger.Target target, @NotNull Function0<String> messageBuilder, @Nullable Throwable throwable, boolean onlyOnce, @Nullable Map<String, ? extends Object> additionalProperties) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)((Object)target), (String)"target");
        Intrinsics.checkNotNullParameter(messageBuilder, (String)"messageBuilder");
        switch (WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
            case 1: {
                this.logToUser(level, messageBuilder, throwable, onlyOnce);
                break;
            }
            case 2: {
                this.logToMaintainer(level, messageBuilder, throwable, onlyOnce);
                break;
            }
            case 3: {
                this.logToTelemetry(level, messageBuilder, throwable, onlyOnce, additionalProperties);
            }
        }
    }

    @Override
    public void log(@NotNull InternalLogger.Level level, @NotNull List<? extends InternalLogger.Target> targets, @NotNull Function0<String> messageBuilder, @Nullable Throwable throwable, boolean onlyOnce, @Nullable Map<String, ? extends Object> additionalProperties) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter(messageBuilder, (String)"messageBuilder");
        Iterable $this$forEach$iv = targets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InternalLogger.Target it = (InternalLogger.Target)((Object)element$iv);
            boolean bl = false;
            this.log(level, it, messageBuilder, throwable, onlyOnce, additionalProperties);
        }
    }

    @Override
    public void logMetric(@NotNull Function0<String> messageBuilder, @NotNull Map<String, ? extends Object> additionalProperties, float samplingRate, @Nullable Float creationSampleRate) {
        Intrinsics.checkNotNullParameter(messageBuilder, (String)"messageBuilder");
        Intrinsics.checkNotNullParameter(additionalProperties, (String)"additionalProperties");
        if (!this.sample(samplingRate)) {
            return;
        }
        Object object = this.sdkCore;
        if (object == null || (object = object.getFeature("rum")) == null) {
            return;
        }
        Object rumFeature = object;
        Map additionalPropertiesMutable = MapsKt.toMutableMap(additionalProperties);
        this.enrichWithNonNullValue(additionalPropertiesMutable, "HEAD_SAMPLING_RATE_KEY", creationSampleRate);
        this.enrichWithNonNullValue(additionalPropertiesMutable, "TAIL_SAMPLING_RATE_KEY", Float.valueOf(samplingRate));
        InternalTelemetryEvent.Metric metricEvent = new InternalTelemetryEvent.Metric((String)messageBuilder.invoke(), additionalPropertiesMutable);
        rumFeature.sendEvent(metricEvent);
    }

    @Override
    @Nullable
    public PerformanceMetric startPerformanceMeasure(@NotNull String callerClass, @NotNull TelemetryMetricType metric, float samplingRate, @NotNull String operationName) {
        Intrinsics.checkNotNullParameter((Object)callerClass, (String)"callerClass");
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        if (!this.sample(samplingRate)) {
            return null;
        }
        if (WhenMappings.$EnumSwitchMapping$1[metric.ordinal()] != 1) {
            throw new NoWhenBranchMatchedException();
        }
        return new MethodCalledTelemetry(this, operationName, callerClass, samplingRate, 0L, 16, null);
    }

    @Override
    public void logApiUsage(float samplingRate, @NotNull Function0<? extends InternalTelemetryEvent.ApiUsage> apiUsageEventBuilder) {
        Intrinsics.checkNotNullParameter(apiUsageEventBuilder, (String)"apiUsageEventBuilder");
        if (!this.sample(samplingRate)) {
            return;
        }
        Object object = this.sdkCore;
        if (object == null || (object = object.getFeature("rum")) == null) {
            return;
        }
        Object rumFeature = object;
        InternalTelemetryEvent.ApiUsage event = (InternalTelemetryEvent.ApiUsage)apiUsageEventBuilder.invoke();
        this.enrichWithNonNullValue(event.getAdditionalProperties(), "TAIL_SAMPLING_RATE_KEY", Float.valueOf(samplingRate));
        rumFeature.sendEvent(event);
    }

    public final boolean sample(float samplingRate) {
        return new RateBasedSampler<Unit>(samplingRate).sample(Unit.INSTANCE);
    }

    private final void logToUser(InternalLogger.Level level, Function0<String> messageBuilder, Throwable error, boolean onlyOnce) {
        this.sendToLogHandler(this.userLogger, level, messageBuilder, error, onlyOnce, this.onlyOnceUserMessages);
    }

    private final void logToMaintainer(InternalLogger.Level level, Function0<String> messageBuilder, Throwable error, boolean onlyOnce) {
        block0: {
            LogcatLogHandler logcatLogHandler = this.maintainerLogger;
            if (logcatLogHandler == null) break block0;
            LogcatLogHandler it = logcatLogHandler;
            boolean bl = false;
            this.sendToLogHandler(it, level, messageBuilder, error, onlyOnce, this.onlyOnceMaintainerMessages);
        }
    }

    private final void sendToLogHandler(LogcatLogHandler handler, InternalLogger.Level level, Function0<String> messageBuilder, Throwable error, boolean onlyOnce, Set<String> knownSingleMessages) {
        if (!handler.canLog(this.toLogLevel(level))) {
            return;
        }
        String message = this.withSdkName((String)messageBuilder.invoke());
        if (onlyOnce) {
            if (knownSingleMessages.contains(message)) {
                return;
            }
            knownSingleMessages.add(message);
        }
        handler.log(this.toLogLevel(level), message, error);
    }

    private final void logToTelemetry(InternalLogger.Level level, Function0<String> messageBuilder, Throwable error, boolean onlyOnce, Map<String, ? extends Object> additionalProperties) {
        Object object = this.sdkCore;
        if (object == null || (object = object.getFeature("rum")) == null) {
            return;
        }
        Object rumFeature = object;
        String message = (String)messageBuilder.invoke();
        if (onlyOnce) {
            if (this.onlyOnceTelemetryMessages.contains(message)) {
                return;
            }
            this.onlyOnceTelemetryMessages.add(message);
        }
        InternalTelemetryEvent.Log telemetryEvent = level == InternalLogger.Level.ERROR || level == InternalLogger.Level.WARN || error != null ? (InternalTelemetryEvent.Log)new InternalTelemetryEvent.Log.Error(message, additionalProperties, error, null, null, 24, null) : (InternalTelemetryEvent.Log)new InternalTelemetryEvent.Log.Debug(message, additionalProperties);
        rumFeature.sendEvent(telemetryEvent);
    }

    private final int toLogLevel(InternalLogger.Level $this$toLogLevel) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$2[$this$toLogLevel.ordinal()]) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = 5;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final String withSdkName(String $this$withSdkName) {
        FeatureSdkCore featureSdkCore = this.sdkCore;
        String instanceName = featureSdkCore != null ? featureSdkCore.getName() : null;
        return instanceName != null ? "[" + instanceName + "]: " + $this$withSdkName : $this$withSdkName;
    }

    private final void enrichWithNonNullValue(Map<String, Object> map, String key, Float value) {
        if (value == null) {
            return;
        }
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/core/internal/logger/SdkInternalLogger$Companion;", "", "()V", "DEV_LOG_TAG", "", "SDK_LOG_TAG", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[InternalLogger.Target.values().length];
            try {
                nArray[InternalLogger.Target.USER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalLogger.Target.MAINTAINER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalLogger.Target.TELEMETRY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TelemetryMetricType.values().length];
            try {
                nArray[TelemetryMetricType.MethodCalled.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[InternalLogger.Level.values().length];
            try {
                nArray[InternalLogger.Level.VERBOSE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalLogger.Level.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalLogger.Level.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalLogger.Level.WARN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalLogger.Level.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

