/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.metrics;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.configuration.DataUploadConfiguration;
import com.datadog.android.core.internal.lifecycle.ProcessLifecycleMonitor;
import com.datadog.android.core.internal.metrics.BatchClosedMetadata;
import com.datadog.android.core.internal.metrics.BatchMetricsDispatcher;
import com.datadog.android.core.internal.metrics.MetricsDispatcher;
import com.datadog.android.core.internal.metrics.RemovalReason;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.FilePersistenceConfig;
import com.datadog.android.core.internal.persistence.file.advanced.FeatureFileOrchestrator;
import com.datadog.android.core.internal.time.TimeProvider;
import com.datadog.android.core.metrics.MethodCallSamplingRate;
import com.datadog.android.privacy.TrackingConsent;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\b\u0000\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J(\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J(\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0018\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001fH\u0016J\u001b\u0010%\u001a\u0004\u0018\u00010&*\u00020\u001a2\u0006\u0010'\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010(J\u000e\u0010)\u001a\u0004\u0018\u00010\u0004*\u00020\u001aH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/datadog/android/core/internal/metrics/BatchMetricsDispatcher;", "Lcom/datadog/android/core/internal/metrics/MetricsDispatcher;", "Lcom/datadog/android/core/internal/lifecycle/ProcessLifecycleMonitor$Callback;", "featureName", "", "uploadConfiguration", "Lcom/datadog/android/core/internal/configuration/DataUploadConfiguration;", "filePersistenceConfig", "Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "dateTimeProvider", "Lcom/datadog/android/core/internal/time/TimeProvider;", "(Ljava/lang/String;Lcom/datadog/android/core/internal/configuration/DataUploadConfiguration;Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/core/internal/time/TimeProvider;)V", "isInBackground", "Ljava/util/concurrent/atomic/AtomicBoolean;", "trackName", "onPaused", "", "onResumed", "onStarted", "onStopped", "resolveBatchClosedMetricAttributes", "", "", "file", "Ljava/io/File;", "batchMetadata", "Lcom/datadog/android/core/internal/metrics/BatchClosedMetadata;", "resolveBatchDeletedMetricAttributes", "deletionReason", "Lcom/datadog/android/core/internal/metrics/RemovalReason;", "resolveTrackName", "sendBatchClosedMetric", "batchFile", "sendBatchDeletedMetric", "removalReason", "nameAsTimestampSafe", "", "logger", "(Ljava/io/File;Lcom/datadog/android/api/InternalLogger;)Ljava/lang/Long;", "resolveFileOriginAsConsent", "Companion", "dd-sdk-android-core_release"})
public final class BatchMetricsDispatcher
implements MetricsDispatcher,
ProcessLifecycleMonitor.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final DataUploadConfiguration uploadConfiguration;
    @NotNull
    private final FilePersistenceConfig filePersistenceConfig;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final TimeProvider dateTimeProvider;
    @Nullable
    private final String trackName;
    @NotNull
    private final AtomicBoolean isInBackground;
    @NotNull
    public static final String RUM_TRACK_NAME = "rum";
    @NotNull
    public static final String LOGS_TRACK_NAME = "logs";
    @NotNull
    public static final String TRACE_TRACK_NAME = "trace";
    @NotNull
    public static final String SR_TRACK_NAME = "sr";
    @NotNull
    public static final String SR_RESOURCES_TRACK_NAME = "sr-resources";
    @NotNull
    public static final String WRONG_FILE_NAME_MESSAGE_FORMAT = "Unable to parse the file name as a timestamp: %s";
    @NotNull
    public static final String TYPE_KEY = "metric_type";
    @NotNull
    public static final String TRACK_KEY = "track";
    @NotNull
    public static final String UPLOADER_WINDOW_KEY = "uploader_window";
    @NotNull
    public static final String UPLOADER_DELAY_KEY = "uploader_delay";
    @NotNull
    public static final String UPLOADER_DELAY_MAX_KEY = "max";
    @NotNull
    public static final String UPLOADER_DELAY_MIN_KEY = "min";
    @NotNull
    public static final String BATCH_AGE_KEY = "batch_age";
    @NotNull
    public static final String BATCH_REMOVAL_KEY = "batch_removal_reason";
    @NotNull
    public static final String IN_BACKGROUND_KEY = "in_background";
    @NotNull
    public static final String BATCH_DELETED_MESSAGE = "[Mobile Metric] Batch Deleted";
    @NotNull
    public static final String BATCH_DELETED_TYPE_VALUE = "batch deleted";
    @NotNull
    public static final String BATCH_SIZE_KEY = "batch_size";
    @NotNull
    public static final String BATCH_EVENTS_COUNT_KEY = "batch_events_count";
    @NotNull
    public static final String BATCH_DURATION_KEY = "batch_duration";
    @NotNull
    public static final String FORCE_NEW_KEY = "forced_new";
    @NotNull
    public static final String BATCH_CLOSED_MESSAGE = "[Mobile Metric] Batch Closed";
    @NotNull
    public static final String BATCH_CLOSED_TYPE_VALUE = "batch closed";
    @NotNull
    public static final String TRACKING_CONSENT_KEY = "consent";
    @NotNull
    public static final String FILE_NAME = "filename";
    @NotNull
    public static final String THREAD_NAME = "thread";

    public BatchMetricsDispatcher(@NotNull String featureName, @Nullable DataUploadConfiguration uploadConfiguration, @NotNull FilePersistenceConfig filePersistenceConfig, @NotNull InternalLogger internalLogger, @NotNull TimeProvider dateTimeProvider) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter((Object)filePersistenceConfig, (String)"filePersistenceConfig");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)dateTimeProvider, (String)"dateTimeProvider");
        this.uploadConfiguration = uploadConfiguration;
        this.filePersistenceConfig = filePersistenceConfig;
        this.internalLogger = internalLogger;
        this.dateTimeProvider = dateTimeProvider;
        this.trackName = this.resolveTrackName(featureName);
        this.isInBackground = new AtomicBoolean(true);
    }

    @Override
    public void sendBatchDeletedMetric(@NotNull File batchFile, @NotNull RemovalReason removalReason) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)batchFile, (String)"batchFile");
            Intrinsics.checkNotNullParameter((Object)removalReason, (String)"removalReason");
            if (!removalReason.includeInMetrics$dd_sdk_android_core_release() || this.trackName == null) {
                return;
            }
            Map<String, Object> map = this.resolveBatchDeletedMetricAttributes(batchFile, removalReason);
            if (map == null) break block1;
            Map<String, Object> it = map;
            boolean bl = false;
            InternalLogger.DefaultImpls.logMetric$default(this.internalLogger, sendBatchDeletedMetric.1.1.INSTANCE, it, MethodCallSamplingRate.LOW.getRate(), null, 8, null);
        }
    }

    @Override
    public void sendBatchClosedMetric(@NotNull File batchFile, @NotNull BatchClosedMetadata batchMetadata) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)batchFile, (String)"batchFile");
            Intrinsics.checkNotNullParameter((Object)batchMetadata, (String)"batchMetadata");
            if (this.trackName == null || !FileExtKt.existsSafe(batchFile, this.internalLogger)) {
                return;
            }
            Map<String, Object> map = this.resolveBatchClosedMetricAttributes(batchFile, batchMetadata);
            if (map == null) break block1;
            Map<String, Object> it = map;
            boolean bl = false;
            InternalLogger.DefaultImpls.logMetric$default(this.internalLogger, sendBatchClosedMetric.1.1.INSTANCE, it, MethodCallSamplingRate.LOW.getRate(), null, 8, null);
        }
    }

    @Override
    public void onStarted() {
    }

    @Override
    public void onResumed() {
        this.isInBackground.set(false);
    }

    @Override
    public void onStopped() {
    }

    @Override
    public void onPaused() {
        this.isInBackground.set(true);
    }

    private final Map<String, Object> resolveBatchDeletedMetricAttributes(File file, RemovalReason deletionReason) {
        Long l = this.nameAsTimestampSafe(file, this.internalLogger);
        if (l == null) {
            return null;
        }
        long fileCreationTimestamp = l;
        long fileAgeInMillis = this.dateTimeProvider.getDeviceTimestamp() - fileCreationTimestamp;
        if (fileAgeInMillis < 0L) {
            return null;
        }
        Pair[] pairArray = new Pair[10];
        pairArray[0] = TuplesKt.to((Object)TRACK_KEY, (Object)this.trackName);
        pairArray[1] = TuplesKt.to((Object)TYPE_KEY, (Object)BATCH_DELETED_TYPE_VALUE);
        pairArray[2] = TuplesKt.to((Object)BATCH_AGE_KEY, (Object)fileAgeInMillis);
        Pair[] pairArray2 = new Pair[2];
        DataUploadConfiguration dataUploadConfiguration = this.uploadConfiguration;
        pairArray2[0] = TuplesKt.to((Object)UPLOADER_DELAY_MIN_KEY, (Object)(dataUploadConfiguration != null ? Long.valueOf(dataUploadConfiguration.getMinDelayMs$dd_sdk_android_core_release()) : null));
        DataUploadConfiguration dataUploadConfiguration2 = this.uploadConfiguration;
        pairArray2[1] = TuplesKt.to((Object)UPLOADER_DELAY_MAX_KEY, (Object)(dataUploadConfiguration2 != null ? Long.valueOf(dataUploadConfiguration2.getMaxDelayMs$dd_sdk_android_core_release()) : null));
        pairArray[3] = TuplesKt.to((Object)UPLOADER_DELAY_KEY, (Object)MapsKt.mapOf((Pair[])pairArray2));
        pairArray[4] = TuplesKt.to((Object)UPLOADER_WINDOW_KEY, (Object)this.filePersistenceConfig.getRecentDelayMs());
        pairArray[5] = TuplesKt.to((Object)BATCH_REMOVAL_KEY, (Object)deletionReason.toString());
        pairArray[6] = TuplesKt.to((Object)IN_BACKGROUND_KEY, (Object)this.isInBackground.get());
        pairArray[7] = TuplesKt.to((Object)TRACKING_CONSENT_KEY, (Object)this.resolveFileOriginAsConsent(file));
        pairArray[8] = TuplesKt.to((Object)FILE_NAME, (Object)file.getName());
        pairArray[9] = TuplesKt.to((Object)THREAD_NAME, (Object)Thread.currentThread().getName());
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Map<String, Object> resolveBatchClosedMetricAttributes(File file, BatchClosedMetadata batchMetadata) {
        Long l = this.nameAsTimestampSafe(file, this.internalLogger);
        if (l == null) {
            return null;
        }
        long fileCreationTimestamp = l;
        long batchDurationInMs = batchMetadata.getLastTimeWasUsedInMs$dd_sdk_android_core_release() - fileCreationTimestamp;
        if (batchDurationInMs < 0L) {
            return null;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)TRACK_KEY, (Object)this.trackName), TuplesKt.to((Object)TYPE_KEY, (Object)BATCH_CLOSED_TYPE_VALUE), TuplesKt.to((Object)BATCH_DURATION_KEY, (Object)batchDurationInMs), TuplesKt.to((Object)UPLOADER_WINDOW_KEY, (Object)this.filePersistenceConfig.getRecentDelayMs()), TuplesKt.to((Object)BATCH_SIZE_KEY, (Object)FileExtKt.lengthSafe(file, this.internalLogger)), TuplesKt.to((Object)BATCH_EVENTS_COUNT_KEY, (Object)batchMetadata.getEventsCount$dd_sdk_android_core_release()), TuplesKt.to((Object)FORCE_NEW_KEY, (Object)batchMetadata.getForcedNew$dd_sdk_android_core_release()), TuplesKt.to((Object)TRACKING_CONSENT_KEY, (Object)this.resolveFileOriginAsConsent(file)), TuplesKt.to((Object)FILE_NAME, (Object)file.getName()), TuplesKt.to((Object)THREAD_NAME, (Object)Thread.currentThread().getName())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Long nameAsTimestampSafe(File $this$nameAsTimestampSafe, InternalLogger logger) {
        String string = $this$nameAsTimestampSafe.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
        Long timestamp = StringsKt.toLongOrNull((String)string);
        if (timestamp == null) {
            InternalLogger.DefaultImpls.log$default(logger, InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, (Function0)new Function0<String>($this$nameAsTimestampSafe){
                final /* synthetic */ File $this_nameAsTimestampSafe;
                {
                    this.$this_nameAsTimestampSafe = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Unable to parse the file name as a timestamp: %s";
                    Locale locale = Locale.ENGLISH;
                    Object[] objectArray = new Object[]{this.$this_nameAsTimestampSafe.getName()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }, null, false, null, 56, null);
        }
        return timestamp;
    }

    private final String resolveTrackName(String featureName) {
        String string;
        switch (featureName) {
            case "rum": {
                string = RUM_TRACK_NAME;
                break;
            }
            case "logs": {
                string = LOGS_TRACK_NAME;
                break;
            }
            case "tracing": {
                string = TRACE_TRACK_NAME;
                break;
            }
            case "session-replay": {
                string = SR_TRACK_NAME;
                break;
            }
            case "session-replay-resources": {
                string = SR_RESOURCES_TRACK_NAME;
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    private final String resolveFileOriginAsConsent(File $this$resolveFileOriginAsConsent) {
        String string;
        File file = $this$resolveFileOriginAsConsent.getParentFile();
        String string2 = file != null ? file.getName() : null;
        if (string2 == null) {
            return null;
        }
        String fileDirectory = string2;
        CharSequence charSequence = fileDirectory;
        if (FeatureFileOrchestrator.Companion.getIS_PENDING_DIR_REG_EX$dd_sdk_android_core_release().matches(charSequence)) {
            charSequence = TrackingConsent.PENDING.toString();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string3 = ((String)charSequence).toLowerCase(locale);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            charSequence = fileDirectory;
            if (FeatureFileOrchestrator.Companion.getIS_GRANTED_DIR_REG_EX$dd_sdk_android_core_release().matches(charSequence)) {
                charSequence = TrackingConsent.GRANTED.toString();
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string4 = ((String)charSequence).toLowerCase(locale);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            } else {
                string = null;
            }
        }
        return string;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001a\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/datadog/android/core/internal/metrics/BatchMetricsDispatcher$Companion;", "", "()V", "BATCH_AGE_KEY", "", "BATCH_CLOSED_MESSAGE", "BATCH_CLOSED_TYPE_VALUE", "BATCH_DELETED_MESSAGE", "BATCH_DELETED_TYPE_VALUE", "BATCH_DURATION_KEY", "BATCH_EVENTS_COUNT_KEY", "BATCH_REMOVAL_KEY", "BATCH_SIZE_KEY", "FILE_NAME", "FORCE_NEW_KEY", "IN_BACKGROUND_KEY", "LOGS_TRACK_NAME", "RUM_TRACK_NAME", "SR_RESOURCES_TRACK_NAME", "SR_TRACK_NAME", "THREAD_NAME", "TRACE_TRACK_NAME", "TRACKING_CONSENT_KEY", "TRACK_KEY", "TYPE_KEY", "UPLOADER_DELAY_KEY", "UPLOADER_DELAY_MAX_KEY", "UPLOADER_DELAY_MIN_KEY", "UPLOADER_WINDOW_KEY", "WRONG_FILE_NAME_MESSAGE_FORMAT", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

